/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorUnaryNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@GeneratedBy(value=LLVMVectorUnaryNode.class)
public final class LLVMVectorUnaryNodeGen
extends LLVMVectorUnaryNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode operandNode_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMVectorUnaryNodeGen(int vectorLength, LLVMUnaryNode unaryNode, LLVMExpressionNode operandNode) {
        super(vectorLength, unaryNode);
        this.operandNode_ = operandNode;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof LLVMI1Vector) {
            LLVMI1Vector operandNodeValue__ = (LLVMI1Vector)operandNodeValue_;
            return this.doI1(operandNodeValue__);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof LLVMI8Vector) {
            LLVMI8Vector operandNodeValue__ = (LLVMI8Vector)operandNodeValue_;
            return this.doI8(operandNodeValue__);
        }
        if ((state & 4) != 0 && operandNodeValue_ instanceof LLVMI16Vector) {
            LLVMI16Vector operandNodeValue__ = (LLVMI16Vector)operandNodeValue_;
            return this.doI16(operandNodeValue__);
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof LLVMI32Vector) {
            LLVMI32Vector operandNodeValue__ = (LLVMI32Vector)operandNodeValue_;
            return this.doI32(operandNodeValue__);
        }
        if ((state & 0x10) != 0 && operandNodeValue_ instanceof LLVMI64Vector) {
            LLVMI64Vector operandNodeValue__ = (LLVMI64Vector)operandNodeValue_;
            return this.doI64(operandNodeValue__);
        }
        if ((state & 0x20) != 0 && operandNodeValue_ instanceof LLVMFloatVector) {
            LLVMFloatVector operandNodeValue__ = (LLVMFloatVector)operandNodeValue_;
            return this.doFloat(operandNodeValue__);
        }
        if ((state & 0x40) != 0 && operandNodeValue_ instanceof LLVMDoubleVector) {
            LLVMDoubleVector operandNodeValue__ = (LLVMDoubleVector)operandNodeValue_;
            return this.doDouble(operandNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    private LLVMVector executeAndSpecialize(Object operandNodeValue) {
        int state = this.state_;
        if (operandNodeValue instanceof LLVMI1Vector) {
            LLVMI1Vector operandNodeValue_ = (LLVMI1Vector)operandNodeValue;
            this.state_ = state |= 1;
            return this.doI1(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI8Vector) {
            LLVMI8Vector operandNodeValue_ = (LLVMI8Vector)operandNodeValue;
            this.state_ = state |= 2;
            return this.doI8(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI16Vector) {
            LLVMI16Vector operandNodeValue_ = (LLVMI16Vector)operandNodeValue;
            this.state_ = state |= 4;
            return this.doI16(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI32Vector) {
            LLVMI32Vector operandNodeValue_ = (LLVMI32Vector)operandNodeValue;
            this.state_ = state |= 8;
            return this.doI32(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMI64Vector) {
            LLVMI64Vector operandNodeValue_ = (LLVMI64Vector)operandNodeValue;
            this.state_ = state |= 0x10;
            return this.doI64(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMFloatVector) {
            LLVMFloatVector operandNodeValue_ = (LLVMFloatVector)operandNodeValue;
            this.state_ = state |= 0x20;
            return this.doFloat(operandNodeValue_);
        }
        if (operandNodeValue instanceof LLVMDoubleVector) {
            LLVMDoubleVector operandNodeValue_ = (LLVMDoubleVector)operandNodeValue;
            this.state_ = state |= 0x40;
            return this.doDouble(operandNodeValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMVectorUnaryNode create(int vectorLength, LLVMUnaryNode unaryNode, LLVMExpressionNode operandNode) {
        return new LLVMVectorUnaryNodeGen(vectorLength, unaryNode, operandNode);
    }
}

