/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op.arith.floating;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.op.arith.floating.LLVMArithmeticFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMArithmeticFactory.class)
public final class LLVMArithmeticFactoryFactory {

    @GeneratedBy(value=LLVMArithmeticFactory.CachedRemNode.class)
    static final class CachedRemNodeGen
    extends LLVMArithmeticFactory.CachedRemNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ExecuteData execute_cache;

        private CachedRemNodeGen() {
        }

        @Override
        @ExplodeLoop
        public LLVMArithmetic execute(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof LLVMArithmetic) {
                LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                if (arg1Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                    ExecuteData s1_ = this.execute_cache;
                    while (s1_ != null) {
                        if (s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                            return this.execute(arg0Value_, arg1Value_, s1_.impl_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMArithmetic executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                    if (arg1Value instanceof LLVMArithmetic) {
                        LLVMArithmetic.LLVMArithmeticOpNode impl__;
                        LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                        int count1_ = 0;
                        ExecuteData s1_ = this.execute_cache;
                        if (state != 0) {
                            while (s1_ != null && !s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (impl__ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createNode(arg0Value_, arg1Value_))).canCompute(arg0Value_, arg1Value_) && count1_ < 3) {
                            s1_ = (ExecuteData)super.insert((Node)new ExecuteData(this.execute_cache));
                            s1_.impl_ = s1_.insertAccessor(impl__);
                            this.execute_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMArithmetic lLVMArithmetic = this.execute(arg0Value_, arg1Value_, s1_.impl_);
                            return lLVMArithmetic;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.execute_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticFactory.CachedRemNode create() {
            return new CachedRemNodeGen();
        }

        @GeneratedBy(value=LLVMArithmeticFactory.CachedRemNode.class)
        private static final class ExecuteData
        extends Node {
            @Node.Child
            ExecuteData next_;
            @Node.Child
            LLVMArithmetic.LLVMArithmeticOpNode impl_;

            ExecuteData(ExecuteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticFactory.CachedDivNode.class)
    static final class CachedDivNodeGen
    extends LLVMArithmeticFactory.CachedDivNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ExecuteData execute_cache;

        private CachedDivNodeGen() {
        }

        @Override
        @ExplodeLoop
        public LLVMArithmetic execute(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof LLVMArithmetic) {
                LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                if (arg1Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                    ExecuteData s1_ = this.execute_cache;
                    while (s1_ != null) {
                        if (s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                            return this.execute(arg0Value_, arg1Value_, s1_.impl_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMArithmetic executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                    if (arg1Value instanceof LLVMArithmetic) {
                        LLVMArithmetic.LLVMArithmeticOpNode impl__;
                        LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                        int count1_ = 0;
                        ExecuteData s1_ = this.execute_cache;
                        if (state != 0) {
                            while (s1_ != null && !s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (impl__ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createNode(arg0Value_, arg1Value_))).canCompute(arg0Value_, arg1Value_) && count1_ < 3) {
                            s1_ = (ExecuteData)super.insert((Node)new ExecuteData(this.execute_cache));
                            s1_.impl_ = s1_.insertAccessor(impl__);
                            this.execute_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMArithmetic lLVMArithmetic = this.execute(arg0Value_, arg1Value_, s1_.impl_);
                            return lLVMArithmetic;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.execute_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticFactory.CachedDivNode create() {
            return new CachedDivNodeGen();
        }

        @GeneratedBy(value=LLVMArithmeticFactory.CachedDivNode.class)
        private static final class ExecuteData
        extends Node {
            @Node.Child
            ExecuteData next_;
            @Node.Child
            LLVMArithmetic.LLVMArithmeticOpNode impl_;

            ExecuteData(ExecuteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticFactory.CachedMulNode.class)
    static final class CachedMulNodeGen
    extends LLVMArithmeticFactory.CachedMulNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ExecuteData execute_cache;

        private CachedMulNodeGen() {
        }

        @Override
        @ExplodeLoop
        public LLVMArithmetic execute(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof LLVMArithmetic) {
                LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                if (arg1Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                    ExecuteData s1_ = this.execute_cache;
                    while (s1_ != null) {
                        if (s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                            return this.execute(arg0Value_, arg1Value_, s1_.impl_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMArithmetic executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                    if (arg1Value instanceof LLVMArithmetic) {
                        LLVMArithmetic.LLVMArithmeticOpNode impl__;
                        LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                        int count1_ = 0;
                        ExecuteData s1_ = this.execute_cache;
                        if (state != 0) {
                            while (s1_ != null && !s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (impl__ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createNode(arg0Value_, arg1Value_))).canCompute(arg0Value_, arg1Value_) && count1_ < 3) {
                            s1_ = (ExecuteData)super.insert((Node)new ExecuteData(this.execute_cache));
                            s1_.impl_ = s1_.insertAccessor(impl__);
                            this.execute_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMArithmetic lLVMArithmetic = this.execute(arg0Value_, arg1Value_, s1_.impl_);
                            return lLVMArithmetic;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.execute_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticFactory.CachedMulNode create() {
            return new CachedMulNodeGen();
        }

        @GeneratedBy(value=LLVMArithmeticFactory.CachedMulNode.class)
        private static final class ExecuteData
        extends Node {
            @Node.Child
            ExecuteData next_;
            @Node.Child
            LLVMArithmetic.LLVMArithmeticOpNode impl_;

            ExecuteData(ExecuteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticFactory.CachedSubNode.class)
    static final class CachedSubNodeGen
    extends LLVMArithmeticFactory.CachedSubNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ExecuteData execute_cache;

        private CachedSubNodeGen() {
        }

        @Override
        @ExplodeLoop
        public LLVMArithmetic execute(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof LLVMArithmetic) {
                LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                if (arg1Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                    ExecuteData s1_ = this.execute_cache;
                    while (s1_ != null) {
                        if (s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                            return this.execute(arg0Value_, arg1Value_, s1_.impl_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMArithmetic executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                    if (arg1Value instanceof LLVMArithmetic) {
                        LLVMArithmetic.LLVMArithmeticOpNode impl__;
                        LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                        int count1_ = 0;
                        ExecuteData s1_ = this.execute_cache;
                        if (state != 0) {
                            while (s1_ != null && !s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (impl__ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createNode(arg0Value_, arg1Value_))).canCompute(arg0Value_, arg1Value_) && count1_ < 3) {
                            s1_ = (ExecuteData)super.insert((Node)new ExecuteData(this.execute_cache));
                            s1_.impl_ = s1_.insertAccessor(impl__);
                            this.execute_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMArithmetic lLVMArithmetic = this.execute(arg0Value_, arg1Value_, s1_.impl_);
                            return lLVMArithmetic;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.execute_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticFactory.CachedSubNode create() {
            return new CachedSubNodeGen();
        }

        @GeneratedBy(value=LLVMArithmeticFactory.CachedSubNode.class)
        private static final class ExecuteData
        extends Node {
            @Node.Child
            ExecuteData next_;
            @Node.Child
            LLVMArithmetic.LLVMArithmeticOpNode impl_;

            ExecuteData(ExecuteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMArithmeticFactory.CachedAddNode.class)
    static final class CachedAddNodeGen
    extends LLVMArithmeticFactory.CachedAddNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ExecuteData execute_cache;

        private CachedAddNodeGen() {
        }

        @Override
        @ExplodeLoop
        public LLVMArithmetic execute(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof LLVMArithmetic) {
                LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                if (arg1Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                    ExecuteData s1_ = this.execute_cache;
                    while (s1_ != null) {
                        if (s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                            return this.execute(arg0Value_, arg1Value_, s1_.impl_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMArithmetic executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg0Value instanceof LLVMArithmetic) {
                    LLVMArithmetic arg0Value_ = (LLVMArithmetic)arg0Value;
                    if (arg1Value instanceof LLVMArithmetic) {
                        LLVMArithmetic.LLVMArithmeticOpNode impl__;
                        LLVMArithmetic arg1Value_ = (LLVMArithmetic)arg1Value;
                        int count1_ = 0;
                        ExecuteData s1_ = this.execute_cache;
                        if (state != 0) {
                            while (s1_ != null && !s1_.impl_.canCompute(arg0Value_, arg1Value_)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (impl__ = (LLVMArithmetic.LLVMArithmeticOpNode)super.insert((Node)this.createNode(arg0Value_, arg1Value_))).canCompute(arg0Value_, arg1Value_) && count1_ < 3) {
                            s1_ = (ExecuteData)super.insert((Node)new ExecuteData(this.execute_cache));
                            s1_.impl_ = s1_.insertAccessor(impl__);
                            this.execute_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMArithmetic lLVMArithmetic = this.execute(arg0Value_, arg1Value_, s1_.impl_);
                            return lLVMArithmetic;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ExecuteData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.execute_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMArithmeticFactory.CachedAddNode create() {
            return new CachedAddNodeGen();
        }

        @GeneratedBy(value=LLVMArithmeticFactory.CachedAddNode.class)
        private static final class ExecuteData
        extends Node {
            @Node.Child
            ExecuteData next_;
            @Node.Child
            LLVMArithmetic.LLVMArithmeticOpNode impl_;

            ExecuteData(ExecuteData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

