/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMCheckSymbolNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMCheckSymbolNode.class)
public final class LLVMCheckSymbolNodeGen
extends LLVMCheckSymbolNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMCheckSymbolNodeGen() {
    }

    @Override
    public boolean execute(LLVMSymbol arg0Value) {
        LLVMAlias arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof LLVMAlias && (arg0Value_ = (LLVMAlias)arg0Value).isAlias()) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            LLVMContext checkAlias_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
            return this.doCheckAlias(arg0Value_, checkAlias_context__);
        }
        if ((state & 2) != 0) {
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
            LLVMContext check_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
            return this.doCheck(arg0Value, check_context__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(LLVMSymbol arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMAlias arg0Value_;
            LLVMContext checkAlias_context__ = null;
            if (arg0Value instanceof LLVMAlias && (arg0Value_ = (LLVMAlias)arg0Value).isAlias()) {
                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__2 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                }
                checkAlias_context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doCheckAlias(arg0Value_, checkAlias_context__);
                return bl;
            }
            LLVMContext check_context__ = null;
            TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
            if (lLVMLanguageContextReference__3 == null) {
                this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
            }
            check_context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doCheck(arg0Value, check_context__);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMCheckSymbolNode create() {
        return new LLVMCheckSymbolNodeGen();
    }
}

