/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMReplaceSymbolNode
extends LLVMNode {
    public abstract void execute(LLVMPointer var1, LLVMSymbol var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"symbol.isAlias()"})
    void doAlias(LLVMPointer value, LLVMSymbol symbol, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        AssumedValue<LLVMPointer>[] symbols;
        LLVMSymbol target = ((LLVMAlias)symbol).getTarget();
        while (target.isAlias()) {
            target = ((LLVMAlias)target).getTarget();
        }
        AssumedValue<LLVMPointer>[] assumedValueArray = symbols = context.findSymbolTable(target.getBitcodeID(false));
        synchronized (symbols) {
            CompilerAsserts.partialEvaluationConstant((Object)target);
            try {
                int index = target.getSymbolIndex(false);
                symbols[index].set((Object)value);
            }
            catch (LLVMIllegalSymbolIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMLinkerException(this, "Function replacement is inconsistent.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!symbol.isAlias()"})
    void doFallback(LLVMPointer value, LLVMSymbol symbol, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        AssumedValue<LLVMPointer>[] symbols;
        AssumedValue<LLVMPointer>[] assumedValueArray = symbols = context.findSymbolTable(symbol.getBitcodeID(false));
        synchronized (symbols) {
            CompilerAsserts.partialEvaluationConstant((Object)symbol);
            try {
                int index = symbol.getSymbolIndex(false);
                symbols[index].set((Object)value);
            }
            catch (Exception e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMIllegalSymbolIndexException("Global replacement is inconsistent. Accessing the symbol with an invalid index.");
            }
            return;
        }
    }
}

