/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMReplaceSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMReplaceSymbolNode.class)
public final class LLVMReplaceSymbolNodeGen
extends LLVMReplaceSymbolNode {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMReplaceSymbolNodeGen() {
    }

    @Override
    public void execute(LLVMPointer arg0Value, LLVMSymbol arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value.isAlias()) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                LLVMContext alias_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                this.doAlias(arg0Value, arg1Value, alias_context__);
                return;
            }
            if ((state & 2) != 0 && !arg1Value.isAlias()) {
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                LLVMContext fallback0_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                this.doFallback(arg0Value, arg1Value, fallback0_context__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, LLVMSymbol arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMContext alias_context__ = null;
            if (arg1Value.isAlias()) {
                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__2 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                }
                alias_context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doAlias(arg0Value, arg1Value, alias_context__);
                return;
            }
            LLVMContext fallback0_context__ = null;
            if (!arg1Value.isAlias()) {
                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__3 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                }
                fallback0_context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doFallback(arg0Value, arg1Value, fallback0_context__);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMReplaceSymbolNode create() {
        return new LLVMReplaceSymbolNodeGen();
    }
}

