/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ByteValueProfile;
import com.oracle.truffle.api.profiles.DoubleValueProfile;
import com.oracle.truffle.api.profiles.FloatValueProfile;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.profiling.BooleanValueProfile;
import com.oracle.truffle.llvm.runtime.profiling.ShortValueProfile;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChild
public abstract class LLVMValueProfilingNode
extends LLVMExpressionNode {
    public abstract Object executeWithTarget(Object var1);

    public static LLVMExpressionNode create(LLVMExpressionNode value, Type type) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMValueProfilingNodeFactory.LLVMI1ProfiledValueNodeGen.create(value);
                }
                case I8: {
                    return LLVMValueProfilingNodeFactory.LLVMI8ProfiledValueNodeGen.create(value);
                }
                case I16: {
                    return LLVMValueProfilingNodeFactory.LLVMI16ProfiledValueNodeGen.create(value);
                }
                case I32: {
                    return LLVMValueProfilingNodeFactory.LLVMI32ProfiledValueNodeGen.create(value);
                }
                case I64: {
                    return LLVMValueProfilingNodeFactory.LLVMI64ProfiledValueNodeGen.create(value);
                }
                case FLOAT: {
                    return LLVMValueProfilingNodeFactory.LLVMFloatProfiledValueNodeGen.create(value);
                }
                case DOUBLE: {
                    return LLVMValueProfilingNodeFactory.LLVMDoubleProfiledValueNodeGen.create(value);
                }
            }
            return value;
        }
        if (type instanceof PointerType) {
            return LLVMValueProfilingNodeFactory.LLVMI64ProfiledValueNodeGen.create(value);
        }
        return value;
    }

    static abstract class LLVMDoubleProfiledValueNode
    extends LLVMValueProfilingNode {
        private final DoubleValueProfile profile = DoubleValueProfile.createRawIdentityProfile();

        LLVMDoubleProfiledValueNode() {
        }

        @Specialization
        protected double doFloat(double value) {
            return this.profile.profile(value);
        }
    }

    static abstract class LLVMFloatProfiledValueNode
    extends LLVMValueProfilingNode {
        private final FloatValueProfile profile = FloatValueProfile.createRawIdentityProfile();

        LLVMFloatProfiledValueNode() {
        }

        @Specialization
        protected float doFloat(float value) {
            return this.profile.profile(value);
        }
    }

    static abstract class LLVMI64ProfiledValueNode
    extends LLVMValueProfilingNode {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED_LONG = 1;
        private static final byte SPECIALIZED_POINTER = 2;
        private static final byte GENERIC = 3;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;
        @CompilerDirectives.CompilationFinal
        private LLVMPointer cachedPointer;
        @CompilerDirectives.CompilationFinal
        private long cachedLong;

        LLVMI64ProfiledValueNode() {
        }

        @Specialization
        protected long doI64(long value) {
            byte localState = this.state;
            if (localState != 3) {
                long v;
                if (localState == 1 && (v = this.cachedLong) == value) {
                    return v;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedLong = value;
                    this.state = 1;
                } else {
                    this.state = (byte)3;
                }
            }
            return value;
        }

        @Specialization
        protected LLVMPointer doPointer(LLVMPointer value) {
            byte localState = this.state;
            if (localState != 3) {
                LLVMPointer v;
                if (localState == 2 && (v = this.cachedPointer).isSame(value)) {
                    return v.export(value.getExportType());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0 && LLVMI64ProfiledValueNode.isCachablePointer(value)) {
                    this.cachedPointer = value;
                    this.state = (byte)2;
                } else {
                    this.state = (byte)3;
                }
            }
            return value;
        }

        private static boolean isCachablePointer(LLVMPointer value) {
            if (LLVMNativePointer.isInstance(value)) {
                return true;
            }
            assert (LLVMManagedPointer.isInstance(value));
            LLVMManagedPointer pointer = LLVMManagedPointer.cast(value);
            Object object = pointer.getObject();
            return object instanceof LLVMGlobalContainer || object instanceof LLVMFunctionDescriptor;
        }

        @Fallback
        protected Object noCache(Object value) {
            return value;
        }
    }

    static abstract class LLVMI32ProfiledValueNode
    extends LLVMValueProfilingNode {
        private final IntValueProfile profile = IntValueProfile.createIdentityProfile();

        LLVMI32ProfiledValueNode() {
        }

        @Specialization
        protected int doI32(int value) {
            return this.profile.profile(value);
        }
    }

    static abstract class LLVMI16ProfiledValueNode
    extends LLVMValueProfilingNode {
        private final ShortValueProfile profile = ShortValueProfile.create();

        LLVMI16ProfiledValueNode() {
        }

        @Specialization
        protected short doI1(short value) {
            return this.profile.profile(value);
        }
    }

    static abstract class LLVMI8ProfiledValueNode
    extends LLVMValueProfilingNode {
        private final ByteValueProfile profile = ByteValueProfile.createIdentityProfile();

        LLVMI8ProfiledValueNode() {
        }

        @Specialization
        protected byte doI8(byte value) {
            return this.profile.profile(value);
        }
    }

    static abstract class LLVMI1ProfiledValueNode
    extends LLVMValueProfilingNode {
        private final BooleanValueProfile profile = BooleanValueProfile.create();

        LLVMI1ProfiledValueNode() {
        }

        @Specialization
        protected boolean doI1(boolean value) {
            return this.profile.profile(value);
        }
    }
}

