/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

public abstract class LLVMReadNode
extends LLVMExpressionNode {
    protected final FrameSlot slot;

    public LLVMReadNode(FrameSlot slot) {
        assert (slot != null);
        this.slot = slot;
    }

    @Override
    public String toString() {
        return this.getShortString("slot");
    }

    public static abstract class LLVMDebugReadNode
    extends LLVMReadNode {
        protected LLVMDebugReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected Object readObject(VirtualFrame frame) {
            return frame.getValue(this.slot);
        }
    }

    public static abstract class ForeignAttachInteropTypeNode
    extends LLVMNode {
        public abstract Object execute(Object var1, LLVMInteropType.Structured var2);

        public static ForeignAttachInteropTypeNode create() {
            return LLVMReadNodeFactory.ForeignAttachInteropTypeNodeGen.create();
        }

        @Specialization(guards={"foreigns.isForeign(object)", "!nativeTypes.hasNativeType(object)"})
        protected Object doForeignNoNativeType(Object object, LLVMInteropType.Structured type, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes) {
            return LLVMTypedForeignObject.create(foreigns.asForeign(object), type);
        }

        @Fallback
        protected Object doOther(Object object, LLVMInteropType.Structured type) {
            return object;
        }
    }

    public static abstract class AttachInteropTypeNode
    extends LLVMNode {
        public abstract Object execute(Object var1, LLVMInteropType var2);

        @Specialization(guards={"type != null", "pointer.getOffset() == 0"})
        protected Object doForeign(LLVMManagedPointer pointer, LLVMInteropType.Structured type, @Cached(value="create()") ForeignAttachInteropTypeNode attach) {
            return LLVMManagedPointer.create(attach.execute(pointer.getObject(), type));
        }

        @Fallback
        protected Object doOther(Object object, LLVMInteropType type) {
            return object;
        }
    }

    public static abstract class LLVMAddressReadNode
    extends LLVMReadNode {
        protected LLVMAddressReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected Object readObject(VirtualFrame frame) {
            return FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVM80BitFloatReadNode
    extends LLVMReadNode {
        protected LLVM80BitFloatReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected Object read80BitFloat(VirtualFrame frame) {
            return FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMDoubleReadNode
    extends LLVMReadNode {
        protected LLVMDoubleReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected double readDouble(VirtualFrame frame) {
            return FrameUtil.getDoubleSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMFloatReadNode
    extends LLVMReadNode {
        protected LLVMFloatReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected float readFloat(VirtualFrame frame) {
            return FrameUtil.getFloatSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMIReadVarBitNode
    extends LLVMReadNode {
        protected LLVMIReadVarBitNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected Object readVarBit(VirtualFrame frame) {
            return FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMI64ReadNode
    extends LLVMReadNode {
        protected LLVMI64ReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization(rewriteOn={FrameSlotTypeException.class})
        protected long readI64(VirtualFrame frame) throws FrameSlotTypeException {
            return frame.getLong(this.slot);
        }

        @Specialization(rewriteOn={FrameSlotTypeException.class})
        protected Object readObject(VirtualFrame frame) throws FrameSlotTypeException {
            return frame.getObject(this.slot);
        }

        @Specialization
        protected Object readGeneric(VirtualFrame frame) {
            if (frame.isLong(this.slot)) {
                return FrameUtil.getLongSafe((Frame)frame, (FrameSlot)this.slot);
            }
            return FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMI32ReadNode
    extends LLVMReadNode {
        protected LLVMI32ReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected int readI32(VirtualFrame frame) {
            return FrameUtil.getIntSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMI16ReadNode
    extends LLVMReadNode {
        protected LLVMI16ReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected short readI16(VirtualFrame frame) {
            return (short)FrameUtil.getIntSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMI8ReadNode
    extends LLVMReadNode {
        protected LLVMI8ReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected byte readI8(VirtualFrame frame) {
            return FrameUtil.getByteSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }

    public static abstract class LLVMI1ReadNode
    extends LLVMReadNode {
        protected LLVMI1ReadNode(FrameSlot slot) {
            super(slot);
        }

        @Specialization
        protected boolean readI1(VirtualFrame frame) {
            return FrameUtil.getBooleanSafe((Frame)frame, (FrameSlot)this.slot);
        }
    }
}

