/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class, value="element"), @NodeChild(type=LLVMExpressionNode.class, value="index")})
@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMInsertElementNode
extends LLVMExpressionNode {
    protected abstract int getVectorLength();

    public static abstract class LLVMDoubleInsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMDoubleVector doDouble(LLVMDoubleVector vector, double element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            double[] result = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMDoubleVector.create(result);
        }
    }

    public static abstract class LLVMFloatInsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMFloatVector doFloat(LLVMFloatVector vector, float element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            float[] result = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMFloatVector.create(result);
        }
    }

    public static abstract class LLVMI64InsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI64(LLVMI64Vector vector, long element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            long[] result = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMI64Vector.create(result);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMPointerVector doPointer(LLVMPointerVector vector, LLVMPointer element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            LLVMPointer[] result = new LLVMPointer[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMPointerVector.create(result);
        }

        @Specialization
        protected LLVMPointerVector doPointer(LLVMPointerVector vector, long element, int index) {
            return this.doPointer(vector, LLVMNativePointer.create(element), index);
        }
    }

    public static abstract class LLVMI32InsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doI32(LLVMI32Vector vector, int element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            int[] result = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMI32Vector.create(result);
        }
    }

    public static abstract class LLVMI16InsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI16Vector doI16(LLVMI16Vector vector, short element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            short[] result = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMI16Vector.create(result);
        }
    }

    public static abstract class LLVMI8InsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI8Vector doI8(LLVMI8Vector vector, byte element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            byte[] result = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMI8Vector.create(result);
        }
    }

    public static abstract class LLVMI1InsertElementNode
    extends LLVMInsertElementNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI1Vector doI1(LLVMI1Vector vector, boolean element, int index) {
            assert (vector.getLength() == this.getVectorLength());
            boolean[] result = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                result[i] = vector.getValue(i);
            }
            result[index] = element;
            return LLVMI1Vector.create(result);
        }
    }
}

