/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMInsertElementNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@GeneratedBy(value=LLVMInsertElementNode.class)
public final class LLVMInsertElementNodeFactory {

    @GeneratedBy(value=LLVMInsertElementNode.LLVMDoubleInsertElementNode.class)
    public static final class LLVMDoubleInsertElementNodeGen
    extends LLVMInsertElementNode.LLVMDoubleInsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleInsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            double elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (elementValue instanceof Double) {
                    double elementValue_ = (Double)elementValue;
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doDouble(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMDoubleInsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMDoubleInsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMFloatInsertElementNode.class)
    public static final class LLVMFloatInsertElementNodeGen
    extends LLVMInsertElementNode.LLVMFloatInsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatInsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            float elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, Float.valueOf(elementValue_), indexValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value_ = (LLVMFloatVector)child0Value;
                if (elementValue instanceof Float) {
                    float elementValue_ = ((Float)elementValue).floatValue();
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doFloat(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMFloatInsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMFloatInsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI64InsertElementNode.class)
    public static final class LLVMI64InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI64InsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI64InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_long_int0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_int1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_long_int0(VirtualFrame frameValue, int state) {
            int indexValue_;
            long elementValue_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if ((state & 1) != 0 && child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                return this.doI64(child0Value__, elementValue_, indexValue_);
            }
            if ((state & 4) != 0 && child0Value_ instanceof LLVMPointerVector) {
                LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                return this.doPointer(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_int1(VirtualFrame frameValue, int state) {
            int indexValue_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object elementValue_ = this.element_.executeGeneric(frameValue);
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if ((state & 6) != 0 && child0Value_ instanceof LLVMPointerVector) {
                LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                if ((state & 2) != 0 && LLVMTypes.isPointer(elementValue_)) {
                    LLVMPointer elementValue__ = LLVMTypes.asPointer(elementValue_);
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
                if ((state & 4) != 0 && elementValue_ instanceof Long) {
                    long elementValue__ = (Long)elementValue_;
                    return this.doPointer(child0Value__, elementValue__, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            LLVMVector child0Value__;
            int indexValue_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object elementValue_ = this.element_.executeGeneric(frameValue);
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if ((state & 1) != 0 && child0Value_ instanceof LLVMI64Vector) {
                child0Value__ = (LLVMI64Vector)child0Value_;
                if (elementValue_ instanceof Long) {
                    long elementValue__ = (Long)elementValue_;
                    return this.doI64((LLVMI64Vector)child0Value__, elementValue__, indexValue_);
                }
            }
            if ((state & 6) != 0 && child0Value_ instanceof LLVMPointerVector) {
                child0Value__ = (LLVMPointerVector)child0Value_;
                if ((state & 2) != 0 && LLVMTypes.isPointer(elementValue_)) {
                    LLVMPointer elementValue__ = LLVMTypes.asPointer(elementValue_);
                    return this.doPointer((LLVMPointerVector)child0Value__, elementValue__, indexValue_);
                }
                if ((state & 4) != 0 && elementValue_ instanceof Long) {
                    long elementValue__ = (Long)elementValue_;
                    return this.doPointer((LLVMPointerVector)child0Value__, elementValue__, indexValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMVector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (indexValue instanceof Integer) {
                LLVMVector child0Value_;
                int indexValue_ = (Integer)indexValue;
                if (child0Value instanceof LLVMI64Vector) {
                    child0Value_ = (LLVMI64Vector)child0Value;
                    if (elementValue instanceof Long) {
                        long elementValue_ = (Long)elementValue;
                        this.state_ = state |= 1;
                        return this.doI64((LLVMI64Vector)child0Value_, elementValue_, indexValue_);
                    }
                }
                if (child0Value instanceof LLVMPointerVector) {
                    child0Value_ = (LLVMPointerVector)child0Value;
                    if (LLVMTypes.isPointer(elementValue)) {
                        LLVMPointer elementValue_ = LLVMTypes.asPointer(elementValue);
                        this.state_ = state |= 2;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_, indexValue_);
                    }
                    if (elementValue instanceof Long) {
                        long elementValue_ = (Long)elementValue;
                        this.state_ = state |= 4;
                        return this.doPointer((LLVMPointerVector)child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMI64InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI64InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI32InsertElementNode.class)
    public static final class LLVMI32InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI32InsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            int elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value_ = (LLVMI32Vector)child0Value;
                if (elementValue instanceof Integer) {
                    int elementValue_ = (Integer)elementValue;
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doI32(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMI32InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI32InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI16InsertElementNode.class)
    public static final class LLVMI16InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI16InsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            short elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value_ = (LLVMI16Vector)child0Value;
                if (elementValue instanceof Short) {
                    short elementValue_ = (Short)elementValue;
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doI16(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMI16InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI16InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI8InsertElementNode.class)
    public static final class LLVMI8InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI8InsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            byte elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value_ = (LLVMI8Vector)child0Value;
                if (elementValue instanceof Byte) {
                    byte elementValue_ = (Byte)elementValue;
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doI8(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMI8InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI8InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMInsertElementNode.LLVMI1InsertElementNode.class)
    public static final class LLVMI1InsertElementNodeGen
    extends LLVMInsertElementNode.LLVMI1InsertElementNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode element_;
        @Node.Child
        private LLVMExpressionNode index_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1InsertElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            this.vectorLength = vectorLength;
            this.child0_ = child0;
            this.element_ = element;
            this.index_ = index;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int indexValue_;
            boolean elementValue_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                elementValue_ = this.element_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.index_.executeGeneric(frameValue);
                return this.executeAndSpecialize(child0Value_, ex.getResult(), indexValue);
            }
            try {
                indexValue_ = this.index_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, elementValue_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, elementValue_, indexValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, elementValue_, indexValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object child0Value, Object elementValue, Object indexValue) {
            int state = this.state_;
            if (child0Value instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value_ = (LLVMI1Vector)child0Value;
                if (elementValue instanceof Boolean) {
                    boolean elementValue_ = (Boolean)elementValue;
                    if (indexValue instanceof Integer) {
                        int indexValue_ = (Integer)indexValue;
                        this.state_ = state |= 1;
                        return this.doI1(child0Value_, elementValue_, indexValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.element_, this.index_}, new Object[]{child0Value, elementValue, indexValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMInsertElementNode.LLVMI1InsertElementNode create(LLVMExpressionNode child0, LLVMExpressionNode element, LLVMExpressionNode index, int vectorLength) {
            return new LLVMI1InsertElementNodeGen(child0, element, index, vectorLength);
        }
    }
}

