/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

public interface LLVMNativePointer
extends LLVMPointer {
    public long asNative();

    @Override
    public LLVMNativePointer copy();

    @Override
    @Deprecated
    public boolean equals(Object var1);

    @Override
    public LLVMNativePointer increment(long var1);

    @Override
    public LLVMNativePointer export(LLVMInteropType var1);

    public static LLVMNativePointer createNull() {
        if (CompilerDirectives.inCompiledCode()) {
            return new LLVMPointerImpl(null, 0L, null);
        }
        return LLVMPointerImpl.NULL;
    }

    public static LLVMNativePointer create(long ptr) {
        return new LLVMPointerImpl(null, ptr, null);
    }

    public static boolean isInstance(Object object) {
        if (object instanceof LLVMPointerImpl) {
            return ((LLVMPointerImpl)object).isNative();
        }
        return false;
    }

    public static LLVMNativePointer cast(Object object) {
        if (!1.$assertionsDisabled && !LLVMNativePointer.isInstance(object)) {
            throw new AssertionError();
        }
        return (LLVMPointerImpl)object;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

