/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibraries;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ManagedPointerLibraries.class)
final class ManagedPointerLibrariesFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    ManagedPointerLibrariesFactory() {
    }

    @GeneratedBy(value=ManagedPointerLibraries.ForeignIdentityHashNode.class)
    static final class ForeignIdentityHashNodeGen
    extends ManagedPointerLibraries.ForeignIdentityHashNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private UncheckedData unchecked_cache;
        @Node.Child
        private NoIdentityData noIdentity_cache;
        @Node.Child
        private Checked0Data checked0_cache;

        private ForeignIdentityHashNodeGen() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        int execute(Object arg0Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    UncheckedData s1_ = this.unchecked_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(arg0Value)) {
                            try {
                                return this.doUnchecked(arg0Value, s1_.interop_);
                            }
                            catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_ &= 0xFFFFFFFE;
                                    this.unchecked_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return this.executeAndSpecialize(arg0Value);
                            }
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    NoIdentityData s2_ = this.noIdentity_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arg0Value) && !s2_.interop_.hasIdentity(arg0Value)) {
                            return this.doNoIdentity(arg0Value, s2_.interop_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    Checked0Data s3_ = this.checked0_cache;
                    while (s3_ != null) {
                        if (s3_.interop_.accepts(arg0Value)) {
                            return this.doChecked(arg0Value, s3_.interop_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.checked1Boundary(state, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private int checked1Boundary(int state, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary checked1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                int n = this.doChecked(arg0Value, checked1_interop__);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private int executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int n;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    UncheckedData s1_ = this.unchecked_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(arg0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (UncheckedData)super.insert((Node)new UncheckedData(this.unchecked_cache));
                        s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.unchecked_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        try {
                            lock.unlock();
                            hasLock = false;
                            int n2 = this.doUnchecked(arg0Value, s1_.interop_);
                            return n2;
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_ &= 0xFFFFFFFE;
                                this.unchecked_cache = null;
                            }
                            finally {
                                lock.unlock();
                            }
                            int n3 = this.executeAndSpecialize(arg0Value);
                            if (hasLock) {
                                lock.unlock();
                            }
                            return n3;
                        }
                    }
                }
                if ((exclude & 2) == 0) {
                    InteropLibrary interop__2222;
                    int count2_ = 0;
                    NoIdentityData s2_ = this.noIdentity_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && (!s2_.interop_.accepts(arg0Value) || s2_.interop_.hasIdentity(arg0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && !(interop__2222 = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)))).hasIdentity(arg0Value) && count2_ < 3) {
                        s2_ = (NoIdentityData)super.insert((Node)new NoIdentityData(this.noIdentity_cache));
                        s2_.interop_ = s2_.insertAccessor(interop__2222);
                        this.noIdentity_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.unchecked_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        int interop__2222 = this.doNoIdentity(arg0Value, s2_.interop_);
                        return interop__2222;
                    }
                }
                if ((exclude & 4) == 0) {
                    int count3_ = 0;
                    Checked0Data s3_ = this.checked0_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null && !s3_.interop_.accepts(arg0Value)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && count3_ < 3) {
                        s3_ = (Checked0Data)super.insert((Node)new Checked0Data(this.checked0_cache));
                        s3_.interop_ = s3_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.checked0_cache = s3_;
                        this.exclude_ = exclude |= 3;
                        this.unchecked_cache = null;
                        this.noIdentity_cache = null;
                        state &= 0xFFFFFFFC;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        int interop__2222 = this.doChecked(arg0Value, s3_.interop_);
                        return interop__2222;
                    }
                }
                InteropLibrary checked1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    checked1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 7;
                    this.unchecked_cache = null;
                    this.noIdentity_cache = null;
                    this.checked0_cache = null;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    n = this.doChecked(arg0Value, checked1_interop__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
                encapsulating_.set(prev_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                UncheckedData s1_ = this.unchecked_cache;
                NoIdentityData s2_ = this.noIdentity_cache;
                Checked0Data s3_ = this.checked0_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ManagedPointerLibraries.ForeignIdentityHashNode create() {
            return new ForeignIdentityHashNodeGen();
        }

        public static ManagedPointerLibraries.ForeignIdentityHashNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ManagedPointerLibraries.ForeignIdentityHashNode.class)
        private static final class Uncached
        extends ManagedPointerLibraries.ForeignIdentityHashNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Object arg0Value) {
                return this.doChecked(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.ForeignIdentityHashNode.class)
        private static final class Checked0Data
        extends Node {
            @Node.Child
            Checked0Data next_;
            @Node.Child
            InteropLibrary interop_;

            Checked0Data(Checked0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.ForeignIdentityHashNode.class)
        private static final class NoIdentityData
        extends Node {
            @Node.Child
            NoIdentityData next_;
            @Node.Child
            InteropLibrary interop_;

            NoIdentityData(NoIdentityData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.ForeignIdentityHashNode.class)
        private static final class UncheckedData
        extends Node {
            @Node.Child
            UncheckedData next_;
            @Node.Child
            InteropLibrary interop_;

            UncheckedData(UncheckedData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

