/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.api.lsp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;

@GenerateLibrary(receiverType=TruffleObject.class, assertions=Asserts.class)
public abstract class LSPLibrary
extends Library {
    static final LibraryFactory<LSPLibrary> FACTORY = LibraryFactory.resolve(LSPLibrary.class);

    @GenerateLibrary.Abstract
    public Object getDocumentation(Object object) throws UnsupportedMessageException {
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @GenerateLibrary.Abstract
    public Object getSignature(Object object) throws UnsupportedMessageException {
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    LSPLibrary() {
    }

    public static LibraryFactory<LSPLibrary> getFactory() {
        return FACTORY;
    }

    static class Asserts
    extends LSPLibrary {
        @Node.Child
        private LSPLibrary delegate;

        Asserts(LSPLibrary delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(Object receiver) {
            assert (receiver != null);
            return this.delegate.accepts(receiver);
        }

        @Override
        public Object getDocumentation(Object object) throws UnsupportedMessageException {
            assert (object != null);
            Object doc = this.delegate.getDocumentation(object);
            assert (Asserts.isDocumentation(doc)) : "Wrong documentation of " + object + " : " + doc;
            return doc;
        }

        @Override
        public Object getSignature(Object object) throws UnsupportedMessageException {
            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isExecutable(object)) : "Expecting an executable, got " + object;
            Object signature = this.delegate.getSignature(object);
            assert (Asserts.isSignature(signature)) : "Wrong signature of " + object + " : " + signature;
            return signature;
        }

        private static boolean isDocumentation(Object doc) {
            if (doc instanceof String) {
                return true;
            }
            InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            assert (doc instanceof TruffleObject);
            return interop.isMemberInvocable(doc, "markdown") || interop.isMemberInvocable(doc, "plaintext");
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isSignature(Object signature) {
            InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            assert (signature instanceof TruffleObject);
            try {
                if (interop.isMemberReadable(signature, "documentation") && !Asserts.isDocumentation(interop.readMember(signature, "documentation"))) {
                    assert (false) : "Wrong documentation of signature " + signature;
                    return false;
                }
                if (interop.isMemberReadable(signature, "parameters")) {
                    Object parameters = interop.readMember(signature, "parameters");
                    assert (interop.hasArrayElements(parameters)) : "Parameters of " + signature + " is not an array";
                    long size = interop.getArraySize(parameters);
                    for (long i = 0L; i < size; ++i) {
                        assert (interop.isArrayElementReadable(parameters, i));
                        Object param = interop.readArrayElement(parameters, i);
                        assert (interop.isMemberReadable(param, "label"));
                        Object label = interop.readMember(param, "label");
                        assert (label instanceof String || interop.hasArrayElements(label));
                        if (interop.hasArrayElements(label)) {
                            long rangeSize = interop.getArraySize(label);
                            assert (2L == rangeSize) : "Label range must be an array of size 2, but was " + rangeSize;
                            Object l1 = interop.readArrayElement(label, 0L);
                            Object l2 = interop.readArrayElement(label, 1L);
                            assert (interop.fitsInInt(l1) && interop.fitsInInt(l2));
                        }
                        if (!interop.isMemberReadable(param, "documentation") || Asserts.isDocumentation(interop.readMember(signature, "documentation"))) continue;
                        assert (false) : "Wrong documentation of parameter " + param + " of signature " + signature;
                        return false;
                    }
                }
            }
            catch (InteropException ex) {
                throw new AssertionError("Checking signature " + signature, ex);
            }
            return true;
        }
    }
}

