/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.jmx.impl.HeapHistogramImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class JmxSupport {
    private static final Logger LOGGER = Logger.getLogger(JmxSupport.class.getName());
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String DIAGNOSTIC_COMMAND_MXBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String HISTOGRAM_COMMAND = "gcClassHistogram";
    private static final String CMDLINE_COMMAND = "vmCommandLine";
    private static final String CMDLINE_PREFIX = "java_command: ";
    private JvmMXBeans mxbeans;
    private JmxModel jmxModel;
    private boolean hotspotDiagnosticInitialized;
    private final Object hotspotDiagnosticLock = new Object();
    private HotSpotDiagnosticMXBean hotspotDiagnosticMXBean;
    private final Object readOnlyConnectionLock = new Object();
    private Boolean readOnlyConnection;
    private Boolean hasDumpAllThreads;
    private final Object hasDumpAllThreadsLock = new Object();

    JmxSupport(JmxModel jmx) {
        this.jmxModel = jmx;
    }

    private RuntimeMXBean getRuntime() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getRuntimeMXBean();
        }
        return null;
    }

    private synchronized JvmMXBeans getJvmMXBeans() {
        if (this.mxbeans == null && this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)this.jmxModel);
        }
        return this.mxbeans;
    }

    Properties getSystemProperties() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                Properties prop = new Properties();
                prop.putAll(runtime.getSystemProperties());
                return prop;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "getSystemProperties", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean isReadOnlyConnection() {
        Object object = this.readOnlyConnectionLock;
        synchronized (object) {
            if (this.readOnlyConnection == null) {
                this.readOnlyConnection = Boolean.FALSE;
                ThreadMXBean threads = this.getThreadBean();
                if (threads != null) {
                    try {
                        threads.getThreadInfo(1L);
                    }
                    catch (SecurityException ex) {
                        this.readOnlyConnection = Boolean.TRUE;
                    }
                }
            }
            return this.readOnlyConnection;
        }
    }

    ThreadMXBean getThreadBean() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getThreadMXBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HotSpotDiagnosticMXBean getHotSpotDiagnostic() {
        Object object = this.hotspotDiagnosticLock;
        synchronized (object) {
            if (this.hotspotDiagnosticInitialized) {
                return this.hotspotDiagnosticMXBean;
            }
            JvmMXBeans jmx = this.getJvmMXBeans();
            if (jmx != null) {
                try {
                    this.hotspotDiagnosticMXBean = (HotSpotDiagnosticMXBean)jmx.getMXBean(ObjectName.getInstance(HOTSPOT_DIAGNOSTIC_MXBEAN_NAME), HotSpotDiagnosticMXBean.class);
                }
                catch (MalformedObjectNameException e) {
                    ErrorManager.getDefault().log(16, "Couldn't find HotSpotDiagnosticMXBean: " + e.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.hotspotDiagnosticInitialized = true;
            return this.hotspotDiagnosticMXBean;
        }
    }

    String takeThreadDump(long[] threadIds) {
        try {
            ThreadMXBean threadMXBean = this.getThreadBean();
            if (threadMXBean == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(4096);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ThreadInfo[] threads = this.hasDumpAllThreads() ? threadMXBean.getThreadInfo(threadIds, true, true) : threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            sb.append(df.format(new Date()) + "\n");
            this.printThreads(sb, threadMXBean, threads);
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "takeThreadDump[]", e);
            return null;
        }
    }

    String takeThreadDump() {
        try {
            ThreadInfo[] threads;
            ThreadMXBean threadMXBean = this.getThreadBean();
            if (threadMXBean == null) {
                return null;
            }
            Properties prop = this.getSystemProperties();
            StringBuilder sb = new StringBuilder(4096);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb.append(df.format(new Date()) + "\n");
            sb.append("Full thread dump " + prop.getProperty("java.vm.name") + " (" + prop.getProperty("java.vm.version") + " " + prop.getProperty("java.vm.info") + "):\n");
            if (this.hasDumpAllThreads()) {
                threads = threadMXBean.dumpAllThreads(true, true);
            } else {
                long[] threadIds = threadMXBean.getAllThreadIds();
                threads = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            }
            this.printThreads(sb, threadMXBean, threads);
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "takeThreadDump", e);
            return null;
        }
    }

    private void printThreads(StringBuilder sb, ThreadMXBean threadMXBean, ThreadInfo[] threads) {
        boolean jdk16 = this.hasDumpAllThreads();
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            if (jdk16) {
                this.print16Thread(sb, threadMXBean, thread);
                continue;
            }
            this.print15Thread(sb, thread);
        }
    }

    private void print16Thread(StringBuilder sb, ThreadMXBean threadMXBean, ThreadInfo thread) {
        MonitorInfo[] monitors = null;
        if (threadMXBean.isObjectMonitorUsageSupported()) {
            monitors = thread.getLockedMonitors();
        }
        sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
        sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        sb.append("\n");
        int index = 0;
        for (StackTraceElement st : thread.getStackTrace()) {
            LockInfo lock = thread.getLockInfo();
            String lockOwner = thread.getLockOwnerName();
            sb.append("\tat " + st.toString() + "\n");
            if (index == 0) {
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb.append("\t- waiting on ");
                        this.printLock(sb, lock);
                        sb.append("\n");
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb.append("\t- parking to wait for ");
                        this.printLock(sb, lock);
                        sb.append("\n");
                    } else {
                        sb.append("\t- waiting to lock ");
                        this.printLock(sb, lock);
                        sb.append(" owned by \"" + lockOwner + "\" t@" + thread.getLockOwnerId() + "\n");
                    }
                }
            }
            this.printMonitors(sb, monitors, index);
            ++index;
        }
        StringBuilder jnisb = new StringBuilder();
        this.printMonitors(jnisb, monitors, -1);
        if (jnisb.length() > 0) {
            sb.append("   JNI locked monitors:\n");
            sb.append((CharSequence)jnisb);
        }
        if (threadMXBean.isSynchronizerUsageSupported()) {
            sb.append("\n   Locked ownable synchronizers:");
            LockInfo[] synchronizers = thread.getLockedSynchronizers();
            if (synchronizers == null || synchronizers.length == 0) {
                sb.append("\n\t- None\n");
            } else {
                for (LockInfo li : synchronizers) {
                    sb.append("\n\t- locked ");
                    this.printLock(sb, li);
                    sb.append("\n");
                }
            }
        }
    }

    private void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                sb.append("\t- locked ");
                this.printLock(sb, mi);
                sb.append("\n");
            }
        }
    }

    private void print15Thread(StringBuilder sb, ThreadInfo thread) {
        sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
        sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockName() != null) {
            sb.append(" on " + thread.getLockName());
            if (thread.getLockOwnerName() != null) {
                sb.append(" owned by: " + thread.getLockOwnerName());
            }
        }
        sb.append("\n");
        for (StackTraceElement st : thread.getStackTrace()) {
            sb.append("        at " + st.toString() + "\n");
        }
    }

    private void printLock(StringBuilder sb, LockInfo lock) {
        String id = Integer.toHexString(lock.getIdentityHashCode());
        String className = lock.getClassName();
        sb.append("<" + id + "> (a " + className + ")");
    }

    boolean takeHeapDump(String fileName) {
        HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
        if (hsDiagnostic != null) {
            try {
                hsDiagnostic.dumpHeap(fileName, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "takeHeapDump", ex);
                return false;
            }
            return true;
        }
        return false;
    }

    String getFlagValue(String name) {
        try {
            VMOption option;
            HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
            if (hsDiagnostic != null && (option = hsDiagnostic.getVMOption(name)) != null) {
                return option.getValue();
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "getFlagValue", ex);
            return null;
        }
    }

    HeapHistogram takeHeapHistogram() {
        if (this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            MBeanServerConnection conn = this.jmxModel.getMBeanServerConnection();
            try {
                Object histo;
                ObjectName diagCommName = new ObjectName(DIAGNOSTIC_COMMAND_MXBEAN_NAME);
                if (conn.isRegistered(diagCommName) && (histo = conn.invoke(diagCommName, HISTOGRAM_COMMAND, new Object[]{new String[]{ALL_OBJECTS_OPTION}}, new String[]{String[].class.getName()})) instanceof String) {
                    return new HeapHistogramImpl((String)histo);
                }
            }
            catch (MalformedObjectNameException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            }
            catch (InstanceNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (MBeanException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ReflectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            }
        }
        return null;
    }

    void setFlagValue(String name, String value) {
        try {
            HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
            if (hsDiagnostic != null) {
                hsDiagnostic.setVMOption(name, value);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "setFlagValue", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDumpAllThreads() {
        Object object = this.hasDumpAllThreadsLock;
        synchronized (object) {
            if (this.hasDumpAllThreads == null) {
                this.hasDumpAllThreads = Boolean.FALSE;
                try {
                    ObjectName threadObjName = new ObjectName("java.lang:type=Threading");
                    MBeanInfo threadInfo = this.jmxModel.getMBeanServerConnection().getMBeanInfo(threadObjName);
                    if (threadInfo != null) {
                        for (MBeanOperationInfo op : threadInfo.getOperations()) {
                            if (!"dumpAllThreads".equals(op.getName())) continue;
                            this.hasDumpAllThreads = Boolean.TRUE;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "hasDumpAllThreads", ex);
                }
            }
            return this.hasDumpAllThreads;
        }
    }

    String getCommandLine() {
        if (this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            MBeanServerConnection conn = this.jmxModel.getMBeanServerConnection();
            try {
                Object vmCommandLine;
                ObjectName diagCommName = new ObjectName(DIAGNOSTIC_COMMAND_MXBEAN_NAME);
                if (conn.isRegistered(diagCommName) && (vmCommandLine = conn.invoke(diagCommName, CMDLINE_COMMAND, new Object[0], new String[0])) instanceof String) {
                    return this.parseVMCommandLine((String)vmCommandLine);
                }
            }
            catch (MalformedObjectNameException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "getCommandLine", ex);
            }
            catch (InstanceNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (MBeanException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ReflectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private String parseVMCommandLine(String vmCommandLine) {
        String[] lines;
        for (String line : lines = vmCommandLine.split("\\r?\\n")) {
            if (!line.startsWith(CMDLINE_PREFIX)) continue;
            return line.substring(CMDLINE_PREFIX.length());
        }
        return null;
    }
}

