/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class IoDetailsProvider
extends DetailsProvider.Basic {
    private static final String FILE_MASK = "java.io.File+";
    private static final String ZIPFILE_MASK = "java.util.zip.ZipFile+";
    private static final String RAF_MASK = "java.io.RandomAccessFile";
    private static final String FIS_MASK = "java.io.FileInputStream";
    private static final String FOS_MASK = "java.io.FileOutputStream";
    private static final String FD_MASK = "java.io.FileDescriptor";
    private static final String FD_RAF_CLASS = "java.io.RandomAccessFile";
    private static final String FD_FIS_CLASS = "java.io.FileInputStream";
    private static final String FD_FOS_CLASS = "java.io.FileOutputStream";
    private static final String FCI_MASK = "sun.nio.ch.FileChannelImpl";
    private static final String HEAPCHARBUFFER_MASK = "java.nio.HeapCharBuffer";
    private static final Object CACHE_LOCK = new Object();
    private static WeakHashMap<Heap, Map<Long, String>> CACHE;

    public IoDetailsProvider() {
        super(FILE_MASK, ZIPFILE_MASK, "java.io.RandomAccessFile", "java.io.FileInputStream", "java.io.FileOutputStream", FD_MASK, FCI_MASK, HEAPCHARBUFFER_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (FILE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (ZIPFILE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        if ("java.io.RandomAccessFile".equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if ("java.io.FileInputStream".equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if ("java.io.FileOutputStream".equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (FD_MASK.equals(className)) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                Map<Long, String> heapCache;
                if (CACHE == null) {
                    CACHE = new WeakHashMap();
                }
                if ((heapCache = CACHE.get(heap)) == null) {
                    heapCache = this.computeFDCache(heap, instance.getJavaClass());
                    CACHE.put(heap, heapCache);
                }
                return heapCache.get(instance.getInstanceId());
            }
        }
        if (FCI_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (HEAPCHARBUFFER_MASK.equals(className)) {
            int position = DetailsUtils.getIntFieldValue(instance, "position", -1);
            int limit = DetailsUtils.getIntFieldValue(instance, "limit", -1);
            int offset = DetailsUtils.getIntFieldValue(instance, "offset", -1);
            return DetailsUtils.getPrimitiveArrayFieldString(instance, "hb", position + offset, limit - position, null, "...");
        }
        return null;
    }

    private Map<Long, String> computeFDCache(Heap heap, JavaClass fdClass) {
        HashMap<Long, String> cache = new HashMap<Long, String>();
        this.computeFDCacheForClass(heap, "java.io.RandomAccessFile", "fd", cache);
        this.computeFDCacheForClass(heap, "java.io.FileInputStream", "fd", cache);
        this.computeFDCacheForClass(heap, "java.io.FileOutputStream", "fd", cache);
        this.computeStdDescriptor(fdClass, "in", "Standard Input", cache);
        this.computeStdDescriptor(fdClass, "out", "Standard Output", cache);
        this.computeStdDescriptor(fdClass, "err", "Standard Error", cache);
        return cache;
    }

    private void computeFDCacheForClass(Heap heap, String className, String fieldName, Map<Long, String> cache) {
        JavaClass rafClass = heap.getJavaClassByName(className);
        if (rafClass != null) {
            for (Instance raf : rafClass.getInstances()) {
                String details;
                Instance fd = (Instance)raf.getValueOfField(fieldName);
                if (fd == null || (details = this.getDetailsString(className, raf, heap)) == null) continue;
                cache.put(fd.getInstanceId(), details);
            }
        }
    }

    private void computeStdDescriptor(JavaClass fdClass, String field, String text, Map<Long, String> cache) {
        Instance stdFd = (Instance)fdClass.getValueOfStaticField(field);
        if (stdFd != null) {
            cache.put(stdFd.getInstanceId(), text);
        }
    }
}

