/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BorderBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ButtonBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.DataViewBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.JComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.PaneBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.TextComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.WindowBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class ComponentBuilders {
    ComponentBuilders() {
    }

    static ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (Thread.interrupted()) {
            return null;
        }
        ComponentBuilder jcomponent = JComponentBuilders.getBuilder(instance, heap);
        if (jcomponent != null) {
            return jcomponent;
        }
        ComponentBuilder button = ButtonBuilders.getBuilder(instance, heap);
        if (button != null) {
            return button;
        }
        ComponentBuilder textComponent = TextComponentBuilders.getBuilder(instance, heap);
        if (textComponent != null) {
            return textComponent;
        }
        ComponentBuilder pane = PaneBuilders.getBuilder(instance, heap);
        if (pane != null) {
            return pane;
        }
        ComponentBuilder dataView = DataViewBuilders.getBuilder(instance, heap);
        if (dataView != null) {
            return dataView;
        }
        ComponentBuilder window = WindowBuilders.getBuilder(instance, heap);
        if (window != null) {
            return window;
        }
        if (DetailsUtils.isSubclassOf(instance, JComponent.class.getName())) {
            return new JComponentBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Container.class.getName())) {
            return new ContainerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Component.class.getName())) {
            return new ComponentBuilder(instance, heap);
        }
        return null;
    }

    static class JComponentBuilder<T extends JComponent>
    extends ContainerBuilder<T> {
        private final boolean isAlignmentXSet;
        private final float alignmentX;
        private final boolean isAlignmentYSet;
        private final float alignmentY;
        private final BorderBuilders.BorderBuilder border;
        private final int flags;

        JComponentBuilder(Instance instance, Heap heap) {
            this(instance, heap, true);
        }

        protected JComponentBuilder(Instance instance, Heap heap, boolean trackChildren) {
            super(instance, heap, trackChildren);
            this.isAlignmentXSet = DetailsUtils.getBooleanFieldValue(instance, "isAlignmentXSet", false);
            this.alignmentX = DetailsUtils.getFloatFieldValue(instance, "alignmentX", 0.0f);
            this.isAlignmentYSet = DetailsUtils.getBooleanFieldValue(instance, "isAlignmentYSet", false);
            this.alignmentY = DetailsUtils.getFloatFieldValue(instance, "alignmentY", 0.0f);
            this.border = BorderBuilders.fromField(instance, "border", false, heap);
            this.flags = DetailsUtils.getIntFieldValue(instance, "flags", 0);
        }

        @Override
        protected void setupInstance(T instance) {
            int opaque_mask;
            Border b;
            super.setupInstance(instance);
            ((JComponent)instance).putClientProperty("className", this.className);
            if (this.isAlignmentXSet) {
                ((JComponent)instance).setAlignmentX(this.alignmentX);
            }
            if (this.isAlignmentYSet) {
                ((JComponent)instance).setAlignmentY(this.alignmentY);
            }
            if (this.border != null && (this.isPlaceholder() || !this.border.isUIResource()) && (b = (Border)this.border.createInstance()) != null) {
                ((JComponent)instance).setBorder(b);
            }
            boolean opaque = (this.flags & (opaque_mask = 8)) == opaque_mask;
            ((JComponent)instance).setOpaque(opaque);
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }
    }

    static class ContainerBuilder<T extends Container>
    extends ComponentBuilder<T> {
        private final boolean trackChildren;
        private final ChildrenBuilder component;

        ContainerBuilder(Instance instance, Heap heap) {
            this(instance, heap, true);
        }

        protected ContainerBuilder(Instance instance, Heap heap, boolean trackChildren) {
            super(instance, heap);
            this.trackChildren = trackChildren;
            this.component = this.isVisible() && trackChildren ? ChildrenBuilder.fromField(instance, "component", heap) : null;
        }

        @Override
        protected void setupInstance(T instance) {
            super.setupInstance(instance);
            if (this.trackChildren) {
                ((Container)instance).setLayout(null);
                ((Container)instance).removeAll();
                if (this.component != null) {
                    Component[] components;
                    for (Component c : components = (Component[])this.component.createInstance()) {
                        ((Container)instance).add(c);
                    }
                }
            }
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }
    }

    static class ComponentBuilder<T extends Component>
    extends Utils.InstanceBuilder<T> {
        private static final int MAX_WIDTH = 10000;
        private static final int MAX_HEIGHT = 10000;
        protected final String className;
        private final BaseBuilders.RectangleBuilder bounds;
        private final BaseBuilders.ColorBuilder foreground;
        private final BaseBuilders.ColorBuilder background;
        private final BaseBuilders.FontBuilder font;
        private final boolean visible;
        private final boolean enabled;
        private boolean isPlaceholder = false;

        ComponentBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.className = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
            this.bounds = new BaseBuilders.RectangleBuilder(instance, heap);
            this.foreground = BaseBuilders.ColorBuilder.fromField(instance, "foreground", heap);
            this.background = BaseBuilders.ColorBuilder.fromField(instance, "background", heap);
            this.font = BaseBuilders.FontBuilder.fromField(instance, "font", heap);
            this.visible = DetailsUtils.getBooleanFieldValue(instance, "visible", true);
            this.enabled = DetailsUtils.getBooleanFieldValue(instance, "enabled", true);
        }

        @Override
        protected void setupInstance(T instance) {
            super.setupInstance(instance);
            Rectangle rect = (Rectangle)this.bounds.createInstance();
            if (rect != null) {
                rect.width = Math.min(rect.width, 10000);
                rect.height = Math.min(rect.height, 10000);
                ((Component)instance).setBounds(rect);
            }
            if (this.foreground != null && (this.isPlaceholder || !this.foreground.isUIResource())) {
                ((Component)instance).setForeground((Color)this.foreground.createInstance());
            }
            if (this.background != null && (this.isPlaceholder || !this.background.isUIResource())) {
                ((Component)instance).setBackground((Color)this.background.createInstance());
            }
            if (this.font != null && (this.isPlaceholder || !this.font.isUIResource())) {
                ((Component)instance).setFont((Font)this.font.createInstance());
            }
            ((Component)instance).setVisible(this.visible);
            ((Component)instance).setEnabled(this.enabled);
        }

        protected final boolean isVisible() {
            return this.visible;
        }

        protected final void setPlaceholder() {
            this.isPlaceholder = true;
        }

        protected final boolean isPlaceholder() {
            return this.isPlaceholder;
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }

        protected Component createPresenterImpl(T instance) {
            return instance;
        }

        final Component createPresenter() {
            Component instance = (Component)this.createInstance();
            return instance != null ? this.createPresenterImpl(instance) : null;
        }
    }

    private static final class ChildrenBuilder
    extends Utils.InstanceBuilder<Component[]> {
        private final List<Utils.InstanceBuilder<Component>> component;

        ChildrenBuilder(Instance instance, Heap heap) {
            block3: {
                Object elementData;
                block2: {
                    super(instance, heap);
                    this.component = new ArrayList<Utils.InstanceBuilder<Component>>();
                    if (!(instance instanceof ObjectArrayInstance)) break block2;
                    List components = ((ObjectArrayInstance)instance).getValues();
                    for (Instance c : components) {
                        ComponentBuilder builder;
                        if (c == null || (builder = ComponentBuilders.getBuilder(c, heap)) == null) continue;
                        this.component.add(builder);
                    }
                    break block3;
                }
                int size = DetailsUtils.getIntFieldValue(instance, "size", 0);
                if (size <= 0 || !((elementData = instance.getValueOfField("elementData")) instanceof ObjectArrayInstance)) break block3;
                List components = ((ObjectArrayInstance)elementData).getValues();
                for (Instance c : components) {
                    ComponentBuilder builder;
                    if (c == null || (builder = ComponentBuilders.getBuilder(c, heap)) == null) continue;
                    this.component.add(builder);
                }
            }
        }

        static ChildrenBuilder fromField(Instance instance, String field, Heap heap) {
            Object children = instance.getValueOfField(field);
            if (!(children instanceof Instance)) {
                return null;
            }
            return new ChildrenBuilder((Instance)children, heap);
        }

        @Override
        protected Component[] createInstanceImpl() {
            Component[] components = new Component[this.component.size()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.component.get(i).createInstance();
            }
            return components;
        }
    }
}

