/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BorderBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class PaneBuilders {
    PaneBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JViewport.class.getName())) {
            return new JViewportBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JScrollPane.class.getName())) {
            return new JScrollPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSplitPane.class.getName())) {
            return new JSplitPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, BasicSplitPaneDivider.class.getName())) {
            return new BasicSplitPaneDividerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTabbedPane.class.getName())) {
            return new JTabbedPaneBuilder(instance, heap);
        }
        return null;
    }

    private static class JTabbedPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JTabbedPane> {
        private final int tabPlacement;
        private final int tabLayoutPolicy;
        private final PageImplBuilder pages;
        private final long visCompId;
        private final Utils.InstanceBuilder<Component> visComp;
        private int selComp = -1;

        JTabbedPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.tabPlacement = DetailsUtils.getIntFieldValue(instance, "tabPlacement", 1);
            this.tabLayoutPolicy = DetailsUtils.getIntFieldValue(instance, "tabLayoutPolicy", 0);
            this.pages = PageImplBuilder.fromField(instance, "pages", heap);
            Object _visComp = instance.getValueOfField("visComp");
            if (_visComp instanceof Instance) {
                Instance visCompI = (Instance)_visComp;
                this.visCompId = visCompI.getInstanceId();
                this.visComp = ComponentBuilders.getBuilder(visCompI, heap);
            } else {
                this.visCompId = Long.MIN_VALUE;
                this.visComp = null;
            }
        }

        @Override
        protected void setupInstance(JTabbedPane instance) {
            super.setupInstance(instance);
            if (this.pages != null) {
                List pageImpls = (List)this.pages.createInstance();
                for (PageImpl page : pageImpls) {
                    Color foreground;
                    Color background;
                    int index = instance.getTabCount();
                    Component comp = null;
                    if (this.selComp == -1 && this.visComp != null && this.visCompId == page.component) {
                        comp = this.visComp.createInstance();
                        this.selComp = index;
                    }
                    instance.addTab(page.title, page.icon == null ? null : (Icon)page.icon.createInstance(), comp);
                    if (page.background != null && (background = (Color)page.background.createInstance()) != null) {
                        instance.setBackgroundAt(index, background);
                    }
                    if (page.foreground != null && (foreground = (Color)page.foreground.createInstance()) != null) {
                        instance.setForegroundAt(index, foreground);
                    }
                    instance.setEnabledAt(index, page.enabled);
                }
            }
            if (this.selComp != -1) {
                instance.setSelectedIndex(this.selComp);
                this.selComp = -1;
            }
        }

        @Override
        protected JTabbedPane createInstanceImpl() {
            return new JTabbedPane(this.tabPlacement, this.tabLayoutPolicy){};
        }
    }

    private static class PageImplBuilder
    extends Utils.InstanceBuilder<List<PageImpl>> {
        private final List<PageImpl> pages = new ArrayList<PageImpl>(1);

        PageImplBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            Object _elementData = instance.getValueOfField("elementData");
            if (_elementData instanceof ObjectArrayInstance) {
                int size = DetailsUtils.getIntFieldValue(instance, "size", Integer.MIN_VALUE);
                if (size == Integer.MIN_VALUE) {
                    size = DetailsUtils.getIntFieldValue(instance, "elementCount", 0);
                }
                if (size > 0) {
                    ObjectArrayInstance elementData = (ObjectArrayInstance)_elementData;
                    for (Object _page : elementData.getValues()) {
                        if (!(_page instanceof Instance)) continue;
                        Instance page = (Instance)_page;
                        Object comp = page.getValueOfField("component");
                        this.pages.add(new PageImpl(Utils.getFieldString(page, "title"), BaseBuilders.ColorBuilder.fromField(page, "background", heap), BaseBuilders.ColorBuilder.fromField(page, "foreground", heap), BaseBuilders.IconBuilder.fromField(page, "icon", heap), comp instanceof Instance ? ((Instance)comp).getInstanceId() : -1L, DetailsUtils.getBooleanFieldValue(page, "enabled", true)));
                    }
                }
            }
        }

        static PageImplBuilder fromField(Instance instance, String field, Heap heap) {
            Object pages = instance.getValueOfField(field);
            if (!(pages instanceof Instance)) {
                return null;
            }
            return new PageImplBuilder((Instance)pages, heap);
        }

        @Override
        protected List<PageImpl> createInstanceImpl() {
            return this.pages;
        }
    }

    private static class PageImpl {
        final String title;
        final BaseBuilders.ColorBuilder background;
        final BaseBuilders.ColorBuilder foreground;
        final BaseBuilders.IconBuilder icon;
        final long component;
        final boolean enabled;

        PageImpl(String title, BaseBuilders.ColorBuilder background, BaseBuilders.ColorBuilder foreground, BaseBuilders.IconBuilder icon, long component, boolean enabled) {
            this.title = title;
            this.background = background;
            this.foreground = foreground;
            this.icon = icon;
            this.component = component;
            this.enabled = enabled;
        }
    }

    private static class BasicSplitPaneDividerBuilder
    extends ComponentBuilders.ContainerBuilder<BasicSplitPaneDivider> {
        private final int orientation;
        private final BorderBuilders.BorderBuilder border;

        BasicSplitPaneDividerBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
            this.border = BorderBuilders.fromField(instance, "border", false, heap);
        }

        @Override
        protected void setupInstance(BasicSplitPaneDivider instance) {
            Border b;
            super.setupInstance(instance);
            if (this.border != null && (b = (Border)this.border.createInstance()) != null) {
                instance.setBorder(b);
            }
        }

        @Override
        protected BasicSplitPaneDivider createInstanceImpl() {
            final JSplitPane split = new JSplitPane(this.orientation);
            BasicSplitPaneUI ui = split.getUI() instanceof BasicSplitPaneUI ? (BasicSplitPaneUI)split.getUI() : new BasicSplitPaneUI(){
                {
                    this.installUI(split);
                }
            };
            return new BasicSplitPaneDivider(ui);
        }
    }

    private static class JSplitPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JSplitPane> {
        private final int orientation;

        JSplitPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
        }

        @Override
        protected JSplitPane createInstanceImpl() {
            return new JSplitPane(this.orientation);
        }
    }

    private static class JScrollPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JScrollPane> {
        private final BorderBuilders.BorderBuilder viewportBorder;

        JScrollPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.viewportBorder = BorderBuilders.fromField(instance, "viewportBorder", false, heap);
        }

        @Override
        protected void setupInstance(JScrollPane instance) {
            Border b;
            super.setupInstance(instance);
            if (this.viewportBorder != null && (b = (Border)this.viewportBorder.createInstance()) != null) {
                instance.setViewportBorder(b);
            }
        }

        @Override
        protected JScrollPane createInstanceImpl() {
            return new JScrollPane();
        }
    }

    private static class JViewportBuilder
    extends ComponentBuilders.JComponentBuilder<JViewport> {
        JViewportBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JViewport createInstanceImpl() {
            return new JViewport();
        }
    }
}

