/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.model;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ArrayNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ChildrenComputer;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ClassNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapPatterns;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.InstanceNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ObjectArrayFieldNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ObjectArrayNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ObjectFieldNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ObjectNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.PrimitiveArrayFieldNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.PrimitiveArrayNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.PrimitiveFieldNode;

public class HeapWalkerNodeFactory {
    public static final int ITEMS_COLLAPSE_UNIT_SIZE = 500;
    public static final int ITEMS_COLLAPSE_THRESHOLD = 2000;
    public static final int ITEMS_COLLAPSE_UNIT_THRESHOLD = 5000;

    public static HeapWalkerNode createArrayItemContainerNode(final ArrayNode array, final int startIndex, final int endIndex) {
        return new AbstractHeapWalkerNode(array){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_ArrayContainerNameString(startIndex, endIndex);
            }

            @Override
            protected String computeType() {
                return BrowserUtils.getArrayItemType(array.getType());
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_ArrayContainerValueString(endIndex - startIndex + 1);
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            protected ChildrenComputer getChildrenComputer() {
                return new ChildrenComputer(){

                    @Override
                    public HeapWalkerNode[] computeChildren() {
                        int itemsCount = endIndex - startIndex + 1;
                        HeapWalkerNode[] children = new HeapWalkerNode[itemsCount];
                        boolean primitiveArray = array instanceof PrimitiveArrayNode;
                        List values = primitiveArray ? ((PrimitiveArrayInstance)array.getInstance()).getValues() : ((ObjectArrayInstance)array.getInstance()).getValues();
                        for (int i = 0; i < itemsCount; ++i) {
                            children[i] = primitiveArray ? HeapWalkerNodeFactory.createPrimitiveArrayItemNode((PrimitiveArrayNode)array, startIndex + i, (String)values.get(startIndex + i)) : HeapWalkerNodeFactory.createObjectArrayItemNode((ObjectArrayNode)array, startIndex + i, (Instance)values.get(startIndex + i));
                        }
                        return children;
                    }
                };
            }
        };
    }

    public static ClassNode createClassNode(JavaClass javaClass, String name, HeapWalkerNode parent) {
        return new ClassNode(javaClass, name, parent, parent == null ? 1 : parent.getMode());
    }

    public static HeapWalkerNode createFieldNode(FieldValue fieldValue, HeapWalkerNode parent) {
        if (fieldValue instanceof ObjectFieldValue) {
            Instance instance = ((ObjectFieldValue)fieldValue).getInstance();
            if (instance instanceof PrimitiveArrayInstance) {
                return new PrimitiveArrayFieldNode((ObjectFieldValue)fieldValue, parent);
            }
            if (instance instanceof ObjectArrayInstance) {
                return new ObjectArrayFieldNode((ObjectFieldValue)fieldValue, parent);
            }
            return new ObjectFieldNode((ObjectFieldValue)fieldValue, parent);
        }
        return new PrimitiveFieldNode(fieldValue, parent);
    }

    public static HeapWalkerInstanceNode createInstanceNode(Instance instance, String name, HeapWalkerNode parent) {
        int mode;
        int n = mode = parent == null ? 1 : parent.getMode();
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode((PrimitiveArrayInstance)instance, name, parent, mode);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode((ObjectArrayInstance)instance, name, parent, mode);
        }
        return new ObjectNode(instance, name, parent, mode);
    }

    public static HeapWalkerNode createNoFieldsNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoFieldsString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoFieldsNode(HeapWalkerNode node) {
        return Bundle.HeapWalkerNodeFactory_NoFieldsString().equals(node.getName());
    }

    public static HeapWalkerNode createNoItemsNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoItemsString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoItemsNode(HeapWalkerNode node) {
        return Bundle.HeapWalkerNodeFactory_NoItemsString().equals(node.getName());
    }

    public static HeapWalkerNode createNoReferencesNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoReferencesString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoReferencesNode(HeapWalkerNode node) {
        return Bundle.HeapWalkerNodeFactory_NoReferencesString().equals(node.getName());
    }

    public static HeapWalkerNode createOOMNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_OutOfMemoryString();
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return Icons.getIcon((String)"GeneralIcons.Error");
            }
        };
    }

    public static boolean isOOMNode(HeapWalkerNode node) {
        return Bundle.HeapWalkerNodeFactory_OutOfMemoryString().equals(node.getName());
    }

    public static HeapWalkerNode createObjectArrayItemNode(ObjectArrayNode array, int itemIndex, Instance instance) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.ArrayItem(itemIndex, (PrimitiveArrayInstance)instance, (HeapWalkerNode)array);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.ArrayItem(itemIndex, (ObjectArrayInstance)instance, (HeapWalkerNode)array);
        }
        return new ObjectNode.ArrayItem(itemIndex, instance, (HeapWalkerNode)array);
    }

    public static HeapWalkerNode createPrimitiveArrayItemNode(PrimitiveArrayNode array, int itemIndex, String value) {
        return new PrimitiveFieldNode.ArrayItem(itemIndex, BrowserUtils.getArrayItemType(array.getType()), value, array);
    }

    public static HeapWalkerNode createProgressNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_SearchingString();
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return BrowserUtils.ICON_PROGRESS;
            }
        };
    }

    public static boolean isProgressNode(HeapWalkerNode node) {
        return Bundle.HeapWalkerNodeFactory_SearchingString().equals(node.getName());
    }

    public static HeapWalkerNode[] createReferences(InstanceNode parent) {
        HeapWalkerNode[] referenceNodes = null;
        List references = parent.getReferences();
        referenceNodes = HeapPatterns.processReferencePatterns(parent, references);
        if (referenceNodes != null) {
            return referenceNodes;
        }
        if (references.size() == 0) {
            referenceNodes = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(parent)};
        } else {
            referenceNodes = new HeapWalkerNode[references.size()];
            for (int i = 0; i < referenceNodes.length; ++i) {
                referenceNodes[i] = HeapWalkerNodeFactory.createReferenceNode((Value)references.get(i), parent);
            }
        }
        return referenceNodes;
    }

    public static HeapWalkerNode createReferenceNode(Value value, HeapWalkerNode parent) {
        if (value instanceof ObjectFieldValue) {
            return new ObjectFieldNode((ObjectFieldValue)value, parent);
        }
        if (value instanceof ArrayItemValue) {
            ArrayItemValue arrayValue = (ArrayItemValue)value;
            return new ObjectArrayNode.ArrayItem(arrayValue.getIndex(), (ObjectArrayInstance)arrayValue.getDefiningInstance(), parent);
        }
        return null;
    }

    private static GCRoot getGCRoot(Heap heap, Instance instance) {
        Collection gcRoots = heap.getGCRoots(instance);
        if (gcRoots.isEmpty()) {
            return null;
        }
        return (GCRoot)gcRoots.iterator().next();
    }

    public static ClassNode createRootClassNode(JavaClass javaClass, String name, final Runnable refresher, final Runnable repainter, int mode, final Heap heap) {
        return new ClassNode.RootNode(javaClass, name, null, mode){

            @Override
            public void refreshView() {
                refresher.run();
            }

            @Override
            public GCRoot getGCRoot(Instance inst) {
                return HeapWalkerNodeFactory.getGCRoot(heap, inst);
            }

            @Override
            public JavaClass getJavaClassByID(long javaclassId) {
                return heap.getJavaClassByID(javaclassId);
            }

            @Override
            public String getDetails(Instance instance) {
                return DetailsSupport.getDetailsString(instance, heap);
            }

            @Override
            public void repaintView() {
                repainter.run();
            }
        };
    }

    public static HeapWalkerNode createRootInstanceNode(Instance instance, String name, final Runnable refresher, final Runnable repainter, int mode, final Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.RootNode((PrimitiveArrayInstance)instance, name, null, mode){

                @Override
                public void refreshView() {
                    refresher.run();
                }

                @Override
                public GCRoot getGCRoot(Instance inst) {
                    return HeapWalkerNodeFactory.getGCRoot(heap, inst);
                }

                @Override
                public JavaClass getJavaClassByID(long javaclassId) {
                    return heap.getJavaClassByID(javaclassId);
                }

                @Override
                public String getDetails(Instance instance) {
                    return DetailsSupport.getDetailsString(instance, heap);
                }

                @Override
                public void repaintView() {
                    repainter.run();
                }
            };
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.RootNode((ObjectArrayInstance)instance, name, null, mode){

                @Override
                public void refreshView() {
                    refresher.run();
                }

                @Override
                public GCRoot getGCRoot(Instance inst) {
                    return HeapWalkerNodeFactory.getGCRoot(heap, inst);
                }

                @Override
                public JavaClass getJavaClassByID(long javaclassId) {
                    return heap.getJavaClassByID(javaclassId);
                }

                @Override
                public String getDetails(Instance instance) {
                    return DetailsSupport.getDetailsString(instance, heap);
                }

                @Override
                public void repaintView() {
                    repainter.run();
                }
            };
        }
        return new ObjectNode.RootNode(instance, name, null, mode){

            @Override
            public void refreshView() {
                refresher.run();
            }

            @Override
            public GCRoot getGCRoot(Instance inst) {
                return HeapWalkerNodeFactory.getGCRoot(heap, inst);
            }

            @Override
            public JavaClass getJavaClassByID(long javaclassId) {
                return heap.getJavaClassByID(javaclassId);
            }

            @Override
            public String getDetails(Instance instance) {
                return DetailsSupport.getDetailsString(instance, heap);
            }

            @Override
            public void repaintView() {
                repainter.run();
            }
        };
    }

    public static boolean isMessageNode(HeapWalkerNode node) {
        return HeapWalkerNodeFactory.isNoFieldsNode(node) || HeapWalkerNodeFactory.isNoItemsNode(node) || HeapWalkerNodeFactory.isNoReferencesNode(node) || HeapWalkerNodeFactory.isNoReferencesNode(node) || HeapWalkerNodeFactory.isOOMNode(node) || HeapWalkerNodeFactory.isProgressNode(node);
    }
}

