/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.chromeinspector.types.TypeObject;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;

public final class TypeProfileEntry {
    private final int offset;
    private final TypeObject[] types;

    public TypeProfileEntry(int offset, TypeObject[] types) {
        this.offset = offset;
        this.types = types;
    }

    public int getOffset() {
        return this.offset;
    }

    public TypeObject[] getTypes() {
        return this.types;
    }

    private JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("offset", this.offset);
        json.put("types", (Object)TypeObject.toJSON(this.types));
        return json;
    }

    static JSONArray toJSON(TypeProfileEntry[] entries) {
        JSONArray array = new JSONArray();
        for (TypeProfileEntry entry : entries) {
            array.put((Object)entry.toJSON());
        }
        return array;
    }
}

