/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.agentscript.FrameLibrary;
import com.oracle.truffle.tools.agentscript.impl.AccessorFrameLibrary;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.InsightException;
import java.util.TreeSet;

@ExportLibrary(value=InteropLibrary.class)
final class VariablesObject
implements TruffleObject {
    private final TruffleInstrument.Env env;
    private final Node where;
    private final Frame frame;

    VariablesObject(TruffleInstrument.Env env, Node where, Frame frame) {
        this.env = env;
        this.where = where;
        this.frame = frame.materialize();
    }

    @ExportMessage
    static boolean hasMembers(VariablesObject obj) {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object getMembers(boolean includeInternal, @CachedLibrary(limit="1") FrameLibrary frameLibrary) {
        TreeSet<String> names = new TreeSet<String>();
        try {
            frameLibrary.collectNames(AccessorFrameLibrary.DEFAULT.create(this.where, this.frame, this.env), names);
        }
        catch (InteropException ex) {
            throw InsightException.raise((Exception)((Object)ex));
        }
        return ArrayObject.wrap(names);
    }

    @ExportMessage
    Object readMember(String member, @CachedLibrary(limit="1") FrameLibrary frameLibrary) throws UnknownIdentifierException {
        return frameLibrary.readMember(AccessorFrameLibrary.DEFAULT.create(this.where, this.frame, this.env), member);
    }

    @ExportMessage
    static boolean isMemberReadable(VariablesObject obj, String member) {
        return true;
    }

    @ExportMessage
    void writeMember(String member, Object value, @CachedLibrary(limit="1") FrameLibrary frameLibrary) throws UnknownIdentifierException, UnsupportedTypeException {
        frameLibrary.writeMember(AccessorFrameLibrary.DEFAULT.create(this.where, this.frame, this.env), member, value);
    }

    @ExportMessage
    static boolean isMemberModifiable(VariablesObject obj, String member) {
        return true;
    }

    @ExportMessage
    static boolean isMemberInsertable(VariablesObject obj, String member) {
        return false;
    }
}

