/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.tools.agentscript.FrameLibrary;
import com.oracle.truffle.tools.agentscript.impl.VariablesObject;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=VariablesObject.class)
final class VariablesObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<FrameLibrary> FRAME_LIBRARY_ = LibraryFactory.resolve(FrameLibrary.class);

    private VariablesObjectGen() {
    }

    static {
        LibraryExport.register(VariablesObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=VariablesObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, VariablesObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof VariablesObject);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof VariablesObject);
            return new Cached();
        }

        @GeneratedBy(value=VariablesObject.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof VariablesObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof VariablesObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return VariablesObject.hasMembers((VariablesObject)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                return arg0Value.getMembers(arg1Value, (FrameLibrary)FRAME_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                return arg0Value.readMember(arg1Value, (FrameLibrary)FRAME_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return VariablesObject.isMemberReadable((VariablesObject)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, (FrameLibrary)FRAME_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return VariablesObject.isMemberModifiable((VariablesObject)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return VariablesObject.isMemberInsertable((VariablesObject)receiver, member);
            }
        }

        @GeneratedBy(value=VariablesObject.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private FrameLibrary getMembersNode__frameLibrary_;
            @Node.Child
            private FrameLibrary readMemberNode__frameLibrary_;
            @Node.Child
            private FrameLibrary writeMemberNode__frameLibrary_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof VariablesObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof VariablesObject;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return VariablesObject.hasMembers((VariablesObject)receiver);
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.getMembers(arg1Value, this.getMembersNode__frameLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(VariablesObject arg0Value, boolean arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.getMembersNode__frameLibrary_ = (FrameLibrary)super.insert((Node)((FrameLibrary)FRAME_LIBRARY_.createDispatched(1)));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getMembers(arg1Value, this.getMembersNode__frameLibrary_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.readMember(arg1Value, this.readMemberNode__frameLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(VariablesObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.readMemberNode__frameLibrary_ = (FrameLibrary)super.insert((Node)((FrameLibrary)FRAME_LIBRARY_.createDispatched(1)));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, this.readMemberNode__frameLibrary_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return VariablesObject.isMemberReadable((VariablesObject)receiver, member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                VariablesObject arg0Value = (VariablesObject)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    arg0Value.writeMember(arg1Value, arg2Value, this.writeMemberNode__frameLibrary_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(VariablesObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.writeMemberNode__frameLibrary_ = (FrameLibrary)super.insert((Node)((FrameLibrary)FRAME_LIBRARY_.createDispatched(1)));
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeMember(arg1Value, arg2Value, this.writeMemberNode__frameLibrary_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return VariablesObject.isMemberModifiable((VariablesObject)receiver, member);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return VariablesObject.isMemberInsertable((VariablesObject)receiver, member);
            }
        }
    }
}

