/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.oql.engine.api.impl;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLEngine;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.ReferenceChain;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.impl.ReachableExcludes;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.impl.TreeIterator;
import org.openide.util.Enumerations;

public class Snapshot {
    private final Heap delegate;
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private ReachableExcludes reachableExcludes;
    private final OQLEngine engine;

    public Snapshot(Heap heap, OQLEngine engine) {
        this.delegate = heap;
        this.engine = engine;
        this.init();
    }

    private void init() {
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        if (this.weakReferenceClass == null) {
            this.weakReferenceClass = this.findClass("sun.misc.Ref");
            this.referentFieldIndex = 0;
        } else {
            List flds = this.weakReferenceClass.getFields();
            int fldsCount = flds.size();
            for (int i = 0; i < fldsCount; ++i) {
                if (!"referent".equals(((Field)flds.get(i)).getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
    }

    public JavaClass findClass(String name) {
        try {
            long classId = name.startsWith("0x") ? Long.parseLong(name.substring(2), 16) : Long.parseLong(name);
            return this.delegate.getJavaClassByID(classId);
        }
        catch (NumberFormatException numberFormatException) {
            return this.delegate.getJavaClassByName(this.preprocessClassName(name));
        }
    }

    private String preprocessClassName(String className) {
        int arrDim = 0;
        if (className.startsWith("[")) {
            arrDim = className.lastIndexOf(91) + 1;
            className = className.substring(arrDim);
        }
        if (className.length() == 1) {
            if (className.equals("I")) {
                className = "int";
            } else if (className.equals("J")) {
                className = "long";
            } else if (className.equals("D")) {
                className = "double";
            } else if (className.equals("F")) {
                className = "float";
            } else if (className.equals("B")) {
                className = "byte";
            } else if (className.equals("S")) {
                className = "short";
            } else if (className.equals("C")) {
                className = "char";
            } else if (className.equals("Z")) {
                className = "boolean";
            }
        }
        if (arrDim > 0 && className.charAt(0) == 'L') {
            className = className.substring(1);
        }
        StringBuilder sb = new StringBuilder(className);
        for (int i = 0; i < arrDim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public Instance findThing(long objectId) {
        return this.delegate.getInstanceByID(objectId);
    }

    public GCRoot findRoot(Instance object) {
        Collection roots;
        Instance gcInstance = object;
        while (!(gcInstance = gcInstance.getNearestGCRootPointer()).isGCRoot()) {
        }
        if (gcInstance != null && !(roots = this.delegate.getGCRoots(gcInstance)).isEmpty()) {
            return (GCRoot)roots.iterator().next();
        }
        return null;
    }

    public int distanceToGCRoot(Instance object) {
        Instance gcInstance = object;
        int distance = 0;
        do {
            if ((gcInstance = gcInstance.getNearestGCRootPointer()) == null) {
                return 0;
            }
            ++distance;
        } while (!gcInstance.isGCRoot());
        return distance;
    }

    public Enumeration concat(Enumeration en1, Enumeration en2) {
        return Enumerations.concat((Enumeration)en1, (Enumeration)en2);
    }

    public Iterator getClasses() {
        return this.delegate.getAllClasses().iterator();
    }

    public Iterator getClassNames(String regex) {
        final Iterator delegated = this.delegate.getJavaClassesByRegExp(regex).iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return delegated.hasNext();
            }

            public Object next() {
                return ((JavaClass)delegated.next()).getName();
            }

            @Override
            public void remove() {
                delegated.remove();
            }
        };
    }

    public Iterator getInstances(JavaClass clazz, final boolean includeSubclasses) {
        if (includeSubclasses && clazz.getSuperClass() == null) {
            return this.delegate.getAllInstancesIterator();
        }
        return new TreeIterator<Instance, JavaClass>(clazz){

            @Override
            protected Iterator<Instance> getSameLevelIterator(JavaClass popped) {
                return popped.getInstancesIterator();
            }

            @Override
            protected Iterator<JavaClass> getTraversingIterator(JavaClass popped) {
                return includeSubclasses ? popped.getSubClasses().iterator() : Collections.EMPTY_LIST.iterator();
            }
        };
    }

    public Iterator getReferrers(Object obj, boolean includeWeak) {
        ArrayList<Object> instances = new ArrayList<Object>();
        ArrayList<Instance> references = new ArrayList<Instance>();
        if (obj instanceof Instance) {
            references.addAll(((Instance)obj).getReferences());
        } else if (obj instanceof JavaClass) {
            references.addAll(((JavaClass)obj).getInstances());
            references.add(((JavaClass)obj).getClassLoader());
        }
        if (!references.isEmpty()) {
            for (Object e : references) {
                if (e instanceof Value) {
                    Value val = (Value)e;
                    Instance inst = val.getDefiningInstance();
                    if (!includeWeak && this.isWeakRef(inst)) continue;
                    instances.add(inst);
                    continue;
                }
                if (!(e instanceof Instance) || !includeWeak && this.isWeakRef((Instance)e)) continue;
                instances.add(e);
            }
        }
        return instances.iterator();
    }

    public Iterator getReferees(Object obj, boolean includeWeak) {
        ArrayList<Object> instances = new ArrayList<Object>();
        ArrayList values = new ArrayList();
        if (obj instanceof Instance) {
            Instance o = (Instance)obj;
            values.addAll(o.getFieldValues());
        }
        if (obj instanceof JavaClass) {
            values.addAll(((JavaClass)obj).getStaticFieldValues());
        }
        if (obj instanceof ObjectArrayInstance) {
            ObjectArrayInstance oarr = (ObjectArrayInstance)obj;
            values.addAll(oarr.getValues());
        }
        if (!values.isEmpty()) {
            for (Object value : values) {
                if (value instanceof ObjectFieldValue && ((ObjectFieldValue)value).getInstance() != null) {
                    Instance inst = ((ObjectFieldValue)value).getInstance();
                    if (!includeWeak && this.isWeakRef(inst)) continue;
                    if (inst.getJavaClass().getName().equals("java.lang.Class")) {
                        JavaClass jc = this.delegate.getJavaClassByID(inst.getInstanceId());
                        if (jc != null) {
                            instances.add(jc);
                            continue;
                        }
                        instances.add(inst);
                        continue;
                    }
                    instances.add(inst);
                    continue;
                }
                if (!(value instanceof Instance) || !includeWeak && this.isWeakRef((Instance)value)) continue;
                instances.add(value);
            }
        }
        return instances.iterator();
    }

    public Iterator getFinalizerObjects() {
        JavaClass clazz = this.findClass("java.lang.ref.Finalizer");
        Instance queue = (Instance)clazz.getValueOfStaticField("queue");
        Instance head = (Instance)queue.getValueOfField("head");
        ArrayList<Instance> finalizables = new ArrayList<Instance>();
        if (head != null) {
            while (true) {
                Instance referent = (Instance)head.getValueOfField("referent");
                Instance next = (Instance)head.getValueOfField("next");
                finalizables.add(referent);
                if (next == null || next.equals(head)) break;
                head = next;
            }
        }
        return finalizables.iterator();
    }

    public Iterator getRoots() {
        return this.delegate.getGCRoots().iterator();
    }

    private List getRootsInstancesList() {
        ArrayList<Object> roots = new ArrayList<Object>();
        for (Object rootObj : this.delegate.getGCRoots()) {
            GCRoot root = (GCRoot)rootObj;
            Instance inst = root.getInstance();
            if (inst.getJavaClass().getName().equals("java.lang.Class")) {
                JavaClass jc = this.delegate.getJavaClassByID(inst.getInstanceId());
                if (jc != null) {
                    roots.add(jc);
                    continue;
                }
                roots.add(inst);
                continue;
            }
            roots.add(inst);
        }
        return roots;
    }

    public GCRoot[] getRootsArray() {
        Collection rootList = this.delegate.getGCRoots();
        return rootList.toArray(new GCRoot[0]);
    }

    public ReferenceChain[] rootsetReferencesTo(Instance target, boolean includeWeak) {
        ArrayDeque<State> stack = new ArrayDeque<State>();
        HashSet<Object> ignored = new HashSet<Object>();
        ArrayList<ReferenceChain> result = new ArrayList<ReferenceChain>();
        Iterator toInspect = this.getRootsInstancesList().iterator();
        ReferenceChain path = null;
        class State {
            private Iterator<Instance> iterator;
            private ReferenceChain path;
            private AtomicLong hits = new AtomicLong(0L);

            public State(ReferenceChain path, Iterator<Instance> iterator) {
                this.iterator = iterator;
                this.path = path;
            }
        }
        State s = new State(path, toInspect);
        do {
            if (path != null && path.getObj().equals(target)) {
                result.add(path);
                s.hits.incrementAndGet();
            } else {
                while (!this.engine.isCancelled() && toInspect.hasNext()) {
                    Instance node = toInspect.next();
                    if (path != null && path.contains(node) || ignored.contains(node)) continue;
                    stack.push(s);
                    path = new ReferenceChain(this.delegate, node, path);
                    toInspect = this.getReferees(node, includeWeak);
                    s = new State(path, toInspect);
                }
                if (path != null && path.getObj().equals(target)) {
                    result.add(path);
                    s.hits.incrementAndGet();
                }
            }
            State s1 = (State)stack.poll();
            if (s1 == null) break;
            s1.hits.addAndGet(s.hits.get());
            if (s.hits.get() == 0L && path != null) {
                ignored.add(path.getObj());
            }
            s = s1;
            path = s.path;
            toInspect = s.iterator;
        } while (!this.engine.isCancelled());
        return result.toArray(new ReferenceChain[0]);
    }

    private boolean isAssignable(JavaClass from, JavaClass to) {
        if (from == to) {
            return true;
        }
        if (from == null) {
            return false;
        }
        return this.isAssignable(from.getSuperClass(), to);
    }

    private boolean isWeakRef(Instance inst) {
        return this.weakReferenceClass != null && this.isAssignable(inst.getJavaClass(), this.weakReferenceClass);
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public void setReachableExcludes(ReachableExcludes e) {
        this.reachableExcludes = e;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    public String valueString(Instance instance) {
        if (instance == null) {
            return null;
        }
        try {
            if (instance.getJavaClass().getName().equals(String.class.getName())) {
                Class<?> proxy = Class.forName("org.graalvm.visualvm.lib.jfluid.heap.HprofProxy");
                Method method = proxy.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(proxy, instance);
            }
            if (instance.getJavaClass().getName().equals("char[]")) {
                Method method = instance.getClass().getDeclaredMethod("getChars", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                char[] chars = (char[])method.invoke((Object)instance, 0, ((PrimitiveArrayInstance)instance).getLength());
                if (chars != null) {
                    return new String(chars);
                }
                return "*null*";
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Snapshot.class.getName()).log(Level.WARNING, "Error getting toString() value of an instance dump", ex);
        }
        return instance.toString();
    }
}

