/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleToLibGraal;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilationTask;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerRuntimeGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.WordFactory;

final class HSTruffleCompilerRuntime
extends HSObject
implements HotSpotTruffleCompilerRuntime {
    private static final Map<Integer, JavaKind> JAVA_KINDS;
    private final ResolvedJavaType classLoaderDelegate;
    private final OptionValues initialOptions;
    private volatile Map<String, Object> cachedOptionsMap;

    HSTruffleCompilerRuntime(JNI.JNIEnv env, JNI.JObject handle, ResolvedJavaType classLoaderDelegate, OptionValues options) {
        super(env, handle);
        this.classLoaderDelegate = classLoaderDelegate;
        this.initialOptions = options;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateInliningPlan)
    public TruffleInliningPlan createInliningPlan(CompilableTruffleAST compilable, TruffleCompilationTask task) {
        JNILibGraalScope scope = JNILibGraalScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        JNI.JObject compilableHandle = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject taskHandle = task == null ? (JNI.JObject)WordFactory.nullPointer() : ((HSTruffleCompilationTask)task).getHandle();
        Object hsInliningPlan = HSTruffleCompilerRuntimeGen.callCreateInliningPlan(scope.getEnv(), this.getHandle(), compilableHandle, taskHandle);
        return new HSTruffleInliningPlan((JNILibGraalScope<TruffleToLibGraal.Id>)scope.narrow(TruffleToLibGraal.Id.class), (JNI.JObject)hsInliningPlan);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsCompilableTruffleAST)
    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        JNILibGraalScope scope = JNILibGraalScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        long constantHandle = LibGraal.translate((Object)constant);
        Object hsCompilable = HSTruffleCompilerRuntimeGen.callAsCompilableTruffleAST(scope.getEnv(), this.getHandle(), constantHandle);
        if (hsCompilable.isNull()) {
            return null;
        }
        return new HSCompilableTruffleAST((JNILibGraalScope<TruffleToLibGraal.Id>)scope.narrow(TruffleToLibGraal.Id.class), (JNI.JObject)hsCompilable);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCodeInstallation)
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        long installedCodeHandle = LibGraal.translate((Object)installedCode);
        JNI.JNIEnv env = JNILibGraalScope.env();
        HSTruffleCompilerRuntimeGen.callOnCodeInstallation(env, this.getHandle(), ((HSCompilableTruffleAST)compilable).getHandle(), installedCodeHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency)
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumption) {
        long optimizedAssumptionHandle = LibGraal.translate((Object)optimizedAssumption);
        JNI.JNIEnv env = JNILibGraalScope.env();
        Object assumptionConsumer = HSTruffleCompilerRuntimeGen.callRegisterOptimizedAssumptionDependency(env, this.getHandle(), optimizedAssumptionHandle);
        return assumptionConsumer.isNull() ? null : new HSConsumer((JNILibGraalScope<TruffleToLibGraal.Id>)JNILibGraalScope.scope().narrow(TruffleToLibGraal.Id.class), (JNI.JObject)assumptionConsumer);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallTargetForCallNode)
    public JavaConstant getCallTargetForCallNode(JavaConstant callNode) {
        long callNodeHandle = LibGraal.translate((Object)callNode);
        JNI.JNIEnv env = JNILibGraalScope.env();
        long callTargetHandle = HSTruffleCompilerRuntimeGen.callGetCallTargetForCallNode(env, this.getHandle(), callNodeHandle);
        return (JavaConstant)LibGraal.unhand(JavaConstant.class, (long)callTargetHandle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTruffleBoundary)
    public boolean isTruffleBoundary(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsTruffleBoundary(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)method));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsValueType)
    public boolean isValueType(ResolvedJavaType type) {
        return HSTruffleCompilerRuntimeGen.callIsValueType(JNILibGraalScope.env(), this.getHandle(), LibGraal.translate((Object)type));
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetInlineKind)
    public TruffleCompilerRuntime.InlineKind getInlineKind(ResolvedJavaMethod original, boolean duringPartialEvaluation) {
        long methodHandle = LibGraal.translate((Object)original);
        int inlineKindOrdinal = HSTruffleCompilerRuntimeGen.callGetInlineKind(JNILibGraalScope.env(), this.getHandle(), methodHandle, duringPartialEvaluation);
        return TruffleCompilerRuntime.InlineKind.values()[inlineKindOrdinal];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLoopExplosionKind)
    public TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        long methodHandle = LibGraal.translate((Object)method);
        int loopExplosionKindOrdinal = HSTruffleCompilerRuntimeGen.callGetLoopExplosionKind(JNILibGraalScope.env(), this.getHandle(), methodHandle);
        return TruffleCompilerRuntime.LoopExplosionKind.values()[loopExplosionKindOrdinal];
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetConstantFieldInfo)
    public TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        ResolvedJavaType enclosingType = field.getDeclaringClass();
        boolean isStatic = field.isStatic();
        Object[] declaredFields = isStatic ? enclosingType.getStaticFields() : enclosingType.getInstanceFields(false);
        int fieldIndex = -1;
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!field.equals(declaredFields[i])) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex == -1) {
            throw new IllegalStateException(String.format("%s field: %s declared in: %s is not in declared fields: %s", isStatic ? "Static" : "Instance", field, enclosingType, Arrays.toString(declaredFields)));
        }
        long typeHandle = LibGraal.translate((Object)enclosingType);
        int fieldInfoDimension = HSTruffleCompilerRuntimeGen.callGetConstantFieldInfo(JNILibGraalScope.env(), this.getHandle(), typeHandle, isStatic, fieldIndex);
        switch (fieldInfoDimension) {
            case -2147483648: {
                return null;
            }
            case -2: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILDREN;
            }
            case -1: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILD;
            }
        }
        return TruffleCompilerRuntime.ConstantFieldInfo.forDimensions((int)fieldInfoDimension);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetJavaKindForFrameSlotKind)
    public JavaKind getJavaKindForFrameSlotKind(int frameSlotKindTag) {
        int basicType = HSTruffleCompilerRuntimeGen.callGetJavaKindForFrameSlotKind(JNILibGraalScope.env(), this.getHandle(), frameSlotKindTag);
        return JAVA_KINDS.get(basicType);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagsCount)
    public int getFrameSlotKindTagsCount() {
        return HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagsCount(JNILibGraalScope.env(), this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetTruffleCallBoundaryMethods)
    public Iterable<ResolvedJavaMethod> getTruffleCallBoundaryMethods() {
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JLongArray handles = (JNI.JLongArray)HSTruffleCompilerRuntimeGen.callGetTruffleCallBoundaryMethods(env, this.getHandle());
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)handles);
        ArrayList<ResolvedJavaMethod> res = new ArrayList<ResolvedJavaMethod>();
        CLongPointer longs = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            for (int i = 0; i < len; ++i) {
                res.add((ResolvedJavaMethod)LibGraal.unhand(ResolvedJavaMethod.class, (long)longs.read(i)));
            }
        }
        finally {
            JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (CLongPointer)longs, (int)2);
        }
        return res;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagForJavaKind)
    public int getFrameSlotKindTagForJavaKind(JavaKind kind) {
        return HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagForJavaKind(JNILibGraalScope.env(), this.getHandle(), kind.getBasicType());
    }

    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        String internalName = JNIUtil.getInternalName((String)className);
        JavaType jt = HotSpotJVMCIRuntime.runtime().lookupType(internalName, (HotSpotResolvedObjectType)this.classLoaderDelegate, true);
        if (jt instanceof UnresolvedJavaType) {
            if (required) {
                throw new NoClassDefFoundError(internalName);
            }
            return null;
        }
        return (ResolvedJavaType)jt;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.Log)
    public void log(CompilableTruffleAST compilable, String message) {
        JNI.JNIEnv env = JNILibGraalScope.env();
        JNI.JString jniMessage = JNIUtil.createHSString((JNI.JNIEnv)env, (String)message);
        HSTruffleCompilerRuntimeGen.callLog(env, this.getHandle(), ((HSCompilableTruffleAST)compilable).getHandle(), (JNI.JObject)jniMessage);
    }

    public Map<String, Object> getOptions() {
        Map<String, Object> res = this.cachedOptionsMap;
        if (res == null) {
            res = new HashMap<String, Object>();
            UnmodifiableMapCursor optionValues = this.initialOptions.getMap().getEntries();
            while (optionValues.advance()) {
                OptionKey key = (OptionKey)optionValues.getKey();
                Object value = optionValues.getValue();
                res.put(key.getName(), value);
            }
            this.cachedOptionsMap = res;
        }
        return res;
    }

    public <T> T getOptions(Class<T> optionValuesType) {
        if (optionValuesType == OptionValues.class) {
            return optionValuesType.cast(this.initialOptions);
        }
        return (T)super.getOptions(optionValuesType);
    }

    public <T> T convertOptions(Class<T> optionValuesType, Map<String, Object> map) {
        if (optionValuesType == OptionValues.class) {
            EconomicMap values = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption((String)optionName, (Object)optionValue, (EconomicMap)values, (Iterable)loader);
            }
            return optionValuesType.cast(new OptionValues((UnmodifiableEconomicMap)values));
        }
        return (T)super.convertOptions(optionValuesType, map);
    }

    public TruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        throw new UnsupportedOperationException("Should never be called in the compiler.");
    }

    static {
        HashMap<Integer, JavaKind> m = new HashMap<Integer, JavaKind>();
        for (JavaKind jk : JavaKind.values()) {
            m.put(jk.getBasicType(), jk);
        }
        JAVA_KINDS = Collections.unmodifiableMap(m);
    }

    private static class HSConsumer
    extends HSObject
    implements Consumer<OptimizedAssumptionDependency> {
        HSConsumer(JNILibGraalScope<TruffleToLibGraal.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @Override
        @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency)
        public void accept(OptimizedAssumptionDependency dependency) {
            JNI.JObject dependencyHandle = dependency == null ? (JNI.JObject)WordFactory.nullPointer() : ((HSCompilableTruffleAST)dependency).getHandle();
            HSTruffleCompilerRuntimeGen.callConsumeOptimizedAssumptionDependency(JNILibGraalScope.env(), this.getHandle(), dependencyHandle);
        }
    }
}

