/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.buffer.NIOBufferAccessNode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public abstract class NIOBufferUTF8SliceNode
extends NIOBufferAccessNode {
    private static final int V8MaxStringLength = 1073741799;
    protected final BranchProfile nativePath = BranchProfile.create();
    protected final BranchProfile errorBranch = BranchProfile.create();

    public NIOBufferUTF8SliceNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    private DynamicObject getNativeUtf8Slice() {
        return GraalJSAccess.getRealmEmbedderData(this.getContext().getRealm()).getNativeUtf8Slice();
    }

    @Specialization(guards={"accept(target)"})
    public Object slice(DynamicObject target, int start, int end) {
        try {
            return this.doSlice(target, start, end);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, start, end);
        }
    }

    @Specialization(guards={"accept(target)"})
    public Object slice(DynamicObject target, double start, double end) {
        try {
            return this.doSlice(target, (int)start, (int)end);
        }
        catch (CharacterCodingException e) {
            return this.doNativeFallback(target, start, end);
        }
    }

    @Specialization
    public Object sliceDefault(DynamicObject target, Object start, Object end) {
        return JSFunction.call((DynamicObject)this.getNativeUtf8Slice(), (Object)target, (Object[])new Object[]{start, end});
    }

    @Specialization(guards={"!isJSArrayBufferView(target)"})
    public Object sliceAbort(Object target, Object start, Object end) {
        throw Errors.createTypeErrorArrayBufferViewExpected();
    }

    private Object doNativeFallback(DynamicObject target, Object start, Object end) {
        this.nativePath.enter();
        return JSFunction.call((DynamicObject)this.getNativeUtf8Slice(), (Object)target, (Object[])new Object[]{start, end});
    }

    private Object doSlice(DynamicObject target, int start, int end) throws CharacterCodingException {
        int length;
        boolean isArrayBufferView = JSArrayBufferView.isJSArrayBufferView((DynamicObject)target);
        DynamicObject arrayBuffer = NIOBufferUTF8SliceNode.getArrayBuffer(target, isArrayBufferView);
        ByteBuffer rawBuffer = NIOBufferUTF8SliceNode.getDirectByteBuffer(arrayBuffer);
        int byteOffset = this.getOffset(target, isArrayBufferView);
        int actualEnd = end;
        if (end < start) {
            actualEnd = start;
        }
        if (rawBuffer.capacity() == 0) {
            return "";
        }
        if (actualEnd > rawBuffer.capacity() || !NIOBufferUTF8SliceNode.oobCheck(start, end)) {
            this.errorBranch.enter();
            this.outOfBoundsFail();
        }
        if ((length = actualEnd - start) > 1073741799) {
            return this.doNativeFallback(target, start, end);
        }
        int bufferLen = this.getLength(target);
        if (length > bufferLen) {
            this.errorBranch.enter();
            this.outOfBoundsFail();
        }
        ByteBuffer data = NIOBufferUTF8SliceNode.sliceBuffer(rawBuffer, byteOffset);
        BufferUtil.asBaseBuffer((Buffer)data).position(start).limit(end);
        return NIOBufferUTF8SliceNode.doDecode(data);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doDecode(ByteBuffer data) throws CharacterCodingException {
        CharsetDecoder decoder = utf8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer decoded = decoder.decode(data);
        return decoded.toString();
    }

    private static boolean oobCheck(int start, int end) {
        return start <= end && start >= 0;
    }
}

