/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.info.ObjectTemplate;
import com.oracle.truffle.trufflenode.info.PropertyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ExecuteNativePropertyHandlerNode
extends JavaScriptRootNode {
    private final GraalJSAccess graalAccess;
    private final JSContext context;
    private final PropertyHandler namedHandler;
    private final PropertyHandler indexedHandler;
    private final Object proxy;
    private final Object namedHandlerData;
    private final Object indexedHandlerData;
    private final Mode mode;
    private final boolean stringKeysOnly;
    @Node.Child
    private PropertyGetNode holderPropertyGetNode;

    public ExecuteNativePropertyHandlerNode(GraalJSAccess graalAccess, JSContext context, ObjectTemplate template, Object proxy, Mode mode) {
        this.graalAccess = graalAccess;
        this.context = context;
        this.indexedHandler = template.getIndexedPropertyHandler();
        this.indexedHandlerData = this.indexedHandler == null ? null : this.indexedHandler.getData();
        this.namedHandler = template.getNamedPropertyHandler();
        this.namedHandlerData = this.namedHandler == null ? null : this.namedHandler.getData();
        this.stringKeysOnly = template.getStringKeysOnly();
        this.proxy = proxy;
        this.mode = mode;
        this.holderPropertyGetNode = PropertyGetNode.createGetHidden((HiddenKey)GraalJSAccess.HOLDER_KEY, (JSContext)context);
    }

    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        Object holder = this.holderPropertyGetNode.getValue(arguments[1]);
        return this.executePropertyHandlerMethod(holder, arguments);
    }

    private Object executePropertyHandlerMethod(Object holder, Object[] arguments) {
        switch (this.mode) {
            case GETTER: {
                return this.executeGetter(holder, arguments);
            }
            case SETTER: {
                return this.executeSetter(holder, arguments);
            }
            case QUERY: {
                return this.executeQuery(holder, arguments);
            }
            case GET_OWN_PROPERTY_DESCRIPTOR: {
                return this.executeGetOwnPropertyDescriptor(holder, arguments);
            }
            case DELETER: {
                return this.executeDeleter(holder, arguments);
            }
            case OWN_KEYS: {
                return this.executeOwnKeys(holder, arguments);
            }
            case DEFINE_PROPERTY: {
                return this.executeDefiner(holder, arguments);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalArgumentException();
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeGetter(Object holder, Object[] arguments) {
        Object result = null;
        Object key = arguments[3];
        if (!(key instanceof HiddenKey)) {
            if (JSRuntime.isArrayIndex((Object)key)) {
                if (this.indexedHandler != null) {
                    result = NativeAccess.executePropertyHandlerGetter(this.indexedHandler.getGetter(), holder, arguments, this.indexedHandlerData, false);
                }
            } else if (this.namedHandler != null) {
                if (!(key instanceof Symbol)) {
                    key = JSRuntime.toString((Object)key);
                }
                if (!this.stringKeysOnly || JSRuntime.isString((Object)key)) {
                    result = NativeAccess.executePropertyHandlerGetter(this.namedHandler.getGetter(), holder, arguments, this.namedHandlerData, true);
                }
            }
        }
        result = result == null ? JSObject.get((DynamicObject)((DynamicObject)arguments[2]), (Object)key) : this.graalAccess.correctReturnValue(result);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeSetter(Object holder, Object[] arguments) {
        PropertyDescriptor targetDesc;
        Object key = arguments[3];
        if (JSRuntime.isArrayIndex((Object)key)) {
            if (this.indexedHandler != null && this.indexedHandler.getSetter() != 0L) {
                NativeAccess.executePropertyHandlerSetter(this.indexedHandler.getSetter(), holder, arguments, this.indexedHandlerData, false);
            }
        } else if (!(key instanceof HiddenKey || this.stringKeysOnly && !JSRuntime.isString((Object)key))) {
            if (this.namedHandler != null && this.namedHandler.getSetter() != 0L) {
                NativeAccess.executePropertyHandlerSetter(this.namedHandler.getSetter(), holder, arguments, this.namedHandlerData, true);
            }
        } else {
            JSObject.set((DynamicObject)((DynamicObject)arguments[2]), (Object)key, (Object)arguments[4]);
        }
        if ((targetDesc = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)key)) != null && targetDesc.isDataDescriptor() && !targetDesc.getConfigurable() && !targetDesc.getWritable() && !JSRuntime.isSameValue((Object)arguments[4], (Object)targetDesc.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeQuery(Object holder, Object[] arguments) {
        Object[] nativeCallArgs;
        Object key = arguments[3];
        if (JSRuntime.isArrayIndex((Object)key)) {
            if (this.indexedHandler != null) {
                Object result;
                nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3]});
                if (this.indexedHandler.getQuery() != 0L) {
                    return NativeAccess.executePropertyHandlerQuery(this.indexedHandler.getQuery(), holder, nativeCallArgs, this.indexedHandlerData, false) != null;
                }
                if (this.indexedHandler.getDescriptor() != 0L && (result = NativeAccess.executePropertyHandlerDescriptor(this.indexedHandler.getDescriptor(), holder, nativeCallArgs, this.indexedHandlerData, false)) != null) {
                    return true;
                }
            }
        } else if ((!this.stringKeysOnly || JSRuntime.isString((Object)key)) && this.namedHandler != null) {
            Object result;
            nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3]});
            if (this.namedHandler.getQuery() != 0L) {
                return NativeAccess.executePropertyHandlerQuery(this.namedHandler.getQuery(), holder, nativeCallArgs, this.namedHandlerData, true) != null;
            }
            if (this.namedHandler.getDescriptor() != 0L && (result = NativeAccess.executePropertyHandlerDescriptor(this.namedHandler.getDescriptor(), holder, nativeCallArgs, this.namedHandlerData, true)) != null) {
                return true;
            }
        }
        DynamicObject target = (DynamicObject)arguments[2];
        return JSObject.hasProperty((DynamicObject)target, (Object)key);
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeDeleter(Object holder, Object[] arguments) {
        boolean success = true;
        Object key = arguments[3];
        if (JSRuntime.isArrayIndex((Object)key)) {
            if (this.indexedHandler != null && this.indexedHandler.getDeleter() != 0L) {
                Object[] nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3]});
                success = NativeAccess.executePropertyHandlerDeleter(this.indexedHandler.getDeleter(), holder, nativeCallArgs, this.indexedHandlerData, false);
            }
        } else if ((!this.stringKeysOnly || JSRuntime.isString((Object)key)) && this.namedHandler != null && this.namedHandler.getDeleter() != 0L) {
            Object[] nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3]});
            success = NativeAccess.executePropertyHandlerDeleter(this.namedHandler.getDeleter(), holder, nativeCallArgs, this.namedHandlerData, true);
        }
        if (JSObject.hasOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3])) {
            success &= JSObject.delete((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3]);
        }
        return success;
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeGetOwnPropertyDescriptor(Object holder, Object[] arguments) {
        Object key = arguments[3];
        PropertyDescriptor desc = null;
        if (JSRuntime.isArrayIndex((Object)key)) {
            if (this.indexedHandler != null) {
                if (this.indexedHandler.getDescriptor() != 0L) {
                    Object result = this.executeDescriptorCallback(holder, arguments, false);
                    if (result != null) {
                        return result;
                    }
                } else {
                    desc = this.executeGetOwnPropertyDescriptorHelper(holder, arguments, false);
                }
            }
            if (desc == null) {
                desc = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3]);
            }
        } else if (!this.stringKeysOnly || JSRuntime.isString((Object)key)) {
            if (this.namedHandler != null) {
                if (this.namedHandler.getDescriptor() != 0L) {
                    Object result = this.executeDescriptorCallback(holder, arguments, true);
                    if (result != null) {
                        return result;
                    }
                } else {
                    desc = this.executeGetOwnPropertyDescriptorHelper(holder, arguments, true);
                }
            }
            if (desc == null && (desc = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3])) == null && this.indexedHandler != null) {
                desc = this.executeGetOwnPropertyDescriptorHelper(holder, arguments, false);
            }
        }
        return desc == null ? Undefined.instance : JSRuntime.fromPropertyDescriptor(desc, (JSContext)this.context);
    }

    private Object executeDescriptorCallback(Object holder, Object[] arguments, boolean named) {
        PropertyDescriptor desc;
        PropertyHandler handler = named ? this.namedHandler : this.indexedHandler;
        Object handlerData = named ? this.namedHandlerData : this.indexedHandlerData;
        Object result = NativeAccess.executePropertyHandlerDescriptor(handler.getDescriptor(), holder, arguments, handlerData, named);
        if (result == null) {
            PropertyDescriptor desc2 = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3]);
            if (desc2 != null && desc2.hasConfigurable() && !desc2.getConfigurable()) {
                return JSRuntime.fromPropertyDescriptor((PropertyDescriptor)desc2, (JSContext)this.context);
            }
        } else if (!(JSObject.hasProperty((DynamicObject)((DynamicObject)result), (Object)"configurable") && JSRuntime.toBoolean((Object)JSObject.get((DynamicObject)((DynamicObject)result), (Object)"configurable")) || (desc = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3])) != null)) {
            desc = JSRuntime.toPropertyDescriptor((Object)result);
            desc.setConfigurable(true);
            return JSRuntime.fromPropertyDescriptor((PropertyDescriptor)desc, (JSContext)this.context);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private PropertyDescriptor executeGetOwnPropertyDescriptorHelper(Object holder, Object[] arguments, boolean named) {
        PropertyDescriptor desc = null;
        PropertyHandler handler = named ? this.namedHandler : this.indexedHandler;
        Object handlerData = named ? this.namedHandlerData : this.indexedHandlerData;
        Object[] nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3]});
        Object attributes = null;
        if (handler.getQuery() != 0L) {
            attributes = NativeAccess.executePropertyHandlerQuery(handler.getQuery(), holder, nativeCallArgs, handlerData, named);
            attributes = this.graalAccess.correctReturnValue(attributes);
        }
        if (attributes == null && handler.getEnumerator() != 0L) {
            nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2]});
            DynamicObject ownKeys = (DynamicObject)NativeAccess.executePropertyHandlerEnumerator(handler.getEnumerator(), holder, nativeCallArgs, handlerData);
            if (JSRuntime.isArray((Object)ownKeys) && ExecuteNativePropertyHandlerNode.arrayContains(ownKeys, arguments[3])) {
                desc = PropertyDescriptor.undefinedDataDesc;
            }
        } else {
            desc = JSObject.getOwnProperty((DynamicObject)((DynamicObject)arguments[2]), (Object)arguments[3]);
            if (desc == null) {
                Object value = this.executeGetter(holder, JSArguments.create((Object)arguments[0], (Object)arguments[1], (Object[])new Object[]{arguments[2], arguments[3], this.proxy}));
                desc = GraalJSAccess.propertyDescriptor(ExecuteNativePropertyHandlerNode.makeConfigurable(((Number)attributes).intValue()), value);
            }
        }
        return desc;
    }

    private static int makeConfigurable(int attributes) {
        return attributes & 0xFFFFFFFB;
    }

    private static boolean arrayContains(DynamicObject array, Object item) {
        for (Object object : JSAbstractArray.toArray((DynamicObject)array)) {
            if (!object.equals(item)) continue;
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeOwnKeys(Object holder, Object[] arguments) {
        Object[] nativeCallArgs = JSArguments.create((Object)this.proxy, (Object)arguments[1], (Object[])new Object[]{arguments[2]});
        DynamicObject ownKeys = null;
        if (this.namedHandler != null && this.namedHandler.getEnumerator() != 0L) {
            ownKeys = (DynamicObject)NativeAccess.executePropertyHandlerEnumerator(this.namedHandler.getEnumerator(), holder, nativeCallArgs, this.namedHandlerData);
        }
        if (this.indexedHandler != null && this.indexedHandler.getEnumerator() != 0L) {
            DynamicObject ownKeys2 = (DynamicObject)NativeAccess.executePropertyHandlerEnumerator(this.indexedHandler.getEnumerator(), holder, nativeCallArgs, this.indexedHandlerData);
            ownKeys = ExecuteNativePropertyHandlerNode.concatArrays(ownKeys, ownKeys2, this.context);
        }
        if (ownKeys == null) {
            ownKeys = JSArray.createEmpty((JSContext)this.context, (int)0);
        }
        DynamicObject target = (DynamicObject)arguments[2];
        ExecuteNativePropertyHandlerNode.fixOwnKeysInvariants(ownKeys, target);
        return ownKeys;
    }

    private static void fixOwnKeysInvariants(DynamicObject ownKeys, DynamicObject target) {
        List targetKeys = JSObject.ownPropertyKeys((DynamicObject)target);
        for (Object key : targetKeys) {
            PropertyDescriptor desc = JSObject.getOwnProperty((DynamicObject)target, key);
            if (desc == null || desc.getConfigurable()) continue;
            long length = JSAbstractArray.arrayGetLength((DynamicObject)ownKeys);
            JSObject.set((DynamicObject)ownKeys, (long)length, key);
        }
        HashSet<Object> keySet = new HashSet<Object>();
        int duplicates = 0;
        long length = JSAbstractArray.arrayGetLength((DynamicObject)ownKeys);
        for (long i = 0L; i < length; ++i) {
            boolean set;
            Object key = JSObject.get((DynamicObject)ownKeys, (long)i);
            boolean bl = set = duplicates != 0;
            if (!(key instanceof String) && !(key instanceof Symbol)) {
                key = JSRuntime.toString((Object)key);
                set = true;
            }
            if (!keySet.add(key)) {
                ++duplicates;
                set = false;
            }
            if (!set) continue;
            JSObject.set((DynamicObject)ownKeys, (long)(i - (long)duplicates), (Object)key);
        }
        if (duplicates != 0) {
            JSAbstractArray.arraySetLength((DynamicObject)ownKeys, (long)(length - (long)duplicates));
        }
    }

    private static DynamicObject concatArrays(DynamicObject array1, DynamicObject array2, JSContext context) {
        if (JSRuntime.isArray((Object)array1)) {
            if (JSRuntime.isArray((Object)array2)) {
                ArrayList<Object> keys = new ArrayList<Object>(Arrays.asList(JSArray.toArray((DynamicObject)array1)));
                for (Object key : JSArray.toArray((DynamicObject)array2)) {
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
                return JSArray.createConstant((JSContext)context, (Object[])keys.toArray());
            }
            return array1;
        }
        return array2;
    }

    @CompilerDirectives.TruffleBoundary
    private Object executeDefiner(Object holder, Object[] arguments) {
        Object key = arguments[3];
        PropertyDescriptor descriptor = JSRuntime.toPropertyDescriptor((Object)arguments[4]);
        int flags = (descriptor.hasConfigurable() ? 1 : 0) + (descriptor.getConfigurable() ? 2 : 0) + (descriptor.hasEnumerable() ? 4 : 0) + (descriptor.getEnumerable() ? 8 : 0) + (descriptor.hasWritable() ? 16 : 0) + (descriptor.getWritable() ? 32 : 0);
        DynamicObject target = (DynamicObject)arguments[2];
        boolean nonConfigurable = !descriptor.hasConfigurable() || !descriptor.getConfigurable();
        PropertyDescriptor targetDesc = null;
        if (nonConfigurable && (targetDesc = JSObject.getOwnProperty((DynamicObject)target, (Object)key)) != null && targetDesc.hasConfigurable() && targetDesc.getConfigurable()) {
            flags |= 2;
            nonConfigurable = false;
        }
        boolean handled = false;
        if (JSRuntime.isArrayIndex((Object)key)) {
            if (this.indexedHandler != null && this.indexedHandler.getDefiner() != 0L) {
                NativeAccess.executePropertyHandlerDefiner(this.indexedHandler.getDefiner(), holder, descriptor.getValue(), descriptor.getGet(), descriptor.getSet(), flags, arguments, this.indexedHandlerData, false);
                handled = true;
            }
        } else if ((!this.stringKeysOnly || JSRuntime.isString((Object)key)) && this.namedHandler != null && this.namedHandler.getDefiner() != 0L) {
            NativeAccess.executePropertyHandlerDefiner(this.namedHandler.getDefiner(), holder, descriptor.getValue(), descriptor.getGet(), descriptor.getSet(), flags, arguments, this.namedHandlerData, true);
            handled = true;
        }
        if (handled) {
            if (nonConfigurable && targetDesc == null) {
                return JSObject.defineOwnProperty((DynamicObject)target, (Object)key, (PropertyDescriptor)descriptor);
            }
            return true;
        }
        this.executeDeleter(holder, arguments);
        return JSObject.defineOwnProperty((DynamicObject)target, (Object)key, (PropertyDescriptor)descriptor);
    }

    public static enum Mode {
        GETTER,
        SETTER,
        QUERY,
        DELETER,
        OWN_KEYS,
        GET_OWN_PROPERTY_DESCRIPTOR,
        DEFINE_PROPERTY;

    }
}

