/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.node;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.trufflenode.node.FlattenNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FlattenNode.class)
final class FlattenNodeGen
extends FlattenNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;

    private FlattenNodeGen() {
    }

    @Override
    @ExplodeLoop
    protected Object execute(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_2 = (JSLazyString)arg0Value;
            return FlattenNode.doLazyString(arg0Value_2);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitString((int)((state & 0x1E000) >>> 13), (Object)arg0Value)) {
            String arg0Value_3 = JSTypesGen.asImplicitString((int)((state & 0x1E000) >>> 13), (Object)arg0Value);
            return FlattenNode.doString(arg0Value_3);
        }
        if ((state & 4) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_4 = (Symbol)arg0Value;
            return FlattenNode.doSymbol(arg0Value_4);
        }
        if ((state & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_5 = (BigInt)arg0Value;
            return FlattenNode.doBigInt(arg0Value_5);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_6 = (Boolean)arg0Value;
            return FlattenNode.doBoolean(arg0Value_6);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Integer) {
            int arg0Value_7 = (Integer)arg0Value;
            return FlattenNode.doInt(arg0Value_7);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_8 = (SafeInteger)arg0Value;
            return FlattenNode.doSafeInteger(arg0Value_8);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Long) {
            long arg0Value_9 = (Long)arg0Value;
            return FlattenNode.doLong(arg0Value_9);
        }
        if ((state & 0x100) != 0 && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000) >>> 17), (Object)arg0Value)) {
            double arg0Value_10 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000) >>> 17), (Object)arg0Value);
            return FlattenNode.doDouble(arg0Value_10);
        }
        if ((state & 0x200) != 0 && JSTypes.isDynamicObject((Object)arg0Value) && JSObject.isJSObject((Object)(arg0Value_ = (DynamicObject)arg0Value))) {
            return FlattenNode.doJSObject(arg0Value_);
        }
        if ((state & 0xC00) != 0 && arg0Value instanceof TruffleObject) {
            arg0Value_ = (TruffleObject)arg0Value;
            if ((state & 0x400) != 0) {
                ForeignObject0Data s11_ = this.foreignObject0_cache;
                while (s11_ != null) {
                    if (s11_.interop_.accepts((Object)arg0Value_) && JSRuntime.isForeignObject((TruffleObject)arg0Value_)) {
                        return FlattenNode.doForeignObject((TruffleObject)arg0Value_, s11_.interop_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0 && JSRuntime.isForeignObject((TruffleObject)arg0Value_)) {
                return this.foreignObject1Boundary(state, (TruffleObject)arg0Value_);
            }
        }
        if ((state & 0x1000) != 0 && !JSRuntime.isLazyString((Object)arg0Value) && !JSGuards.isTruffleObject((Object)arg0Value)) {
            return FlattenNode.doOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObject1Boundary(int state, TruffleObject arg0Value_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_);
            Object object = FlattenNode.doForeignObject(arg0Value_, foreignObject1_interop__);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            int arg0Value_2;
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_3 = (JSLazyString)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = FlattenNode.doLazyString(arg0Value_3);
                return string;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString((Object)arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_4 = JSTypesGen.asImplicitString((int)stringCast0, (Object)arg0Value);
                state |= stringCast0 << 13;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = FlattenNode.doString(arg0Value_4);
                return string;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_5 = (Symbol)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object arg0Value_4 = FlattenNode.doSymbol(arg0Value_5);
                return arg0Value_4;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_6 = (BigInt)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Object arg0Value_4 = FlattenNode.doBigInt(arg0Value_6);
                return arg0Value_4;
            }
            if (arg0Value instanceof Boolean) {
                arg0Value_2 = ((Boolean)arg0Value).booleanValue();
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_4 = FlattenNode.doBoolean(arg0Value_2 != 0);
                return arg0Value_4;
            }
            if (arg0Value instanceof Integer) {
                arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Integer arg0Value_4 = FlattenNode.doInt(arg0Value_2);
                return arg0Value_4;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_7 = (SafeInteger)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                SafeInteger arg0Value_4 = FlattenNode.doSafeInteger(arg0Value_7);
                return arg0Value_4;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_8 = (Long)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Long l = FlattenNode.doLong(arg0Value_8);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble((Object)arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_9 = JSTypesGen.asImplicitDouble((int)doubleCast0, (Object)arg0Value);
                state |= doubleCast0 << 17;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Double d = FlattenNode.doDouble(arg0Value_9);
                return d;
            }
            if (JSTypes.isDynamicObject((Object)arg0Value) && JSObject.isJSObject((Object)(arg0Value_ = (DynamicObject)arg0Value))) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Object arg0Value_9 = FlattenNode.doJSObject(arg0Value_);
                return arg0Value_9;
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_10 = (TruffleObject)arg0Value;
                if (exclude == 0) {
                    int count11_ = 0;
                    ForeignObject0Data s11_ = this.foreignObject0_cache;
                    if ((state & 0x400) != 0) {
                        while (!(s11_ == null || s11_.interop_.accepts((Object)arg0Value_10) && JSRuntime.isForeignObject((TruffleObject)arg0Value_10))) {
                            s11_ = s11_.next_;
                            ++count11_;
                        }
                    }
                    if (s11_ == null && JSRuntime.isForeignObject((TruffleObject)arg0Value_10) && count11_ < 3) {
                        s11_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                        s11_.interop_ = s11_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create((Object)arg0Value_10));
                        this.foreignObject0_cache = s11_;
                        this.state_ = state |= 0x400;
                    }
                    if (s11_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = FlattenNode.doForeignObject(arg0Value_10, s11_.interop_);
                        return object;
                    }
                }
                InteropLibrary foreignObject1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSRuntime.isForeignObject((TruffleObject)arg0Value_10)) {
                        foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_10);
                        this.exclude_ = exclude |= 1;
                        this.foreignObject0_cache = null;
                        state &= 0xFFFFFBFF;
                        this.state_ = state |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        Object object = FlattenNode.doForeignObject(arg0Value_10, foreignObject1_interop__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            if (!JSRuntime.isLazyString((Object)arg0Value) && !JSGuards.isTruffleObject((Object)arg0Value)) {
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                Object object = FlattenNode.doOther(arg0Value);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ForeignObject0Data s11_;
        int state = this.state_;
        if ((state & 0x1FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFF & (state & 0x1FFF) - 1) == 0 && ((s11_ = this.foreignObject0_cache) == null || s11_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<InteropLibrary>> cached;
        Object[] data = new Object[14];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doLazyString";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<InteropLibrary>>();
            ForeignObject0Data s11_ = this.foreignObject0_cache;
            while (s11_ != null) {
                cached.add(Arrays.asList(s11_.interop_));
                s11_ = s11_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList((InteropLibrary)INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static FlattenNode create() {
        return new FlattenNodeGen();
    }

    @GeneratedBy(value=FlattenNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

