/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.serialization;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.serialization.ArrayBufferViewTag;
import com.oracle.truffle.trufflenode.serialization.ErrorTag;
import com.oracle.truffle.trufflenode.serialization.SerializationTag;
import com.oracle.truffle.trufflenode.serialization.Serializer;
import com.oracle.truffle.trufflenode.threading.JavaMessagePortData;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingManager;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Deserializer {
    private final long delegate;
    private final ByteBuffer buffer;
    private int version;
    private int nextId;
    private Map<Integer, Object> objectMap = new HashMap<Integer, Object>();
    private Map<Integer, DynamicObject> transferMap = new HashMap<Integer, DynamicObject>();
    private JavaMessagePortData messagePortCache = null;

    public Deserializer(long delegate, ByteBuffer buffer) {
        this.delegate = delegate;
        this.buffer = buffer.order(ByteOrder.nativeOrder());
    }

    public void readHeader() {
        if (this.buffer.get() == -1) {
            this.version = this.buffer.get();
            if (this.version > 13) {
                throw Errors.createError((String)"Unable to deserialize cloned data due to invalid or unsupported version.");
            }
        }
    }

    public Object readValue(JSContext context) {
        SerializationTag tag = this.readTag();
        return this.readValue(context, tag);
    }

    private Object readValue(JSContext context, SerializationTag tag) {
        switch (tag) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case UNDEFINED: {
                return Undefined.instance;
            }
            case NULL: {
                return Null.instance;
            }
            case INT32: {
                return this.readInt();
            }
            case UINT32: {
                return this.readVarInt();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case BIG_INT: {
                return this.readBigInt();
            }
            case ONE_BYTE_STRING: {
                return this.readOneByteString();
            }
            case TWO_BYTE_STRING: {
                return this.readTwoByteString();
            }
            case UTF8_STRING: {
                return this.readUTF8String();
            }
            case DATE: {
                return this.readDate(context);
            }
            case TRUE_OBJECT: {
                return this.assignId(JSBoolean.create((JSContext)context, (boolean)true));
            }
            case FALSE_OBJECT: {
                return this.assignId(JSBoolean.create((JSContext)context, (boolean)false));
            }
            case NUMBER_OBJECT: {
                return this.readJSNumber(context);
            }
            case BIG_INT_OBJECT: {
                return this.readJSBigInt(context);
            }
            case STRING_OBJECT: {
                return this.readJSString(context);
            }
            case REGEXP: {
                return this.readJSRegExp(context);
            }
            case ARRAY_BUFFER: {
                return this.readJSArrayBuffer(context);
            }
            case ARRAY_BUFFER_TRANSFER: {
                return this.readTransferredJSArrayBuffer(context);
            }
            case SHARED_ARRAY_BUFFER: {
                return this.readSharedArrayBuffer(context);
            }
            case BEGIN_JS_OBJECT: {
                return this.readJSObject(context);
            }
            case BEGIN_JS_MAP: {
                return this.readJSMap(context);
            }
            case BEGIN_JS_SET: {
                return this.readJSSet(context);
            }
            case BEGIN_DENSE_JS_ARRAY: {
                return this.readDenseArray(context);
            }
            case BEGIN_SPARSE_JS_ARRAY: {
                return this.readSparseArray(context);
            }
            case OBJECT_REFERENCE: {
                return this.readObjectReference();
            }
            case HOST_OBJECT: {
                return this.readHostObject();
            }
            case ERROR: {
                return this.readJSError(context);
            }
            case SHARED_JAVA_OBJECT: {
                return this.readSharedJavaObject(context);
            }
        }
        throw Errors.createError((String)("Deserialization of a value tagged " + (Object)((Object)tag)));
    }

    private SerializationTag readTag() {
        SerializationTag tag;
        while ((tag = SerializationTag.fromTag(this.buffer.get())) == SerializationTag.PADDING) {
        }
        return tag;
    }

    private SerializationTag peekTag() {
        return this.buffer.hasRemaining() ? SerializationTag.fromTag(this.buffer.get(this.buffer.position())) : null;
    }

    private ArrayBufferViewTag readArrayBufferViewTag() {
        return ArrayBufferViewTag.fromTag(this.buffer.get());
    }

    private ErrorTag readErrorTag() {
        return ErrorTag.fromTag(this.buffer.get());
    }

    private int readInt() {
        long zigzag = this.readVarLong();
        long value = zigzag >> 1 ^ -(zigzag & 1L);
        return (int)value;
    }

    public int readVarInt() {
        return (int)this.readVarLong();
    }

    public long readVarLong() {
        byte b;
        long value = 0L;
        int shift = 0;
        do {
            b = this.buffer.get();
            value |= ((long)b & 0x7FL) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    private String readString() {
        SerializationTag tag = this.readTag();
        switch (tag) {
            case ONE_BYTE_STRING: {
                return this.readOneByteString();
            }
            case TWO_BYTE_STRING: {
                return this.readTwoByteString();
            }
            case UTF8_STRING: {
                return this.readUTF8String();
            }
        }
        throw Errors.shouldNotReachHere();
    }

    private BigInt readBigInt() {
        int bitField = this.readVarInt();
        boolean negative = (bitField & 1) != 0;
        bitField >>= 1;
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < bitField; ++i) {
            byte b = this.buffer.get();
            for (int bit = 8 * i; bit < 8 * (i + 1); ++bit) {
                if ((b & 1) != 0) {
                    bigInteger = bigInteger.setBit(bit);
                }
                b = (byte)(b >>> 1);
            }
        }
        if (negative) {
            bigInteger = bigInteger.negate();
        }
        return new BigInt(bigInteger);
    }

    private String readOneByteString() {
        int charCount = this.readVarInt();
        char[] chars = new char[charCount];
        for (int i = 0; i < charCount; ++i) {
            byte b = this.buffer.get();
            chars[i] = (char)(b & 0xFF);
        }
        return new String(chars);
    }

    private String readTwoByteString() {
        return this.readString(Serializer.NATIVE_UTF16_ENCODING);
    }

    private String readUTF8String() {
        return this.readString("UTF-8");
    }

    private String readString(String encoding) {
        int byteCount = this.readVarInt();
        byte[] bytes = new byte[byteCount];
        this.buffer.get(bytes);
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw Errors.shouldNotReachHere();
        }
    }

    private DynamicObject readDate(JSContext context) {
        double millis = this.readDouble();
        return this.assignId(JSDate.create((JSContext)context, (double)millis));
    }

    private DynamicObject readJSNumber(JSContext context) {
        double value = this.readDouble();
        return this.assignId(JSNumber.create((JSContext)context, (Number)value));
    }

    private DynamicObject readJSBigInt(JSContext context) {
        BigInt value = this.readBigInt();
        return this.assignId(JSBigInt.create((JSContext)context, (BigInt)value));
    }

    private DynamicObject readJSString(JSContext context) {
        String value = this.readString();
        return this.assignId(JSString.create((JSContext)context, (CharSequence)value));
    }

    private Object readJSRegExp(JSContext context) {
        String pattern = this.readString();
        int flags = this.readVarInt();
        return this.assignId(GraalJSAccess.regexpCreate(context, pattern, flags));
    }

    private DynamicObject readJSArrayBuffer(JSContext context) {
        int byteLength = this.readVarInt();
        DynamicObject arrayBuffer = JSArrayBuffer.createDirectArrayBuffer((JSContext)context, (int)byteLength);
        ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer((DynamicObject)arrayBuffer);
        for (int i = 0; i < byteLength; ++i) {
            byteBuffer.put(i, this.buffer.get());
        }
        this.assignId(arrayBuffer);
        return this.peekTag() == SerializationTag.ARRAY_BUFFER_VIEW ? this.readJSArrayBufferView(context, arrayBuffer) : arrayBuffer;
    }

    private DynamicObject readJSObject(JSContext context) {
        DynamicObject object = JSUserObject.create((JSContext)context);
        this.assignId(object);
        int read = this.readJSObjectProperties(context, object, SerializationTag.END_JS_OBJECT);
        int expected = this.readVarInt();
        if (read != expected) {
            throw Errors.createError((String)"unexpected number of properties");
        }
        return object;
    }

    private int readJSObjectProperties(JSContext context, DynamicObject object, SerializationTag endTag) {
        SerializationTag tag;
        int count = 0;
        while ((tag = this.readTag()) != endTag) {
            ++count;
            Object key = this.readValue(context, tag);
            Object value = this.readValue(context);
            JSObject.defineOwnProperty((DynamicObject)object, (Object)JSRuntime.toPropertyKey((Object)key), (PropertyDescriptor)PropertyDescriptor.createDataDefault((Object)value));
        }
        return count;
    }

    private DynamicObject readJSMap(JSContext context) {
        SerializationTag tag;
        DynamicObject object = JSMap.create((JSContext)context);
        JSHashMap internalMap = JSMap.getInternalMap((DynamicObject)object);
        this.assignId(object);
        int read = 0;
        while ((tag = this.readTag()) != SerializationTag.END_JS_MAP) {
            ++read;
            Object key = this.readValue(context, tag);
            Object value = this.readValue(context);
            internalMap.put(key, value);
        }
        int expected = this.readVarInt();
        if (2 * read != expected) {
            throw Errors.createError((String)"unexpected number of entries");
        }
        return object;
    }

    private DynamicObject readJSSet(JSContext context) {
        SerializationTag tag;
        DynamicObject object = JSSet.create((JSContext)context);
        JSHashMap internalMap = JSSet.getInternalSet((DynamicObject)object);
        this.assignId(object);
        int read = 0;
        while ((tag = this.readTag()) != SerializationTag.END_JS_SET) {
            ++read;
            Object value = this.readValue(context, tag);
            internalMap.put(value, value);
        }
        int expected = this.readVarInt();
        if (read != expected) {
            throw Errors.createError((String)"unexpected number of values");
        }
        return object;
    }

    private DynamicObject readDenseArray(JSContext context) {
        int expected;
        int length = this.readVarInt();
        Object[] elements = new Object[length];
        DynamicObject array = JSArray.createConstantObjectArray((JSContext)context, (Object[])elements);
        this.assignId(array);
        ArrayList<Integer> holes = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            SerializationTag tag = this.readTag();
            if (tag == SerializationTag.THE_HOLE) {
                holes.add(i);
                continue;
            }
            elements[i] = this.readValue(context, tag);
        }
        Iterator i = holes.iterator();
        while (i.hasNext()) {
            int hole = (Integer)i.next();
            JSObject.delete((DynamicObject)array, (long)hole);
        }
        int read = this.readJSObjectProperties(context, array, SerializationTag.END_DENSE_JS_ARRAY);
        if (read != (expected = this.readVarInt())) {
            throw Errors.createError((String)"unexpected number of properties");
        }
        int length2 = this.readVarInt();
        if (length != length2) {
            throw Errors.createError((String)"length ambiguity");
        }
        return array;
    }

    private DynamicObject readSparseArray(JSContext context) {
        long length = this.readVarLong();
        DynamicObject array = JSArray.createSparseArray((JSContext)context, (long)length);
        this.assignId(array);
        int read = this.readJSObjectProperties(context, array, SerializationTag.END_SPARSE_JS_ARRAY);
        int expected = this.readVarInt();
        if (read != expected) {
            throw Errors.createError((String)"unexpected number of properties");
        }
        long length2 = this.readVarLong();
        if (length != length2) {
            throw Errors.createError((String)"length ambiguity");
        }
        return array;
    }

    private DynamicObject readJSArrayBufferView(JSContext context, DynamicObject arrayBuffer) {
        DynamicObject view;
        assert (JSArrayBuffer.isJSDirectOrSharedArrayBuffer((DynamicObject)arrayBuffer));
        SerializationTag arrayBufferViewTag = this.readTag();
        assert (arrayBufferViewTag == SerializationTag.ARRAY_BUFFER_VIEW);
        ArrayBufferViewTag tag = this.readArrayBufferViewTag();
        int offset = this.readVarInt();
        int byteLength = this.readVarInt();
        if (tag == ArrayBufferViewTag.DATA_VIEW) {
            view = JSDataView.createDataView((JSContext)context, (DynamicObject)arrayBuffer, (int)offset, (int)byteLength);
        } else {
            TypedArrayFactory factory = tag.getFactory();
            TypedArray array = factory.createArrayType(true, offset != 0);
            int length = byteLength / factory.getBytesPerElement();
            view = JSArrayBufferView.createArrayBufferView((JSContext)context, (DynamicObject)arrayBuffer, (TypedArray)array, (int)offset, (int)length);
        }
        return this.assignId(view);
    }

    private Object readObjectReference() {
        int id = this.readVarInt();
        Object object = this.objectMap.get(id);
        if (object == null) {
            throw Errors.createError((String)"invalid object reference");
        }
        return object;
    }

    private Object readJSError(JSContext context) {
        ErrorTag tag;
        JSErrorType errorType = JSErrorType.Error;
        Object message = Undefined.instance;
        Object stack = Undefined.instance;
        boolean done = false;
        block10: while (!done && (tag = this.readErrorTag()) != null) {
            switch (tag) {
                case EVAL_ERROR: {
                    errorType = JSErrorType.EvalError;
                    continue block10;
                }
                case RANGE_ERROR: {
                    errorType = JSErrorType.RangeError;
                    continue block10;
                }
                case REFERENCE_ERROR: {
                    errorType = JSErrorType.ReferenceError;
                    continue block10;
                }
                case SYNTAX_ERROR: {
                    errorType = JSErrorType.SyntaxError;
                    continue block10;
                }
                case TYPE_ERROR: {
                    errorType = JSErrorType.TypeError;
                    continue block10;
                }
                case URI_ERROR: {
                    errorType = JSErrorType.URIError;
                    continue block10;
                }
                case MESSAGE: {
                    message = this.readString();
                    continue block10;
                }
                case STACK: {
                    stack = this.readString();
                    continue block10;
                }
            }
            assert (tag == ErrorTag.END);
            done = true;
        }
        DynamicObject error = JSError.create((JSErrorType)errorType, (JSRealm)context.getRealm(), (Object)message);
        this.assignId(error);
        JSObject.set((DynamicObject)error, (Object)"stack", (Object)stack);
        return error;
    }

    private Object readHostObject() {
        return this.assignId(NativeAccess.readHostObject(this.delegate));
    }

    public void transferArrayBuffer(int id, DynamicObject arrayBuffer) {
        this.transferMap.put(id, arrayBuffer);
    }

    public DynamicObject readTransferredJSArrayBuffer(JSContext context) {
        int id = this.readVarInt();
        DynamicObject arrayBuffer = this.transferMap.get(id);
        if (arrayBuffer == null) {
            throw Errors.createError((String)("Invalid transfer id " + id));
        }
        this.assignId(arrayBuffer);
        return this.peekTag() == SerializationTag.ARRAY_BUFFER_VIEW ? this.readJSArrayBufferView(context, arrayBuffer) : arrayBuffer;
    }

    public Object readSharedArrayBuffer(JSContext context) {
        int id = this.readVarInt();
        Object sharedArrayBuffer = NativeAccess.getSharedArrayBufferFromId(this.delegate, id);
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)sharedArrayBuffer));
        this.assignId(sharedArrayBuffer);
        return this.peekTag() == SerializationTag.ARRAY_BUFFER_VIEW ? this.readJSArrayBufferView(context, (DynamicObject)sharedArrayBuffer) : sharedArrayBuffer;
    }

    public Object readSharedJavaObject(JSContext context) {
        long messagePortPointer = this.readVarLong();
        if (this.messagePortCache == null || this.messagePortCache.getMessagePortDataPointer() != messagePortPointer) {
            this.messagePortCache = SharedMemMessagingManager.getMessagePortDataFor(messagePortPointer);
        }
        Object element = this.messagePortCache.removeJavaRef();
        assert (element != null);
        return context.getRealm().getEnv().asGuestValue(element);
    }

    public int readBytes(int length) {
        int position = this.buffer.position();
        BufferUtil.asBaseBuffer((Buffer)this.buffer).position(position + length);
        return position;
    }

    private <T> T assignId(T object) {
        this.objectMap.put(this.nextId++, object);
        return object;
    }

    public int getWireFormatVersion() {
        return this.version;
    }
}

