/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.svm;

import org.graalvm.visualvm.application.jvm.MonitoredData;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;

public class SVMMonitoredDataImpl
extends MonitoredData {
    private static final String ProcessCPUTime_COUNTER_NAME = "com.oracle.svm.processCPUTime";

    SVMMonitoredDataImpl(JvmstatModel monitoredVm, JvmJvmstatModel jvmstatModel) {
        this.loadedClasses = jvmstatModel.getLoadedClasses();
        this.sharedLoadedClasses = jvmstatModel.getSharedLoadedClasses();
        this.sharedUnloadedClasses = jvmstatModel.getSharedUnloadedClasses();
        this.unloadedClasses = jvmstatModel.getUnloadedClasses();
        this.threadsDaemon = jvmstatModel.getThreadsDaemon();
        this.threadsLive = jvmstatModel.getThreadsLive();
        this.threadsLivePeak = jvmstatModel.getThreadsLivePeak();
        this.threadsStarted = jvmstatModel.getThreadsStarted();
        this.applicationTime = 1000L * jvmstatModel.getApplicationTime() / jvmstatModel.getOsFrequency();
        this.upTime = 1000L * jvmstatModel.getUpTime() / jvmstatModel.getOsFrequency();
        this.genCapacity = jvmstatModel.getGenCapacity();
        this.genUsed = jvmstatModel.getGenUsed();
        this.genMaxCapacity = jvmstatModel.getGenMaxCapacity();
        MonitoredValue cpuTimeVal = monitoredVm.findMonitoredValueByName(ProcessCPUTime_COUNTER_NAME);
        if (cpuTimeVal != null) {
            this.processCpuTime = (Long)cpuTimeVal.getValue();
        }
    }
}

