/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSNumericToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ConstructorBuiltins.class)
public final class ConstructorBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=ConstructorBuiltins.PromiseConstructorNode.class)
    public static final class PromiseConstructorNodeGen
    extends ConstructorBuiltins.PromiseConstructorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private PromiseConstructorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && this.isCallable.executeBoolean(arguments1Value_)) {
                    return this.construct(frameValue, arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !this.isCallable.executeBoolean(arguments1Value_)) {
                    return this.notCallable(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (this.isCallable.executeBoolean(arguments1Value)) {
                    this.state_ = state |= 1;
                    return this.construct(frameValue, arguments0Value_, arguments1Value);
                }
                if (!this.isCallable.executeBoolean(arguments1Value)) {
                    this.state_ = state |= 2;
                    return this.notCallable(arguments0Value_, arguments1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "construct";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "notCallable";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.PromiseConstructorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new PromiseConstructorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructSymbolNode.class)
    public static final class ConstructSymbolNodeGen
    extends ConstructorBuiltins.ConstructSymbolNode
    implements Introspection.Provider {
        private ConstructSymbolNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return ConstructorBuiltins.ConstructSymbolNode.construct();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "construct";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructSymbolNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ConstructSymbolNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallSymbolNode.class)
    public static final class CallSymbolNodeGen
    extends ConstructorBuiltins.CallSymbolNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private CallSymbolNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.callSymbol(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "callSymbol";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallSymbolNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallSymbolNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructWeakMapNode.class)
    public static final class ConstructWeakMapNodeGen
    extends ConstructorBuiltins.ConstructWeakMapNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructWeakMapNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructMap(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructMap(arguments0Value_, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructMap";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructWeakMapNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructWeakMapNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructWeakSetNode.class)
    public static final class ConstructWeakSetNodeGen
    extends ConstructorBuiltins.ConstructWeakSetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructWeakSetNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructSet(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructSet(arguments0Value_, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructSet";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructWeakSetNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructWeakSetNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructSetNode.class)
    public static final class ConstructSetNodeGen
    extends ConstructorBuiltins.ConstructSetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructSetNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructSet(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructSet(arguments0Value_, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructSet";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructSetNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructSetNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructMapNode.class)
    public static final class ConstructMapNodeGen
    extends ConstructorBuiltins.ConstructMapNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructMapNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructMap(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructMap(arguments0Value_, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructMap";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructMapNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructMapNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructJavaImporterNode.class)
    public static final class ConstructJavaImporterNodeGen
    extends ConstructorBuiltins.ConstructJavaImporterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructJavaImporterNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                return this.constructJavaImporter(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[])arguments0Value;
                this.state_ = state |= 1;
                return this.constructJavaImporter(arguments0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructJavaImporter";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructJavaImporterNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ConstructJavaImporterNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructJSProxyNode.class)
    public static final class ConstructJSProxyNodeGen
    extends ConstructorBuiltins.ConstructJSProxyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructJSProxyNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public DynamicObject execute(DynamicObject arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (state != 0) {
                return this.constructJSProxy(arguments0Value, arguments1Value, arguments2Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value, arguments1Value, arguments2Value);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructJSProxy(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructJSProxy(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructJSProxy";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructJSProxyNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructJSProxyNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructJSAdapterNode.class)
    public static final class ConstructJSAdapterNodeGen
    extends ConstructorBuiltins.ConstructJSAdapterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructJSAdapterNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments1Value__;
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && JSGuards.isJSObject(arguments0Value__) && JSGuards.isUndefined(arguments1Value_) && JSGuards.isUndefined(arguments2Value_)) {
                        return this.constructJSAdapter(arguments0Value__, arguments1Value_, arguments2Value_);
                    }
                    if ((state & 2) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                        arguments1Value__ = (DynamicObject)arguments1Value_;
                        if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSObject(arguments1Value__) && JSGuards.isUndefined(arguments2Value_)) {
                            return this.constructJSAdapter(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state & 4) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSTypes.isDynamicObject(arguments2Value_)) {
                        DynamicObject arguments2Value__ = (DynamicObject)arguments2Value_;
                        if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSObject(arguments1Value__) && JSGuards.isJSObject(arguments2Value__)) {
                            return this.constructJSAdapter(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
            }
            if ((state & 8) != 0 && ConstructJSAdapterNodeGen.fallbackGuard_(arguments0Value_, arguments1Value_, arguments2Value_)) {
                return this.constructJSAdapter(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isUndefined(arguments1Value) && JSGuards.isUndefined(arguments2Value)) {
                    this.state_ = state |= 1;
                    return this.constructJSAdapter(arguments0Value_, arguments1Value, arguments2Value);
                }
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    arguments1Value_ = (DynamicObject)arguments1Value;
                    if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSObject(arguments1Value_) && JSGuards.isUndefined(arguments2Value)) {
                        this.state_ = state |= 2;
                        return this.constructJSAdapter(arguments0Value_, arguments1Value_, arguments2Value);
                    }
                }
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    arguments1Value_ = (DynamicObject)arguments1Value;
                    if (JSTypes.isDynamicObject(arguments2Value)) {
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSObject(arguments1Value_) && JSGuards.isJSObject(arguments2Value_)) {
                            this.state_ = state |= 4;
                            return this.constructJSAdapter(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                }
            }
            this.state_ = state |= 8;
            return this.constructJSAdapter(arguments0Value, arguments1Value, arguments2Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructJSAdapter";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructJSAdapter";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "constructJSAdapter";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "constructJSAdapter";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        private static boolean fallbackGuard_(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isUndefined(arguments1Value) && JSGuards.isUndefined(arguments2Value)) {
                    return false;
                }
                if (JSTypes.isDynamicObject(arguments1Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value) && JSGuards.isJSObject(arguments1Value_ = (DynamicObject)arguments1Value) && JSGuards.isUndefined(arguments2Value)) {
                    return false;
                }
                if (JSTypes.isDynamicObject(arguments1Value) && JSTypes.isDynamicObject(arguments2Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value) && JSGuards.isJSObject(arguments1Value_ = (DynamicObject)arguments1Value) && JSGuards.isJSObject(arguments2Value_ = (DynamicObject)arguments2Value)) {
                    return false;
                }
            }
            return true;
        }

        public static ConstructorBuiltins.ConstructJSAdapterNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ConstructJSAdapterNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallRequiresNewNode.class)
    public static final class CallRequiresNewNodeGen
    extends ConstructorBuiltins.CallRequiresNewNode
    implements Introspection.Provider {
        private CallRequiresNewNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.call();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "call";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallRequiresNewNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallRequiresNewNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructDataViewNode.class)
    public static final class ConstructDataViewNodeGen
    extends ConstructorBuiltins.ConstructDataViewNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @Node.Child
        private JavaScriptNode arguments3_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ConstructDataViewData constructDataView_cache;

        private ConstructDataViewNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                ConstructDataViewData s1_ = this.constructDataView_cache;
                if (s1_ != null) {
                    return this.constructDataView(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, s1_.errorBranch_, s1_.arrayBufferCondition_, s1_.byteLengthCondition_, s1_.offsetToIndexNode_, s1_.lengthToIndexNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    ConstructDataViewData s1_ = (ConstructDataViewData)super.insert((Node)new ConstructDataViewData());
                    s1_.errorBranch_ = BranchProfile.create();
                    s1_.arrayBufferCondition_ = ConditionProfile.createBinaryProfile();
                    s1_.byteLengthCondition_ = ConditionProfile.createBinaryProfile();
                    s1_.offsetToIndexNode_ = s1_.insertAccessor(JSToIndexNode.create());
                    s1_.lengthToIndexNode_ = s1_.insertAccessor(JSToIndexNode.create());
                    this.constructDataView_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.constructDataView(arguments0Value_, arguments1Value, arguments2Value, arguments3Value, s1_.errorBranch_, s1_.arrayBufferCondition_, s1_.byteLengthCondition_, s1_.offsetToIndexNode_, s1_.lengthToIndexNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructDataView";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                ConstructDataViewData s1_ = this.constructDataView_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.errorBranch_, s1_.arrayBufferCondition_, s1_.byteLengthCondition_, s1_.offsetToIndexNode_, s1_.lengthToIndexNode_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructDataViewNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructDataViewNodeGen(context, builtin, isNewTargetCase, arguments);
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructDataViewNode.class)
        private static final class ConstructDataViewData
        extends Node {
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile arrayBufferCondition_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile byteLengthCondition_;
            @Node.Child
            JSToIndexNode offsetToIndexNode_;
            @Node.Child
            JSToIndexNode lengthToIndexNode_;

            ConstructDataViewData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructAggregateErrorNode.class)
    public static final class ConstructAggregateErrorNodeGen
    extends ConstructorBuiltins.ConstructAggregateErrorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private ConstructErrorData constructError_cache;

        private ConstructAggregateErrorNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                ConstructErrorData s1_ = this.constructError_cache;
                if (s1_ != null) {
                    return this.constructError(frameValue, arguments0Value__, arguments1Value_, arguments2Value_, s1_.toStringNode_, s1_.getIteratorMethodNode_, s1_.iteratorCallNode_, s1_.isObjectNode_, s1_.iteratorStepNode_, s1_.getIteratorValueNode_, s1_.getNextMethodNode_, s1_.growProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    ConstructErrorData s1_ = (ConstructErrorData)super.insert((Node)new ConstructErrorData());
                    s1_.toStringNode_ = s1_.insertAccessor(JSToStringNode.create());
                    s1_.getIteratorMethodNode_ = s1_.insertAccessor(this.createGetIteratorMethod());
                    s1_.iteratorCallNode_ = s1_.insertAccessor(JSFunctionCallNode.createCall());
                    s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                    s1_.iteratorStepNode_ = s1_.insertAccessor(IteratorStepNode.create(this.getContext()));
                    s1_.getIteratorValueNode_ = s1_.insertAccessor(IteratorValueNode.create(this.getContext()));
                    s1_.getNextMethodNode_ = s1_.insertAccessor(PropertyGetNode.create("next", this.getContext()));
                    s1_.growProfile_ = BranchProfile.create();
                    this.constructError_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.constructError(frameValue, arguments0Value_, arguments1Value, arguments2Value, s1_.toStringNode_, s1_.getIteratorMethodNode_, s1_.iteratorCallNode_, s1_.isObjectNode_, s1_.iteratorStepNode_, s1_.getIteratorValueNode_, s1_.getNextMethodNode_, s1_.growProfile_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructError";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                ConstructErrorData s1_ = this.constructError_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.toStringNode_, s1_.getIteratorMethodNode_, s1_.iteratorCallNode_, s1_.isObjectNode_, s1_.iteratorStepNode_, s1_.getIteratorValueNode_, s1_.getNextMethodNode_, s1_.growProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructAggregateErrorNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructAggregateErrorNodeGen(context, builtin, isNewTargetCase, arguments);
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructAggregateErrorNode.class)
        private static final class ConstructErrorData
        extends Node {
            @Node.Child
            JSToStringNode toStringNode_;
            @Node.Child
            GetMethodNode getIteratorMethodNode_;
            @Node.Child
            JSFunctionCallNode iteratorCallNode_;
            @Node.Child
            IsJSObjectNode isObjectNode_;
            @Node.Child
            IteratorStepNode iteratorStepNode_;
            @Node.Child
            IteratorValueNode getIteratorValueNode_;
            @Node.Child
            PropertyGetNode getNextMethodNode_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;

            ConstructErrorData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructErrorNode.class)
    public static final class ConstructErrorNodeGen
    extends ConstructorBuiltins.ConstructErrorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToStringNode constructError1_toStringNode_;

        private ConstructErrorNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && JSTypesGen.isImplicitString((state & 0x3C) >>> 2, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state & 0x3C) >>> 2, arguments1Value_);
                    return this.constructError(frameValue, arguments0Value__, arguments1Value__);
                }
                if ((state & 2) != 0) {
                    return this.constructError(frameValue, arguments0Value__, arguments1Value_, this.constructError1_toStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        state |= stringCast1 << 2;
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.constructError(frameValue, arguments0Value_, arguments1Value_);
                        return dynamicObject;
                    }
                    this.constructError1_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.constructError(frameValue, arguments0Value_, arguments1Value, this.constructError1_toStringNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructError";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructError";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.constructError1_toStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructErrorNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructErrorNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructArrayBufferNode.class)
    public static final class ConstructArrayBufferNodeGen
    extends ConstructorBuiltins.ConstructArrayBufferNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToIndexNode constructFromLength_toIndexNode_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile constructFromHostByteBuffer_errorBranch_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile constructFromHostByteBuffer_isDirect_;

        private ConstructArrayBufferNodeGen(JSContext context, JSBuiltin builtin, boolean useShared, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, useShared, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && !JSGuards.isByteBuffer(arguments1Value_) && !this.isHostByteBuffer(arguments1Value_)) {
                    return this.constructFromLength(arguments0Value__, arguments1Value_, this.constructFromLength_toIndexNode_);
                }
                if ((state & 2) != 0 && this.isHostByteBuffer(arguments1Value_)) {
                    return this.constructFromHostByteBuffer(arguments0Value__, arguments1Value_, this.constructFromHostByteBuffer_errorBranch_, this.constructFromHostByteBuffer_isDirect_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (!JSGuards.isByteBuffer(arguments1Value) && !this.isHostByteBuffer(arguments1Value)) {
                        this.constructFromLength_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.constructFromLength(arguments0Value_, arguments1Value, this.constructFromLength_toIndexNode_);
                        return dynamicObject;
                    }
                    if (this.isHostByteBuffer(arguments1Value)) {
                        this.constructFromHostByteBuffer_errorBranch_ = BranchProfile.create();
                        this.constructFromHostByteBuffer_isDirect_ = ConditionProfile.createBinaryProfile();
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.constructFromHostByteBuffer(arguments0Value_, arguments1Value, this.constructFromHostByteBuffer_errorBranch_, this.constructFromHostByteBuffer_isDirect_);
                        return dynamicObject;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSToIndexNode>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructFromLength";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSToIndexNode>>();
                cached.add(Arrays.asList(this.constructFromLength_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "constructFromHostByteBuffer";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.constructFromHostByteBuffer_errorBranch_, this.constructFromHostByteBuffer_isDirect_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructArrayBufferNode create(JSContext context, JSBuiltin builtin, boolean useShared, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructArrayBufferNodeGen(context, builtin, useShared, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallTypedArrayNode.class)
    public static final class CallTypedArrayNodeGen
    extends ConstructorBuiltins.CallTypedArrayNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private CallTypedArrayNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                return this.callTypedArray(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[])arguments0Value;
                this.state_ = state |= 1;
                return this.callTypedArray(arguments0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "callTypedArray";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallTypedArrayNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallTypedArrayNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CreateDynamicFunctionNode.class)
    static final class CreateDynamicFunctionNodeGen
    extends ConstructorBuiltins.CreateDynamicFunctionNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private ConstructorBuiltins.LRUCache<ConstructorBuiltins.CreateDynamicFunctionNode.CachedSourceKey, ScriptNode> uncached_cache_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile uncached_cacheHit_;

        private CreateDynamicFunctionNodeGen(JSContext context, boolean generatorFunction, boolean asyncFunction) {
            super(context, generatorFunction, asyncFunction);
        }

        @Override
        protected DynamicObject executeFunction(String arg0Value, String arg1Value, String arg2Value) {
            int state = this.state_;
            if ((state & 3) != 0) {
                CachedData s1_;
                if ((state & 1) != 0 && (s1_ = this.cached_cache) != null && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedParamList_, arg0Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedBody_, arg1Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedSourceName_, arg2Value)) {
                    return this.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedParamList_, s1_.cachedBody_, s1_.cachedSourceName_, s1_.parsedFunction_);
                }
                if ((state & 2) != 0) {
                    return this.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_cache_, this.uncached_cacheHit_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(String arg0Value, String arg1Value, String arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    String cachedSourceName__;
                    String cachedBody__;
                    String cachedParamList__;
                    CachedData s1_ = this.cached_cache;
                    boolean Cached_duplicateFound_ = false;
                    if ((state & 1) != 0 && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedParamList_, arg0Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedBody_, arg1Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(s1_.cachedSourceName_, arg2Value)) {
                        Cached_duplicateFound_ = true;
                    }
                    if (!Cached_duplicateFound_ && ConstructorBuiltins.CreateDynamicFunctionNode.equals(cachedParamList__ = arg0Value, arg0Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(cachedBody__ = arg1Value, arg1Value) && ConstructorBuiltins.CreateDynamicFunctionNode.equals(cachedSourceName__ = arg2Value, arg2Value) && (state & 1) == 0) {
                        s1_ = new CachedData();
                        s1_.cachedParamList_ = cachedParamList__;
                        s1_.cachedBody_ = cachedBody__;
                        s1_.cachedSourceName_ = cachedSourceName__;
                        s1_.parsedFunction_ = this.parseFunction(arg0Value, arg1Value, arg2Value);
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                        Cached_duplicateFound_ = true;
                    }
                    if (Cached_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedParamList_, s1_.cachedBody_, s1_.cachedSourceName_, s1_.parsedFunction_);
                        return dynamicObject;
                    }
                }
                this.uncached_cache_ = this.createCache();
                this.uncached_cacheHit_ = ConditionProfile.createCountingProfile();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doUncached(arg0Value, arg1Value, arg2Value, this.uncached_cache_, this.uncached_cacheHit_);
                return dynamicObject;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 3 & (state & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedParamList_, s1_.cachedBody_, s1_.cachedSourceName_, s1_.parsedFunction_));
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doUncached";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.uncached_cache_, this.uncached_cacheHit_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CreateDynamicFunctionNode create(JSContext context, boolean generatorFunction, boolean asyncFunction) {
            return new CreateDynamicFunctionNodeGen(context, generatorFunction, asyncFunction);
        }

        @GeneratedBy(value=ConstructorBuiltins.CreateDynamicFunctionNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            String cachedParamList_;
            @CompilerDirectives.CompilationFinal
            String cachedBody_;
            @CompilerDirectives.CompilationFinal
            String cachedSourceName_;
            @CompilerDirectives.CompilationFinal
            ScriptNode parsedFunction_;

            CachedData() {
            }
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructFunctionNode.class)
    public static final class ConstructFunctionNodeGen
    extends ConstructorBuiltins.ConstructFunctionNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile hasArgsProfile_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile hasParamsProfile_;

        private ConstructFunctionNodeGen(JSContext context, JSBuiltin builtin, boolean generatorFunction, boolean asyncFunction, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, generatorFunction, asyncFunction, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    return this.constructFunction(arguments0Value__, arguments1Value__, this.hasArgsProfile_, this.hasParamsProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        this.hasArgsProfile_ = ConditionProfile.createBinaryProfile();
                        this.hasParamsProfile_ = ConditionProfile.createBinaryProfile();
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.constructFunction(arguments0Value_, arguments1Value_, this.hasArgsProfile_, this.hasParamsProfile_);
                        return dynamicObject;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructFunction";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
                cached.add(Arrays.asList(this.hasArgsProfile_, this.hasParamsProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructFunctionNode create(JSContext context, JSBuiltin builtin, boolean generatorFunction, boolean asyncFunction, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructFunctionNodeGen(context, builtin, generatorFunction, asyncFunction, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructBigIntNode.class)
    public static final class ConstructBigIntNodeGen
    extends ConstructorBuiltins.ConstructBigIntNode
    implements Introspection.Provider {
        private ConstructBigIntNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return ConstructorBuiltins.ConstructBigIntNode.construct();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "construct";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructBigIntNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ConstructBigIntNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallBigIntNode.class)
    public static final class CallBigIntNodeGen
    extends ConstructorBuiltins.CallBigIntNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSNumberToBigIntNode callBigInt_numberToBigIntNode_;
        @Node.Child
        private JSToBigIntNode callBigInt_toBigIntNode_;

        private CallBigIntNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object[] arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 2) != 0 && arguments0Value_ instanceof Object[] && (arguments0Value__ = (Object[])arguments0Value_).length > 0) {
                return this.callBigInt(arguments0Value__, this.callBigInt_numberToBigIntNode_, this.callBigInt_toBigIntNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            Object[] arguments0Value__;
            int state = this.state_;
            if ((state & 2) != 0) {
                this.execute(frameValue);
                return;
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Object[] && (arguments0Value__ = (Object[])arguments0Value_).length == 0) {
                this.callBigIntZero(arguments0Value__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arguments0Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[])arguments0Value;
                    if (arguments0Value_.length == 0) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        this.callBigIntZero(arguments0Value_);
                        Object var6_6 = null;
                        return var6_6;
                    }
                    if (arguments0Value_.length > 0) {
                        this.callBigInt_numberToBigIntNode_ = (JSNumberToBigIntNode)super.insert((Node)JSNumberToBigIntNode.create());
                        this.callBigInt_toBigIntNode_ = (JSToBigIntNode)super.insert((Node)JSToBigIntNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.callBigInt(arguments0Value_, this.callBigInt_numberToBigIntNode_, this.callBigInt_toBigIntNode_);
                        return object;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "callBigIntZero";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "callBigInt";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.callBigInt_numberToBigIntNode_, this.callBigInt_toBigIntNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallBigIntNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallBigIntNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructNumberNode.class)
    public static final class ConstructNumberNodeGen
    extends ConstructorBuiltins.ConstructNumberNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToNumericNode constructNumber_toNumericNode_;
        @Node.Child
        private JSNumericToNumberNode constructNumber_toNumberFromNumericNode_;

        private ConstructNumberNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    if ((state & 1) != 0 && arguments1Value__.length == 0) {
                        return this.constructNumberZero(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && arguments1Value__.length > 0) {
                        return this.constructNumber(arguments0Value__, arguments1Value__, this.constructNumber_toNumericNode_, this.constructNumber_toNumberFromNumericNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == 0) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructNumberZero(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (arguments1Value_.length > 0) {
                            this.constructNumber_toNumericNode_ = (JSToNumericNode)super.insert((Node)JSToNumericNode.create());
                            this.constructNumber_toNumberFromNumericNode_ = (JSNumericToNumberNode)super.insert((Node)JSNumericToNumberNode.create());
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructNumber(arguments0Value_, arguments1Value_, this.constructNumber_toNumericNode_, this.constructNumber_toNumberFromNumericNode_);
                            return dynamicObject;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructNumberZero";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructNumber";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.constructNumber_toNumericNode_, this.constructNumber_toNumberFromNumericNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructNumberNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructNumberNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallNumberNode.class)
    public static final class CallNumberNodeGen
    extends ConstructorBuiltins.CallNumberNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToNumericNode callNumber_toNumericNode_;
        @Node.Child
        private JSNumericToNumberNode callNumber_toNumberFromNumericNode_;

        private CallNumberNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                if ((state & 1) != 0 && arguments0Value__.length == 0) {
                    return this.callNumberZero(arguments0Value__);
                }
                if ((state & 2) != 0 && arguments0Value__.length > 0) {
                    return this.callNumber(arguments0Value__, this.callNumber_toNumericNode_, this.callNumber_toNumberFromNumericNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            Object[] arguments0Value__;
            int state = this.state_;
            if ((state & 2) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Object[] && (arguments0Value__ = (Object[])arguments0Value_).length == 0) {
                return this.callNumberZero(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 2) == 0 && state != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[])arguments0Value;
                    if (arguments0Value_.length == 0) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Integer n = this.callNumberZero(arguments0Value_);
                        return n;
                    }
                    if (arguments0Value_.length > 0) {
                        this.callNumber_toNumericNode_ = (JSToNumericNode)super.insert((Node)JSToNumericNode.create());
                        this.callNumber_toNumberFromNumericNode_ = (JSNumericToNumberNode)super.insert((Node)JSNumericToNumberNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Number number = this.callNumber(arguments0Value_, this.callNumber_toNumericNode_, this.callNumber_toNumberFromNumericNode_);
                        return number;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "callNumberZero";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "callNumber";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.callNumber_toNumericNode_, this.callNumber_toNumberFromNumericNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallNumberNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallNumberNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructObjectNode.class)
    public static final class ConstructObjectNodeGen
    extends ConstructorBuiltins.ConstructObjectNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToObjectNode constructObjectJSObject_toObjectNode_;

        private ConstructObjectNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    if ((state & 1) != 0) {
                        assert (this.isNewTargetCase);
                        return this.constructObjectNewTarget(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && arguments1Value__.length == 0) {
                        return this.constructObject0(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 4) != 0) {
                        assert (!this.isNewTargetCase);
                        if (arguments1Value__.length > 0 && !ConstructorBuiltins.ConstructObjectNode.arg0NullOrUndefined(arguments1Value__)) {
                            return this.constructObjectJSObject(arguments0Value__, arguments1Value__, this.constructObjectJSObject_toObjectNode_);
                        }
                    }
                    if ((state & 8) != 0 && arguments1Value__.length > 0 && ConstructorBuiltins.ConstructObjectNode.arg0NullOrUndefined(arguments1Value__)) {
                        return this.constructObjectNullOrUndefined(arguments0Value__, arguments1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (this.isNewTargetCase) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructObjectNewTarget(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (arguments1Value_.length == 0) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructObject0(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (!this.isNewTargetCase && arguments1Value_.length > 0 && !ConstructorBuiltins.ConstructObjectNode.arg0NullOrUndefined(arguments1Value_)) {
                            this.constructObjectJSObject_toObjectNode_ = (JSToObjectNode)super.insert((Node)JSToObjectNode.createToObject(this.getContext()));
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.constructObjectJSObject(arguments0Value_, arguments1Value_, this.constructObjectJSObject_toObjectNode_);
                            return object;
                        }
                        if (arguments1Value_.length > 0 && ConstructorBuiltins.ConstructObjectNode.arg0NullOrUndefined(arguments1Value_)) {
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructObjectNullOrUndefined(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructObjectNewTarget";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructObject0";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "constructObjectJSObject";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToObjectNode>> cached = new ArrayList<List<JSToObjectNode>>();
                cached.add(Arrays.asList(this.constructObjectJSObject_toObjectNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "constructObjectNullOrUndefined";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructObjectNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructObjectNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructDateTimeFormatNode.class)
    public static final class ConstructDateTimeFormatNodeGen
    extends ConstructorBuiltins.ConstructDateTimeFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructDateTimeFormatNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructDateTimeFormat(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructDateTimeFormat(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructDateTimeFormat";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructDateTimeFormatNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructDateTimeFormatNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallDateTimeFormatNode.class)
    public static final class CallDateTimeFormatNodeGen
    extends ConstructorBuiltins.CallDateTimeFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private CallDateTimeFormatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.callDateTimeFormat(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "callDateTimeFormat";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallDateTimeFormatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallDateTimeFormatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructPluralRulesNode.class)
    public static final class ConstructPluralRulesNodeGen
    extends ConstructorBuiltins.ConstructPluralRulesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructPluralRulesNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructPluralRules(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructPluralRules(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructPluralRules";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructPluralRulesNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructPluralRulesNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructNumberFormatNode.class)
    public static final class ConstructNumberFormatNodeGen
    extends ConstructorBuiltins.ConstructNumberFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructNumberFormatNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructNumberFormat(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructNumberFormat(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructNumberFormat";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructNumberFormatNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructNumberFormatNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallNumberFormatNode.class)
    public static final class CallNumberFormatNodeGen
    extends ConstructorBuiltins.CallNumberFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private CallNumberFormatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.callNumberFormat(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "callNumberFormat";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallNumberFormatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallNumberFormatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructLocaleNode.class)
    public static final class ConstructLocaleNodeGen
    extends ConstructorBuiltins.ConstructLocaleNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructLocaleNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructLocale(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructLocale(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructLocale";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructLocaleNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructLocaleNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructDisplayNamesNode.class)
    public static final class ConstructDisplayNamesNodeGen
    extends ConstructorBuiltins.ConstructDisplayNamesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructDisplayNamesNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructDisplayNames(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructDisplayNames(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructDisplayNames";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructDisplayNamesNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructDisplayNamesNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructSegmenterNode.class)
    public static final class ConstructSegmenterNodeGen
    extends ConstructorBuiltins.ConstructSegmenterNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructSegmenterNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructSegmenter(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructSegmenter(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructSegmenter";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructSegmenterNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructSegmenterNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructRelativeTimeFormatNode.class)
    public static final class ConstructRelativeTimeFormatNodeGen
    extends ConstructorBuiltins.ConstructRelativeTimeFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructRelativeTimeFormatNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructRelativeTimeFormat(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructRelativeTimeFormat(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructRelativeTimeFormat";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructRelativeTimeFormatNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructRelativeTimeFormatNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructListFormatNode.class)
    public static final class ConstructListFormatNodeGen
    extends ConstructorBuiltins.ConstructListFormatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructListFormatNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructListFormat(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructListFormat(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructListFormat";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructListFormatNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructListFormatNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructCollatorNode.class)
    public static final class ConstructCollatorNodeGen
    extends ConstructorBuiltins.ConstructCollatorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructCollatorNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructCollator(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                this.state_ = state |= 1;
                return this.constructCollator(arguments0Value_, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructCollator";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructCollatorNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructCollatorNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallCollatorNode.class)
    public static final class CallCollatorNodeGen
    extends ConstructorBuiltins.CallCollatorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private CallCollatorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.callCollator(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "callCollator";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallCollatorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallCollatorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructFinalizationRegistryNode.class)
    public static final class ConstructFinalizationRegistryNodeGen
    extends ConstructorBuiltins.ConstructFinalizationRegistryNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructFinalizationRegistryNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                TruffleObject arguments1Value__;
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && arguments1Value_ instanceof TruffleObject && JSGuards.isCallable(arguments1Value__ = (TruffleObject)arguments1Value_)) {
                    return this.constructFinalizationRegistry(arguments0Value__, arguments1Value__);
                }
                if ((state & 2) != 0 && !JSGuards.isCallable(arguments1Value_)) {
                    return this.constructFinalizationRegistryNonObject(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                TruffleObject arguments1Value_;
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (arguments1Value instanceof TruffleObject && JSGuards.isCallable(arguments1Value_ = (TruffleObject)arguments1Value)) {
                    this.state_ = state |= 1;
                    return this.constructFinalizationRegistry(arguments0Value_, arguments1Value_);
                }
                if (!JSGuards.isCallable(arguments1Value)) {
                    this.state_ = state |= 2;
                    return this.constructFinalizationRegistryNonObject(arguments0Value_, arguments1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructFinalizationRegistry";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructFinalizationRegistryNonObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructFinalizationRegistryNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructFinalizationRegistryNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructWeakRefNode.class)
    public static final class ConstructWeakRefNodeGen
    extends ConstructorBuiltins.ConstructWeakRefNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConstructWeakRefNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && JSGuards.isJSObject(arguments1Value_)) {
                    return this.constructWeakRef(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSObject(arguments1Value_)) {
                    return this.constructWeakRefNonObject(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSGuards.isJSObject(arguments1Value)) {
                    this.state_ = state |= 1;
                    return this.constructWeakRef(arguments0Value_, arguments1Value);
                }
                if (!JSGuards.isJSObject(arguments1Value)) {
                    this.state_ = state |= 2;
                    return this.constructWeakRefNonObject(arguments0Value_, arguments1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructWeakRef";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructWeakRefNonObject";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructWeakRefNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructWeakRefNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructStringNode.class)
    public static final class ConstructStringNodeGen
    extends ConstructorBuiltins.ConstructStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToStringNode constructString_toStringNode_;

        private ConstructStringNodeGen(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, newTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    if ((state & 1) != 0 && arguments1Value__.length == 0) {
                        return this.constructStringInt0(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && arguments1Value__.length != 0) {
                        return this.constructString(arguments0Value__, arguments1Value__, this.constructString_toStringNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == 0) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructStringInt0(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (arguments1Value_.length != 0) {
                            this.constructString_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.create());
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructString(arguments0Value_, arguments1Value_, this.constructString_toStringNode_);
                            return dynamicObject;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructStringInt0";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructString";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.constructString_toStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructStringNode create(JSContext context, JSBuiltin builtin, boolean newTargetCase, JavaScriptNode[] arguments) {
            return new ConstructStringNodeGen(context, builtin, newTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallStringNode.class)
    public static final class CallStringNodeGen
    extends ConstructorBuiltins.CallStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToStringNode callString_toStringNode_;

        private CallStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                if ((state & 1) != 0 && arguments0Value__.length == 0) {
                    return this.callStringInt0(arguments0Value__);
                }
                if ((state & 2) != 0 && arguments0Value__.length != 0) {
                    return this.callString(arguments0Value__, this.callString_toStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[])arguments0Value;
                    if (arguments0Value_.length == 0) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        String string = this.callStringInt0(arguments0Value_);
                        return string;
                    }
                    if (arguments0Value_.length != 0) {
                        this.callString_toStringNode_ = (JSToStringNode)super.insert((Node)JSToStringNode.createSymbolToString());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string = this.callString(arguments0Value_, this.callString_toStringNode_);
                        return string;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "callStringInt0";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "callString";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.callString_toStringNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructRegExpNode.class)
    public static final class ConstructRegExpNodeGen
    extends ConstructorBuiltins.ConstructRegExpNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private IsRegExpNode isRegExpNode_;

        private ConstructRegExpNodeGen(JSContext context, JSBuiltin builtin, boolean isCall, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isCall, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructRegExp(arguments0Value__, arguments1Value_, arguments2Value_, this.isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    this.isRegExpNode_ = (IsRegExpNode)super.insert((Node)IsRegExpNode.create(this.getContext()));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.constructRegExp(arguments0Value_, arguments1Value, arguments2Value, this.isRegExpNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructRegExp";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<IsRegExpNode>> cached = new ArrayList<List<IsRegExpNode>>();
                cached.add(Arrays.asList(this.isRegExpNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructRegExpNode create(JSContext context, JSBuiltin builtin, boolean isCall, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructRegExpNodeGen(context, builtin, isCall, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructDateNode.class)
    public static final class ConstructDateNodeGen
    extends ConstructorBuiltins.ConstructDateNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile constructDateOne_isSpecialCase_;
        @Node.Child
        private InteropLibrary constructDateOne_interop_;

        private ConstructDateNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    if ((state & 1) != 0 && arguments1Value__.length == 0) {
                        return this.constructDateZero(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && arguments1Value__.length == 1) {
                        return this.constructDateOne(arguments0Value__, arguments1Value__, this.constructDateOne_isSpecialCase_, this.constructDateOne_interop_);
                    }
                    if ((state & 4) != 0 && arguments1Value__.length >= 2) {
                        return this.constructDateMult(arguments0Value__, arguments1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == 0) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructDateZero(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (arguments1Value_.length == 1) {
                            this.constructDateOne_isSpecialCase_ = ConditionProfile.createBinaryProfile();
                            this.constructDateOne_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructDateOne(arguments0Value_, arguments1Value_, this.constructDateOne_isSpecialCase_, this.constructDateOne_interop_);
                            return dynamicObject;
                        }
                        if (arguments1Value_.length >= 2) {
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructDateMult(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructDateZero";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructDateOne";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(this.constructDateOne_isSpecialCase_, this.constructDateOne_interop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "constructDateMult";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructDateNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructDateNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallDateNode.class)
    public static final class CallDateNodeGen
    extends ConstructorBuiltins.CallDateNode
    implements Introspection.Provider {
        private CallDateNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.callDate();
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "callDate";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallDateNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallDateNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructBooleanNode.class)
    public static final class ConstructBooleanNodeGen
    extends ConstructorBuiltins.ConstructBooleanNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToBooleanNode toBoolean_;

        private ConstructBooleanNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                return this.constructBoolean(arguments0Value__, arguments1Value_, this.toBoolean_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    this.toBoolean_ = (JSToBooleanNode)super.insert((Node)JSToBooleanNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.constructBoolean(arguments0Value_, arguments1Value, this.toBoolean_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "constructBoolean";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToBooleanNode>> cached = new ArrayList<List<JSToBooleanNode>>();
                cached.add(Arrays.asList(this.toBoolean_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructBooleanNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructBooleanNodeGen(context, builtin, isNewTargetCase, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.CallBooleanNode.class)
    public static final class CallBooleanNodeGen
    extends ConstructorBuiltins.CallBooleanNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private JSToBooleanNode toBoolean_;

        private CallBooleanNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.callBoolean(arguments0Value_, this.toBoolean_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.callBoolean(arguments0Value_, this.toBoolean_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toBoolean_ = (JSToBooleanNode)super.insert((Node)JSToBooleanNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.callBoolean(arguments0Value, this.toBoolean_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "callBoolean";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToBooleanNode>> cached = new ArrayList<List<JSToBooleanNode>>();
                cached.add(Arrays.asList(this.toBoolean_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.CallBooleanNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CallBooleanNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ConstructorBuiltins.ConstructArrayNode.class)
    public static final class ConstructArrayNodeGen
    extends ConstructorBuiltins.ConstructArrayNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private ConstructWithLengthData constructWithLength_cache;
        @Node.Child
        private ConstructWithForeignArg0Data constructWithForeignArg0_cache;
        @Node.Child
        private ConstructWithForeignArg1Data constructWithForeignArg1_cache;
        @CompilerDirectives.CompilationFinal
        private ConstructArrayVarargsData constructArrayVarargs_cache;

        private ConstructArrayNodeGen(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            super(context, builtin, isNewTargetCase);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (arguments1Value_ instanceof Object[]) {
                    ConstructArrayVarargsData s6_;
                    ConstructWithForeignArg1Data s5_;
                    ConstructWithLengthData s3_;
                    Object[] arguments1Value__ = (Object[])arguments1Value_;
                    if ((state & 1) != 0 && arguments1Value__.length == 0) {
                        return this.constructArray0(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && ConstructorBuiltins.ConstructArrayNode.isOneIntegerArg(arguments1Value__)) {
                        return this.constructArrayWithIntLength(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 4) != 0 && (s3_ = this.constructWithLength_cache) != null && ConstructorBuiltins.ConstructArrayNode.isOneNumberArg(arguments1Value__)) {
                        return this.constructWithLength(arguments0Value__, arguments1Value__, s3_.toUInt32Node_, s3_.arrayCreateNode_, s3_.rangeErrorProfile_, s3_.toArrayIndex1Profile_, s3_.toArrayIndex2Profile_);
                    }
                    if ((state & 8) != 0) {
                        ConstructWithForeignArg0Data s4_ = this.constructWithForeignArg0_cache;
                        while (s4_ != null) {
                            if (s4_.interop_.accepts(ConstructorBuiltins.ConstructArrayNode.firstArgument(arguments1Value__)) && ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value__)) {
                                return this.constructWithForeignArg(arguments0Value__, arguments1Value__, s4_.interop_, s4_.arrayCreateNode_, s4_.isNumber_, s4_.rangeErrorProfile_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state & 0x10) != 0 && (s5_ = this.constructWithForeignArg1_cache) != null && ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value__)) {
                        return this.constructWithForeignArg1Boundary(state, s5_, arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x20) != 0 && (s6_ = this.constructArrayVarargs_cache) != null && !ConstructorBuiltins.ConstructArrayNode.isOneNumberArg(arguments1Value__) && !ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value__)) {
                        return this.constructArrayVarargs(arguments0Value__, arguments1Value__, s6_.isIntegerCase_, s6_.isDoubleCase_, s6_.isObjectCase_, s6_.isLengthZero_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object constructWithForeignArg1Boundary(int state, ConstructWithForeignArg1Data s5_, DynamicObject arguments0Value__, Object[] arguments1Value__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(ConstructorBuiltins.ConstructArrayNode.firstArgument(arguments1Value__));
                DynamicObject dynamicObject = this.constructWithForeignArg(arguments0Value__, arguments1Value__, interop__, s5_.arrayCreateNode_, s5_.isNumber_, s5_.rangeErrorProfile_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == 0) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructArray0(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if ((exclude & 1) == 0 && ConstructorBuiltins.ConstructArrayNode.isOneIntegerArg(arguments1Value_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructArrayWithIntLength(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                        if (ConstructorBuiltins.ConstructArrayNode.isOneNumberArg(arguments1Value_)) {
                            ConstructWithLengthData s3_ = (ConstructWithLengthData)super.insert((Node)new ConstructWithLengthData());
                            s3_.toUInt32Node_ = s3_.insertAccessor(JSToUInt32Node.create());
                            s3_.arrayCreateNode_ = s3_.insertAccessor(ArrayCreateNode.create(this.getContext()));
                            s3_.rangeErrorProfile_ = BranchProfile.create();
                            s3_.toArrayIndex1Profile_ = BranchProfile.create();
                            s3_.toArrayIndex2Profile_ = BranchProfile.create();
                            this.constructWithLength_cache = s3_;
                            this.exclude_ = exclude |= 1;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructWithLength(arguments0Value_, arguments1Value_, s3_.toUInt32Node_, s3_.arrayCreateNode_, s3_.rangeErrorProfile_, s3_.toArrayIndex1Profile_, s3_.toArrayIndex2Profile_);
                            return dynamicObject;
                        }
                        if ((exclude & 2) == 0) {
                            int count4_ = 0;
                            ConstructWithForeignArg0Data s4_ = this.constructWithForeignArg0_cache;
                            if ((state & 8) != 0) {
                                while (!(s4_ == null || s4_.interop_.accepts(ConstructorBuiltins.ConstructArrayNode.firstArgument(arguments1Value_)) && ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value_))) {
                                    s4_ = s4_.next_;
                                    ++count4_;
                                }
                            }
                            if (s4_ == null && ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value_) && count4_ < 3) {
                                s4_ = (ConstructWithForeignArg0Data)super.insert((Node)new ConstructWithForeignArg0Data(this.constructWithForeignArg0_cache));
                                s4_.interop_ = s4_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(ConstructorBuiltins.ConstructArrayNode.firstArgument(arguments1Value_)));
                                s4_.arrayCreateNode_ = s4_.insertAccessor(ArrayCreateNode.create(this.getContext()));
                                s4_.isNumber_ = ConditionProfile.createBinaryProfile();
                                s4_.rangeErrorProfile_ = BranchProfile.create();
                                this.constructWithForeignArg0_cache = s4_;
                                this.state_ = state |= 8;
                            }
                            if (s4_ != null) {
                                lock.unlock();
                                hasLock = false;
                                DynamicObject dynamicObject = this.constructWithForeignArg(arguments0Value_, arguments1Value_, s4_.interop_, s4_.arrayCreateNode_, s4_.isNumber_, s4_.rangeErrorProfile_);
                                return dynamicObject;
                            }
                        }
                        InteropLibrary interop__ = null;
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            if (ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value_)) {
                                ConstructWithForeignArg1Data s5_ = (ConstructWithForeignArg1Data)super.insert((Node)new ConstructWithForeignArg1Data());
                                interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(ConstructorBuiltins.ConstructArrayNode.firstArgument(arguments1Value_));
                                s5_.arrayCreateNode_ = s5_.insertAccessor(ArrayCreateNode.create(this.getContext()));
                                s5_.isNumber_ = ConditionProfile.createBinaryProfile();
                                s5_.rangeErrorProfile_ = BranchProfile.create();
                                this.constructWithForeignArg1_cache = s5_;
                                this.exclude_ = exclude |= 2;
                                this.constructWithForeignArg0_cache = null;
                                state &= 0xFFFFFFF7;
                                this.state_ = state |= 0x10;
                                lock.unlock();
                                hasLock = false;
                                DynamicObject dynamicObject = this.constructWithForeignArg(arguments0Value_, arguments1Value_, interop__, s5_.arrayCreateNode_, s5_.isNumber_, s5_.rangeErrorProfile_);
                                return dynamicObject;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                        if (!ConstructorBuiltins.ConstructArrayNode.isOneNumberArg(arguments1Value_) && !ConstructorBuiltins.ConstructArrayNode.isOneForeignArg(arguments1Value_)) {
                            ConstructArrayVarargsData s6_ = new ConstructArrayVarargsData();
                            s6_.isIntegerCase_ = BranchProfile.create();
                            s6_.isDoubleCase_ = BranchProfile.create();
                            s6_.isObjectCase_ = BranchProfile.create();
                            s6_.isLengthZero_ = ConditionProfile.createBinaryProfile();
                            this.constructArrayVarargs_cache = s6_;
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.constructArrayVarargs(arguments0Value_, arguments1Value_, s6_.isIntegerCase_, s6_.isDoubleCase_, s6_.isObjectCase_, s6_.isLengthZero_);
                            return dynamicObject;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ConstructWithForeignArg0Data s4_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s4_ = this.constructWithForeignArg0_cache) == null || s4_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[7];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "constructArray0";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "constructArrayWithIntLength";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s;
            s = new Object[3];
            s[0] = "constructWithLength";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                ConstructWithLengthData s3_ = this.constructWithLength_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s3_.toUInt32Node_, s3_.arrayCreateNode_, s3_.rangeErrorProfile_, s3_.toArrayIndex1Profile_, s3_.toArrayIndex2Profile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "constructWithForeignArg";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                ConstructWithForeignArg0Data s4_ = this.constructWithForeignArg0_cache;
                while (s4_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s4_.interop_, s4_.arrayCreateNode_, s4_.isNumber_, s4_.rangeErrorProfile_}));
                    s4_ = s4_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "constructWithForeignArg";
            if ((state & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                ConstructWithForeignArg1Data s5_ = this.constructWithForeignArg1_cache;
                if (s5_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{INTEROP_LIBRARY_.getUncached(), s5_.arrayCreateNode_, s5_.isNumber_, s5_.rangeErrorProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "constructArrayVarargs";
            if ((state & 0x20) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                ConstructArrayVarargsData s6_ = this.constructArrayVarargs_cache;
                if (s6_ != null) {
                    cached.add(Arrays.asList(s6_.isIntegerCase_, s6_.isDoubleCase_, s6_.isObjectCase_, s6_.isLengthZero_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[6] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ConstructorBuiltins.ConstructArrayNode create(JSContext context, JSBuiltin builtin, boolean isNewTargetCase, JavaScriptNode[] arguments) {
            return new ConstructArrayNodeGen(context, builtin, isNewTargetCase, arguments);
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructArrayNode.class)
        private static final class ConstructArrayVarargsData {
            @CompilerDirectives.CompilationFinal
            BranchProfile isIntegerCase_;
            @CompilerDirectives.CompilationFinal
            BranchProfile isDoubleCase_;
            @CompilerDirectives.CompilationFinal
            BranchProfile isObjectCase_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isLengthZero_;

            ConstructArrayVarargsData() {
            }
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructArrayNode.class)
        private static final class ConstructWithForeignArg1Data
        extends Node {
            @Node.Child
            ArrayCreateNode arrayCreateNode_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isNumber_;
            @CompilerDirectives.CompilationFinal
            BranchProfile rangeErrorProfile_;

            ConstructWithForeignArg1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructArrayNode.class)
        private static final class ConstructWithForeignArg0Data
        extends Node {
            @Node.Child
            ConstructWithForeignArg0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            ArrayCreateNode arrayCreateNode_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isNumber_;
            @CompilerDirectives.CompilationFinal
            BranchProfile rangeErrorProfile_;

            ConstructWithForeignArg0Data(ConstructWithForeignArg0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ConstructorBuiltins.ConstructArrayNode.class)
        private static final class ConstructWithLengthData
        extends Node {
            @Node.Child
            JSToUInt32Node toUInt32Node_;
            @Node.Child
            ArrayCreateNode arrayCreateNode_;
            @CompilerDirectives.CompilationFinal
            BranchProfile rangeErrorProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile toArrayIndex1Profile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile toArrayIndex2Profile_;

            ConstructWithLengthData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

