/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsObjectNode.class)
public final class IsObjectNodeGen
extends IsObjectNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;

    private IsObjectNodeGen() {
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 3) != 0) {
            if ((state & 1) != 0 && JSGuards.isJSNull(arg0Value)) {
                return IsObjectNode.doNull(arg0Value);
            }
            if ((state & 2) != 0 && JSGuards.isUndefined(arg0Value)) {
                return IsObjectNode.doUndefined(arg0Value);
            }
        }
        if ((state & 4) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_2 = (Boolean)arg0Value;
            return IsObjectNode.doBoolean(arg0Value_2);
        }
        if ((state & 8) != 0 && arg0Value instanceof Integer) {
            int arg0Value_3 = (Integer)arg0Value;
            return IsObjectNode.doInt(arg0Value_3);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Long) {
            long arg0Value_4 = (Long)arg0Value;
            return IsObjectNode.doLong(arg0Value_4);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_5 = (SafeInteger)arg0Value;
            return IsObjectNode.doLargeInt(arg0Value_5);
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E000) >>> 13, arg0Value)) {
            double arg0Value_6 = JSTypesGen.asImplicitDouble((state & 0x1E000) >>> 13, arg0Value);
            return IsObjectNode.doDouble(arg0Value_6);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_7 = (Symbol)arg0Value;
            return IsObjectNode.doSymbol(arg0Value_7);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_8 = (BigInt)arg0Value;
            return IsObjectNode.doBigInt(arg0Value_8);
        }
        if ((state & 0x200) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x1E0000) >>> 17, arg0Value)) {
            CharSequence arg0Value_9 = JSTypesGen.asImplicitCharSequence((state & 0x1E0000) >>> 17, arg0Value);
            return IsObjectNode.doString(arg0Value_9);
        }
        if ((state & 0x400) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return IsObjectNode.doIsObject(arg0Value_);
        }
        if ((state & 0x1800) != 0) {
            if ((state & 0x800) != 0) {
                ForeignObject0Data s12_ = this.foreignObject0_cache;
                while (s12_ != null) {
                    if (s12_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                        return IsObjectNode.doForeignObject(arg0Value, s12_.interop_);
                    }
                    s12_ = s12_.next_;
                }
            }
            if ((state & 0x1000) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.foreignObject1Boundary(state, arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary(int state, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
            boolean bl = IsObjectNode.doForeignObject(arg0Value, foreignObject1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doNull(arg0Value);
                return bl;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doUndefined(arg0Value);
                return bl;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_2 = (Boolean)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doBoolean(arg0Value_2);
                return bl;
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_3 = (Integer)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doInt(arg0Value_3);
                return bl;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doLong(arg0Value_4);
                return bl;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_5 = (SafeInteger)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doLargeInt(arg0Value_5);
                return bl;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_6 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 13;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doDouble(arg0Value_6);
                return bl;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_7 = (Symbol)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                boolean arg0Value_6 = IsObjectNode.doSymbol(arg0Value_7);
                return arg0Value_6;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_8 = (BigInt)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                boolean arg0Value_6 = IsObjectNode.doBigInt(arg0Value_8);
                return arg0Value_6;
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (charSequenceCast0 != 0) {
                CharSequence arg0Value_9 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                state |= charSequenceCast0 << 17;
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                boolean bl = IsObjectNode.doString(arg0Value_9);
                return bl;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                boolean arg0Value_9 = IsObjectNode.doIsObject(arg0Value_);
                return arg0Value_9;
            }
            if (exclude == 0) {
                int count12_ = 0;
                ForeignObject0Data s12_ = this.foreignObject0_cache;
                if ((state & 0x800) != 0) {
                    while (!(s12_ == null || s12_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value))) {
                        s12_ = s12_.next_;
                        ++count12_;
                    }
                }
                if (s12_ == null && JSGuards.isForeignObject(arg0Value) && count12_ < 5) {
                    s12_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                    s12_.interop_ = s12_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                    this.foreignObject0_cache = s12_;
                    this.state_ = state |= 0x800;
                }
                if (s12_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsObjectNode.doForeignObject(arg0Value, s12_.interop_);
                    return bl;
                }
            }
            InteropLibrary foreignObject1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isForeignObject(arg0Value)) {
                    foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 1;
                    this.foreignObject0_cache = null;
                    state &= 0xFFFFF7FF;
                    this.state_ = state |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsObjectNode.doForeignObject(arg0Value, foreignObject1_interop__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ForeignObject0Data s12_;
        int state = this.state_;
        if ((state & 0x1FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFF & (state & 0x1FFF) - 1) == 0 && ((s12_ = this.foreignObject0_cache) == null || s12_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<InteropLibrary>> cached;
        Object[] data = new Object[14];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doLargeInt";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doIsObject";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<InteropLibrary>>();
            ForeignObject0Data s12_ = this.foreignObject0_cache;
            while (s12_ != null) {
                cached.add(Arrays.asList(s12_.interop_));
                s12_ = s12_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x1000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList((InteropLibrary)INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[13] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsObjectNode create() {
        return new IsObjectNodeGen();
    }

    @GeneratedBy(value=IsObjectNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

