/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsNullNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsNullNode.class)
public final class IsNullNodeGen
extends IsNullNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private Cached0Data cached0_cache;

    private IsNullNodeGen(JavaScriptNode operand, boolean leftConstant) {
        super(operand, leftConstant);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return IsNullNode.doNull(operandNodeValue);
            }
            if ((state & 2) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return IsNullNode.doUndefined(operandNodeValue);
            }
            if ((state & 4) != 0 && JSGuards.isJSObject(operandNodeValue)) {
                return IsNullNode.doObject(operandNodeValue);
            }
            if ((state & 8) != 0) {
                Cached0Data s4_ = this.cached0_cache;
                while (s4_ != null) {
                    if (s4_.interop_.accepts(operandNodeValue) && !JSGuards.isJSType(operandNodeValue)) {
                        return IsNullNode.doCached(operandNodeValue, s4_.interop_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSType(operandNodeValue)) {
                return this.cached1Boundary(state, operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object cached1Boundary(int state, Object operandNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary cached1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue);
            Boolean bl = IsNullNode.doCached(operandNodeValue, cached1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                return IsNullNode.doNull(operandNodeValue_);
            }
            if ((state & 2) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                return IsNullNode.doUndefined(operandNodeValue_);
            }
            if ((state & 4) != 0 && JSGuards.isJSObject(operandNodeValue_)) {
                return IsNullNode.doObject(operandNodeValue_);
            }
            if ((state & 8) != 0) {
                Cached0Data s4_ = this.cached0_cache;
                while (s4_ != null) {
                    if (s4_.interop_.accepts(operandNodeValue_) && !JSGuards.isJSType(operandNodeValue_)) {
                        return IsNullNode.doCached(operandNodeValue_, s4_.interop_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSType(operandNodeValue_)) {
                return this.cached1Boundary0(state, operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object cached1Boundary0(int state, Object operandNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary cached1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue_);
            Boolean bl = IsNullNode.doCached(operandNodeValue_, cached1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                return IsNullNode.doNull(operandNodeValue_);
            }
            if ((state & 2) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                return IsNullNode.doUndefined(operandNodeValue_);
            }
            if ((state & 4) != 0 && JSGuards.isJSObject(operandNodeValue_)) {
                return IsNullNode.doObject(operandNodeValue_);
            }
            if ((state & 8) != 0) {
                Cached0Data s4_ = this.cached0_cache;
                while (s4_ != null) {
                    if (s4_.interop_.accepts(operandNodeValue_) && !JSGuards.isJSType(operandNodeValue_)) {
                        return IsNullNode.doCached(operandNodeValue_, s4_.interop_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSType(operandNodeValue_)) {
                return this.cached1Boundary1(state, operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean cached1Boundary1(int state, Object operandNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary cached1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue_);
            boolean bl = IsNullNode.doCached(operandNodeValue_, cached1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSGuards.isJSNull(operandNodeValue)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = IsNullNode.doNull(operandNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(operandNodeValue)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = IsNullNode.doUndefined(operandNodeValue);
                return bl;
            }
            if (JSGuards.isJSObject(operandNodeValue)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = IsNullNode.doObject(operandNodeValue);
                return bl;
            }
            if (exclude == 0) {
                int count4_ = 0;
                Cached0Data s4_ = this.cached0_cache;
                if ((state & 8) != 0) {
                    while (s4_ != null && (!s4_.interop_.accepts(operandNodeValue) || JSGuards.isJSType(operandNodeValue))) {
                        s4_ = s4_.next_;
                        ++count4_;
                    }
                }
                if (s4_ == null && !JSGuards.isJSType(operandNodeValue) && count4_ < 5) {
                    s4_ = (Cached0Data)super.insert((Node)new Cached0Data(this.cached0_cache));
                    s4_.interop_ = s4_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(operandNodeValue));
                    this.cached0_cache = s4_;
                    this.state_ = state |= 8;
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsNullNode.doCached(operandNodeValue, s4_.interop_);
                    return bl;
                }
            }
            InteropLibrary cached1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (!JSGuards.isJSType(operandNodeValue)) {
                    cached1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.cached0_cache = null;
                    state &= 0xFFFFFFF7;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsNullNode.doCached(operandNodeValue, cached1_interop__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        Cached0Data s4_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s4_ = this.cached0_cache) == null || s4_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<InteropLibrary>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doCached";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<InteropLibrary>>();
            Cached0Data s4_ = this.cached0_cache;
            while (s4_ != null) {
                cached.add(Arrays.asList(s4_.interop_));
                s4_ = s4_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doCached";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList((InteropLibrary)INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsNullNode create(JavaScriptNode operand, boolean leftConstant) {
        return new IsNullNodeGen(operand, leftConstant);
    }

    @GeneratedBy(value=IsNullNode.class)
    private static final class Cached0Data
    extends Node {
        @Node.Child
        Cached0Data next_;
        @Node.Child
        InteropLibrary interop_;

        Cached0Data(Cached0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

