/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.DownloadURLIterable;
import org.graalvm.component.installer.Environment;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileIterable;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.SimpleGetopt;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.UserAbortException;
import org.graalvm.component.installer.commands.AvailableCommand;
import org.graalvm.component.installer.commands.InfoCommand;
import org.graalvm.component.installer.commands.InstallCommand;
import org.graalvm.component.installer.commands.ListInstalledCommand;
import org.graalvm.component.installer.commands.PostInstCommand;
import org.graalvm.component.installer.commands.PreRemoveCommand;
import org.graalvm.component.installer.commands.RebuildImageCommand;
import org.graalvm.component.installer.commands.UninstallCommand;
import org.graalvm.component.installer.commands.UpgradeCommand;
import org.graalvm.component.installer.model.CatalogContents;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.os.WindowsJVMWrapper;
import org.graalvm.component.installer.persist.DirectoryStorage;
import org.graalvm.component.installer.remote.CatalogIterable;
import org.graalvm.component.installer.remote.RemoteCatalogDownloader;
import org.graalvm.launcher.Launcher;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;

public class ComponentInstaller
extends Launcher {
    private static final Logger LOG = Logger.getLogger(ComponentInstaller.class.getName());
    public static final String GRAAL_DEFAULT_RELATIVE_PATH = "../..";
    private static final Environment SIMPLE_ENV = new Environment("help", Collections.emptyList(), Collections.emptyMap()).enableStacktraces();
    private String command;
    private InstallerCommand cmdHandler;
    private LinkedList<String> cmdlineParams;
    private List<String> parameters = Collections.emptyList();
    private Path graalHomePath;
    private Path storagePath;
    private SimpleGetopt options;
    static final Map<String, InstallerCommand> commands = new HashMap<String, InstallerCommand>();
    public static final Map<String, String> globalOptions = new HashMap<String, String>();
    public static final Map<String, String> componentOptions = new HashMap<String, String>();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.graalvm.component.installer.Bundle");
    private Environment env;
    private CommandInput input;
    private Feedback feedback;

    static void initCommands() {
        commands.clear();
        globalOptions.clear();
        componentOptions.put("c", "");
        componentOptions.put("L", "");
        componentOptions.put("u", "");
        componentOptions.put("C", "s");
        componentOptions.put("F", "=L");
        componentOptions.put("local-file", "L");
        componentOptions.put("catalog", "c");
        componentOptions.put("url", "u");
        componentOptions.put("custom-catalog", "C");
        componentOptions.put("file", "L");
        commands.put("install", new InstallCommand());
        commands.put("remove", new UninstallCommand());
        commands.put("list", new ListInstalledCommand());
        commands.put("available", new AvailableCommand());
        commands.put("info", new InfoCommand());
        commands.put("rebuild-images", new RebuildImageCommand());
        commands.put("update", new UpgradeCommand());
        commands.put("#postinstall", new PostInstCommand());
        commands.put("#preremove", new PreRemoveCommand());
        globalOptions.put("v", "");
        globalOptions.put("e", "");
        globalOptions.put("h", "");
        globalOptions.put("verbose", "v");
        globalOptions.put("debug", "e");
        globalOptions.put("help", "h");
        globalOptions.put("A", "");
        globalOptions.put("auto-yes", "A");
        globalOptions.put("N", "");
        globalOptions.put("non-interactive", "N");
        globalOptions.put("@", "");
        globalOptions.put("#", "");
        globalOptions.put("version", "@");
        globalOptions.put("show-version", "#");
        globalOptions.put("E", "");
        globalOptions.put("no-catalog-errors", "E");
        globalOptions.putAll(componentOptions);
    }

    public static void forSoftwareChannels(boolean report, Consumer<SoftwareChannel.Factory> callback) {
        ServiceLoader<SoftwareChannel.Factory> channels = ServiceLoader.load(SoftwareChannel.Factory.class);
        Iterator<SoftwareChannel.Factory> it = channels.iterator();
        while (it.hasNext()) {
            try {
                SoftwareChannel.Factory ch = it.next();
                callback.accept(ch);
            }
            catch (Exception | ServiceConfigurationError ex) {
                if (!report) continue;
                LOG.log(Level.SEVERE, MessageFormat.format(BUNDLE.getString("ERROR_SoftwareChannelBroken"), ex.getLocalizedMessage()));
            }
        }
    }

    ComponentInstaller(String[] args) {
        this.cmdlineParams = new LinkedList<String>(Arrays.asList(args));
    }

    protected void printUsage(Feedback output) {
        output.output("INFO_InstallerVersion", "2.0.0");
        ComponentInstaller.printHelp(output);
    }

    private static void printHelp(Feedback output) {
        StringBuilder extra = new StringBuilder();
        ComponentInstaller.forSoftwareChannels(false, ch -> {
            ch.init(SIMPLE_ENV, output);
            String s = ch.globalOptionsHelp();
            if (s != null) {
                extra.append(s);
            }
        });
        String extraS = extra.length() != 0 ? output.l10n("INFO_UsageExtensions", extra.toString()) : "";
        output.output("INFO_Usage", extraS);
    }

    static void printErr(String messageKey, Object ... args) {
        SIMPLE_ENV.message(messageKey, args);
    }

    static RuntimeException err(String messageKey, Object ... args) {
        ComponentInstaller.printErr(messageKey, args);
        ComponentInstaller.printHelp(SIMPLE_ENV);
        System.exit(1);
        throw new RuntimeException("should not reach here");
    }

    protected RuntimeException error(String messageKey, Object ... args) {
        return ComponentInstaller.err(messageKey, args);
    }

    CommandInput getInput() {
        return this.input;
    }

    void setInput(CommandInput input) {
        this.input = input;
    }

    Feedback getFeedback() {
        return this.feedback;
    }

    void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    Environment setupEnvironment(SimpleGetopt go) {
        Environment e = new Environment(this.command, this.parameters, go.getOptValues());
        this.setInput(e);
        this.setFeedback(e);
        this.finddGraalHome();
        e.setGraalHome(this.graalHomePath);
        Path trustStorePath = SystemUtils.resolveRelative(SystemUtils.getRuntimeBaseDir(e.getGraalHomePath()), "lib/security/cacerts");
        System.setProperty("javax.net.ssl.trustStore", trustStorePath.normalize().toString());
        DirectoryStorage storage = new DirectoryStorage(e, this.storagePath, this.graalHomePath);
        storage.setJavaVersion("" + SystemUtils.getJavaMajorVersion(e));
        e.setLocalRegistry(new ComponentRegistry(e, storage));
        FileOperations fops = FileOperations.createPlatformInstance(e, e.getGraalHomePath());
        e.setFileOperations(fops);
        return e;
    }

    protected SimpleGetopt createOptionsObject(Map<String, String> opts) {
        return new SimpleGetopt(opts);
    }

    SimpleGetopt createOptions(LinkedList<String> cmdline) {
        SimpleGetopt go = this.createOptionsObject(globalOptions).ignoreUnknownOptions(true);
        go.setParameters(new LinkedList<String>(cmdline));
        for (String s : commands.keySet()) {
            go.addCommandOptions(s, commands.get(s).supportedOptions());
        }
        go.process();
        this.options = go;
        this.command = go.getCommand();
        this.cmdHandler = commands.get(this.command);
        this.parameters = go.getPositionalParameters();
        this.env = this.setupEnvironment(go);
        ComponentInstaller.forSoftwareChannels(true, ch -> ch.init(this.input, this.feedback));
        return go;
    }

    SimpleGetopt interpretOptions(SimpleGetopt go) {
        List<String> unknownOptions = go.getUnknownOptions();
        if (this.env.hasOption("h") && go.getCommand() == null) {
            unknownOptions.add("help");
        }
        this.parseUnknownOptions(unknownOptions);
        if (this.runLauncher()) {
            return null;
        }
        return go;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    int processOptions(LinkedList<String> cmdline) {
        if (cmdline.size() < 1) {
            this.env = SIMPLE_ENV;
            this.printDefaultHelp(OptionCategory.USER);
            return 1;
        }
        SimpleGetopt go = this.createOptions(cmdline);
        this.launch(cmdline);
        go = this.interpretOptions(go);
        if (go == null) {
            return 0;
        }
        if (this.env.hasOption("@")) {
            this.printVersion();
            return 0;
        }
        if (this.env.hasOption("#")) {
            this.printVersion();
        }
        if (this.cmdHandler == null) {
            this.error("ERROR_MissingCommand", new Object[0]);
        }
        int srcCount = 0;
        if (this.input.hasOption("L")) {
            ++srcCount;
        }
        if (this.input.hasOption("u")) {
            ++srcCount;
        }
        if (srcCount > 1) {
            this.error("ERROR_MultipleSourcesUnsupported", new Object[0]);
        }
        if (this.input.hasOption("A")) {
            this.env.setAutoYesEnabled(true);
        }
        if (this.input.hasOption("N")) {
            this.env.setNonInteractive(true);
        }
        String catalogURL = this.getExplicitCatalogURL();
        String builtinCatLocation = this.getReleaseCatalogURL();
        RemoteCatalogDownloader downloader = new RemoteCatalogDownloader(this.input, this.feedback, catalogURL);
        if (builtinCatLocation == null) {
            builtinCatLocation = this.feedback.l10n("Installer_BuiltingCatalogURL", new Object[0]);
        }
        downloader.setDefaultCatalog(builtinCatLocation);
        CommandInput.CatalogFactory cFactory = (in, lreg) -> {
            RemoteCatalogDownloader nDownloader = lreg == in.getLocalRegistry() ? downloader : new RemoteCatalogDownloader(in, (Feedback)this.env, downloader.getOverrideCatalogSpec());
            CatalogContents col = new CatalogContents(this.env, nDownloader.getStorage(), lreg);
            col.setRemoteEnabled(downloader.isRemoteSourcesAllowed());
            return col;
        };
        this.env.setCatalogFactory(cFactory);
        boolean builtinsImplied = true;
        boolean setIterable = true;
        if (this.input.hasOption("L")) {
            FileIterable fi = new FileIterable(this.env, this.env);
            fi.setCatalogFactory(cFactory);
            this.env.setFileIterable(fi);
            builtinsImplied = false;
            if (this.input.hasOption("D")) {
                while (this.env.hasParameter()) {
                    Path parent;
                    String s = this.env.nextParameter();
                    Path p = SystemUtils.fromUserString(s);
                    if (p == null || (parent = p.getParent()) == null || !Files.isDirectory(parent, new LinkOption[0])) continue;
                    SoftwareChannelSource localSource = new SoftwareChannelSource(parent.toUri().toString(), null);
                    downloader.addLocalChannelSource(localSource);
                }
                this.env.resetParameters();
            }
            setIterable = false;
        } else if (this.input.hasOption("u")) {
            DownloadURLIterable dit = new DownloadURLIterable(this.env, this.env);
            dit.setCatalogFactory(cFactory);
            this.env.setFileIterable(dit);
            setIterable = false;
            builtinsImplied = false;
        }
        if (setIterable) {
            this.env.setFileIterable(new CatalogIterable(this.env, this.env));
        }
        downloader.setRemoteSourcesAllowed(builtinsImplied || this.env.hasOption("c") || this.env.hasOption("C"));
        return -1;
    }

    int doProcessCommand() throws IOException {
        this.cmdHandler.init(this.input, this.feedback.withBundle(this.cmdHandler.getClass()));
        return this.cmdHandler.execute();
    }

    /*
     * Exception decompiling
     */
    private int processCommand(LinkedList<String> cmds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Path finddGraalHome() {
        String graalHome = this.input.getParameter("GRAAL_HOME", this.input.getParameter("GRAAL_HOME", false), true);
        Path graalPath = null;
        if (graalHome != null) {
            graalPath = SystemUtils.fromUserString(graalHome);
        } else {
            CodeSource cs;
            URL loc = null;
            ProtectionDomain pd = ComponentInstaller.class.getProtectionDomain();
            if (pd != null && (cs = pd.getCodeSource()) != null) {
                loc = cs.getLocation();
            }
            if (loc != null) {
                try {
                    Path p;
                    Path guParent;
                    File f = new File(loc.toURI());
                    Path path = guParent = f.isFile() ? f.toPath().getParent() : f.toPath();
                    if (guParent != null && (p = (graalPath = guParent.resolve(SystemUtils.fromCommonString(GRAAL_DEFAULT_RELATIVE_PATH)).normalize().toAbsolutePath()).getFileName()) != null && "lib".equals(p.toString())) {
                        graalPath = graalPath.getParent();
                    }
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(ComponentInstaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (graalPath == null) {
            throw SIMPLE_ENV.failure("ERROR_NoGraalVMDirectory", null, new Object[0]);
        }
        if (!Files.isDirectory(graalPath, new LinkOption[0]) || !Files.exists(graalPath.resolve(SystemUtils.fileName("release")), new LinkOption[0])) {
            throw SIMPLE_ENV.failure("ERROR_InvalidGraalVMDirectory", null, graalPath);
        }
        this.storagePath = graalPath.resolve(SystemUtils.fromCommonString("lib/installer/components"));
        if (!Files.isDirectory(this.storagePath, new LinkOption[0])) {
            throw SIMPLE_ENV.failure("ERROR_InvalidGraalVMDirectory", null, graalPath);
        }
        this.graalHomePath = graalPath.normalize();
        String libpath = System.getProperty("java.library.path");
        if (libpath == null || libpath.isEmpty()) {
            Path newLibPath = SystemUtils.getRuntimeLibDir(graalPath, true);
            if (newLibPath == null) {
                throw SIMPLE_ENV.failure("ERROR_UnknownSystem", null, System.getProperty("os.name"));
            }
            System.setProperty("java.library.path", newLibPath.toString());
        }
        return graalPath;
    }

    public void run() {
        try {
            System.exit(this.processCommand(this.cmdlineParams));
        }
        catch (UserAbortException ex) {
            SIMPLE_ENV.message("ERROR_Aborted", ex.getMessage());
        }
        catch (Exception ex) {
            SIMPLE_ENV.error("ERROR_InternalError", ex, ex.getMessage());
            System.exit(3);
        }
    }

    String getExplicitCatalogURL() {
        Path p;
        String s;
        String envVar;
        String def = null;
        String cmdLine = this.input.optValue("C");
        if (cmdLine != null) {
            def = cmdLine;
        }
        if ((envVar = this.input.getParameter("GRAALVM_CATALOG", false)) != null) {
            def = envVar;
        }
        if ((s = this.input.getParameter("org.graalvm.component.catalog", def, true)) == null) {
            return null;
        }
        boolean useAsFile = false;
        try {
            URI check = URI.create(s);
            if (check.getScheme() == null || check.getScheme().length() < 2) {
                useAsFile = true;
            }
        }
        catch (IllegalArgumentException ex) {
            useAsFile = true;
        }
        if (useAsFile && (Files.isReadable(p = SystemUtils.fromUserString(s)) || Files.isDirectory(p, new LinkOption[0]))) {
            return p.toFile().toURI().toString();
        }
        return s;
    }

    private String getReleaseCatalogURL() {
        String s = this.env.getLocalRegistry().getGraalCapabilities().get("component_catalog");
        return s;
    }

    public static void main(String[] args) {
        new ComponentInstaller(args).run();
    }

    void configureLogging(Map<String, String> properties) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        LinkedList<Logger> keep = new LinkedList<Logger>();
        boolean rootLevelSet = false;
        for (String key : properties.keySet()) {
            String k;
            String v;
            if (!key.startsWith("log.") || !key.endsWith(".level") || (v = properties.get(key)) == null) continue;
            if (key.length() > 10) {
                k = key.substring(4);
            } else {
                k = ".level";
                rootLevelSet = true;
            }
            ps.print(k);
            ps.print('=');
            ps.println(v);
            keep.add(Logger.getLogger(k.substring(0, k.length() - 6)));
        }
        if (!rootLevelSet) {
            ps.println(".level=WARNING");
        }
        ps.println("java.util.logging.SimpleFormatter.format=[%4$-7s] %5$s %n");
        ps.println("");
        try {
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            this.env.error("WARN_CouldNotInitializeLogManager", ex, ex.getLocalizedMessage());
            return;
        }
        Logger logger = Logger.getLogger("");
        Handler[] old = logger.getHandlers();
        Path p = this.getLogFile();
        if (old.length > 0) {
            for (int i = 0; i < old.length; ++i) {
                old[i].setLevel(Level.ALL);
            }
        }
        if (old.length == 0 || p != null) {
            OutputStream logOs = new EnvStream(true, System.err);
            try {
                if (p != null) {
                    logOs = ComponentInstaller.newLogStream((Path)this.getLogFile());
                }
            }
            catch (IOException ex) {
                this.env.error("WARN_CouldNotCreateLog", ex, p.toString(), ex.getLocalizedMessage());
            }
            StreamHandler h = new StreamHandler(logOs, new SimpleFormatter());
            h.setLevel(Level.ALL);
            logger.addHandler(h);
        }
    }

    protected boolean canPolyglot() {
        return false;
    }

    public void launch(List<String> args) {
        this.maybeNativeExec(args, false, new LinkedHashMap());
    }

    public Map<String, String> parseUnknownOptions(List<String> uOpts) {
        List ooo = uOpts.stream().map(o -> o.length() > 1 ? "--" + o : "-" + o).collect(Collectors.toList());
        HashMap<String, String> polyOptions = new HashMap<String, String>();
        this.parseUnrecognizedOptions(null, polyOptions, ooo);
        this.configureLogging(polyOptions);
        return polyOptions;
    }

    protected void printHelp(OptionCategory maxCategory) {
        this.printUsage(this.env);
    }

    protected void printVersion() {
        this.feedback.output("MSG_InstallerVersion", this.env.getLocalRegistry().getGraalVersion().displayString());
    }

    public boolean runLauncher() {
        return super.runLauncherAction();
    }

    protected void collectArguments(Set<String> result) {
        result.addAll(this.options.getAllOptions());
    }

    protected OptionDescriptor findOptionDescriptor(String group, String key) {
        return null;
    }

    protected void executeJVM(String classpath, List<String> jvmArgs, List<String> remainingArgs, Map<String, String> polyglotOptions) {
        if (SystemUtils.isWindows()) {
            int retcode = this.executeJVMMode(classpath, jvmArgs, remainingArgs);
            System.exit(retcode);
        } else {
            super.executeJVM(classpath, jvmArgs, remainingArgs, polyglotOptions);
        }
    }

    int executeJVMMode(String classpath, List<String> jvmArgs, List<String> remainingArgs) {
        WindowsJVMWrapper jvmWrapper = new WindowsJVMWrapper(this.env, this.env.getFileOperations(), this.env.getGraalHomePath());
        jvmWrapper.vm(this.getGraalVMBinaryPath("java").toString(), jvmArgs).mainClass(this.getMainClass()).classpath(classpath).args(remainingArgs);
        try {
            return jvmWrapper.execute();
        }
        catch (IOException ex) {
            throw this.env.failure("ERR_InvokingJvmMode", ex, ex.getMessage());
        }
    }

    static {
        ComponentInstaller.initCommands();
        ComponentInstaller.forSoftwareChannels(true, ch -> {
            ch.init(SIMPLE_ENV, SIMPLE_ENV);
            globalOptions.putAll(ch.globalOptions());
        });
    }

    final class EnvStream
    extends PrintStream {
        private final boolean error;

        EnvStream(boolean err, OutputStream dummyStream) {
            super(dummyStream);
            this.error = err;
        }

        @Override
        public PrintStream append(char c) {
            ComponentInstaller.this.env.verbatimPart("" + c, this.error);
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            CharSequence cs = csq == null ? "null" : csq;
            this.append(cs.subSequence(start, end));
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            CharSequence cs = csq == null ? "null" : csq;
            ComponentInstaller.this.env.verbatimPart(cs.toString(), this.error, false);
            return this;
        }

        @Override
        public void println(Object x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(String x) {
            if (this.error) {
                ComponentInstaller.this.env.message(null, x);
            } else {
                ComponentInstaller.this.env.output(null, x);
            }
        }

        @Override
        public void println(char[] x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(double x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(char x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(boolean x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println() {
            this.println("");
        }

        @Override
        public void print(Object obj) {
            this.print(String.valueOf(obj));
        }

        @Override
        public void print(String s) {
            ComponentInstaller.this.env.verbatimPart(s, this.error, false);
        }

        @Override
        public void print(char[] s) {
            this.print(String.valueOf(s));
        }

        @Override
        public void print(double d) {
            this.print(String.valueOf(d));
        }

        @Override
        public void print(float f) {
            this.print(String.valueOf(f));
        }

        @Override
        public void print(long l) {
            this.print(String.valueOf(l));
        }

        @Override
        public void print(int i) {
            this.print(String.valueOf(i));
        }

        @Override
        public void print(char c) {
            this.print(String.valueOf(c));
        }

        @Override
        public void print(boolean b) {
            this.print(String.valueOf(b));
        }
    }
}

