/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import org.graalvm.component.installer.AbstractIterable;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentIterable;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileIterable;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.remote.RemoteComponentParam;

public class DownloadURLIterable
extends AbstractIterable {
    public DownloadURLIterable(Feedback feedback, CommandInput input) {
        super(input, feedback);
    }

    @Override
    public Iterator<ComponentParam> iterator() {
        return new It();
    }

    @Override
    public ComponentIterable matchVersion(Version.Match m) {
        return this;
    }

    @Override
    public ComponentIterable allowIncompatible() {
        return this;
    }

    static class DownloadURLParam
    extends RemoteComponentParam {
        DownloadURLParam(URL remoteURL, String dispName, String spec, Feedback feedback, boolean progress) {
            super(remoteURL, dispName, spec, feedback, progress);
        }

        @Override
        protected MetadataLoader metadataFromLocal(Path localFile) throws IOException {
            FileIterable.FileComponent fc = new FileIterable.FileComponent(localFile.toFile(), this.isVerifyJars(), SystemUtils.fingerPrint(this.getDownloader().getReceivedDigest(), false), this.getFeedback());
            return fc.createFileLoader();
        }

        @Override
        public ComponentInfo completeMetadata() throws IOException {
            return this.createFileLoader().completeMetadata();
        }
    }

    class It
    implements Iterator<ComponentParam> {
        It() {
        }

        @Override
        public boolean hasNext() {
            return DownloadURLIterable.this.input.hasParameter();
        }

        @Override
        public ComponentParam next() {
            URL u;
            String s = DownloadURLIterable.this.input.nextParameter();
            try {
                u = new URL(s);
            }
            catch (MalformedURLException ex) {
                throw DownloadURLIterable.this.feedback.failure("URL_InvalidDownloadURL", ex, s, ex.getLocalizedMessage());
            }
            boolean progress = DownloadURLIterable.this.input.optValue("n") == null;
            DownloadURLParam p = new DownloadURLParam(u, s, s, DownloadURLIterable.this.feedback, progress);
            p.setVerifyJars(DownloadURLIterable.this.isVerifyJars());
            return p;
        }
    }
}

