/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.commands.PreRemoveProcess;
import org.graalvm.component.installer.model.ComponentInfo;

public class PreRemoveCommand
implements InstallerCommand {
    private CommandInput input;
    private Feedback feedback;

    @Override
    public Map<String, String> supportedOptions() {
        return Collections.emptyMap();
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.input = commandInput;
        this.feedback = feedBack;
    }

    @Override
    public int execute() throws IOException {
        String compId;
        PreRemoveProcess pp = new PreRemoveProcess(this.input.getGraalHomePath(), this.input.getFileOperations(), this.feedback);
        while ((compId = this.input.nextParameter()) != null) {
            ComponentInfo info = this.input.getLocalRegistry().loadSingleComponent(compId.toLowerCase(), true);
            if (info == null) continue;
            pp.addComponentInfo(info);
        }
        pp.run();
        return 0;
    }
}

