/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.model.Verifier;

public final class CatalogContents
implements ComponentCatalog {
    private static final List<ComponentInfo> NONE = new ArrayList<ComponentInfo>();
    private final ComponentStorage storage;
    private final Feedback env;
    private final Map<String, List<ComponentInfo>> components = new HashMap<String, List<ComponentInfo>>();
    private final Version graalVersion;
    private final ComponentRegistry installed;
    private final Verifier verifier;
    private final Verifier capVerifier;
    private final ComponentCatalog.DownloadInterceptor downloadInterceptor;
    private boolean remoteEnabled = true;
    private boolean allowDistUpdate;

    public CatalogContents(Feedback env, ComponentStorage storage, ComponentRegistry inst) {
        this(env, storage, inst, inst.getGraalVersion());
    }

    public CatalogContents(Feedback env, ComponentStorage storage, ComponentRegistry inst, Version version) {
        this.storage = storage;
        this.env = env.withBundle(Feedback.class);
        this.verifier = new Verifier(env, inst, this);
        this.capVerifier = new Verifier(env, inst, this);
        this.graalVersion = version;
        this.installed = inst;
        this.verifier.ignoreExisting(true);
        this.verifier.setSilent(true);
        this.verifier.setCollectErrors(true);
        this.verifier.setVersionMatch(this.graalVersion.match(Version.Match.Type.SATISFIES));
        this.capVerifier.ignoreExisting(true);
        this.capVerifier.setSilent(true);
        this.capVerifier.setCollectErrors(true);
        this.capVerifier.setVersionMatch(Version.NO_VERSION.match(Version.Match.Type.GREATER));
        this.downloadInterceptor = storage instanceof ComponentCatalog.DownloadInterceptor ? (ComponentCatalog.DownloadInterceptor)((Object)storage) : (a, b) -> b;
    }

    public boolean compatibleVersion(ComponentInfo info) {
        if (this.verifier.validateRequirements(info).hasErrors()) {
            return false;
        }
        Version v = info.getVersion();
        Version gv = this.graalVersion;
        if (this.allowDistUpdate) {
            return gv.updatable().compareTo(v.updatable()) <= 0;
        }
        Version giv = gv.installVersion();
        Version civ = v.installVersion();
        return giv.equals(civ);
    }

    public void setRemoteEnabled(boolean remoteEnabled) {
        this.remoteEnabled = remoteEnabled;
    }

    @Override
    public boolean isRemoteEnabled() {
        return this.remoteEnabled;
    }

    private ComponentInfo compatibleComponent(List<ComponentInfo> cis, Version.Match versionSelect, boolean fallback) {
        if (cis == null) {
            return null;
        }
        ComponentInfo first = null;
        Version.Match vm = this.versionMatch(versionSelect, cis);
        boolean explicit = versionSelect != null && versionSelect.getType() != Version.Match.Type.MOSTRECENT;
        for (int i = cis.size() - 1; i >= 0; --i) {
            Version v;
            ComponentInfo ci = cis.get(i);
            if (first == null) {
                first = ci;
            }
            if (!vm.test(v = ci.getVersion()) || !explicit && !this.compatibleVersion(ci)) continue;
            return ci;
        }
        return fallback ? first : null;
    }

    public boolean isAllowDistUpdate() {
        return this.allowDistUpdate;
    }

    @Override
    public void setAllowDistUpdate(boolean allowDistUpdate) {
        this.allowDistUpdate = allowDistUpdate;
    }

    private Version.Match versionMatch(Version.Match m, List<ComponentInfo> infos) {
        Version v;
        if (m != null && m.getType() != Version.Match.Type.MOSTRECENT) {
            return CatalogContents.resolveMatch(m, infos, this.env);
        }
        Version version = v = m == null ? this.graalVersion : m.getVersion();
        if (v == Version.NO_VERSION) {
            v = this.graalVersion;
        }
        return v.match(this.allowDistUpdate ? Version.Match.Type.INSTALLABLE : Version.Match.Type.COMPATIBLE);
    }

    private static Version.Match resolveMatch(Version.Match vm, List<ComponentInfo> comps, Feedback f) {
        if (vm == null) {
            return null;
        }
        ArrayList<Version> vers = new ArrayList<Version>(comps.size());
        for (ComponentInfo ci : comps) {
            vers.add(ci.getVersion());
        }
        Collections.sort(vers);
        return vm.resolveWildcards(vers, f);
    }

    @Override
    public ComponentInfo findComponentMatch(String id, Version.Match vm, boolean exact) {
        if (id == null) {
            return null;
        }
        List<ComponentInfo> infos = this.doLoadComponents(id, false, exact);
        if (infos == null) {
            return null;
        }
        return this.compatibleComponent(infos, vm, false);
    }

    @Override
    public String shortenComponentId(ComponentInfo info) {
        String id = info.getId();
        if (id.startsWith("org.graalvm")) {
            int l = "org.graalvm".length();
            if (id.length() == l) {
                return "graalvm";
            }
            if (id.charAt(l) != '.' && id.length() > l + 1) {
                return id;
            }
            String shortId = id.substring(l + 1);
            if (info.getRemoteURL() == null) {
                return shortId;
            }
            try {
                List<ComponentInfo> regs = this.doLoadComponents(shortId, false, false);
                if (regs == null) {
                    return shortId;
                }
                boolean success = true;
                for (ComponentInfo reg : regs) {
                    if (reg.getId().equals(id)) continue;
                    success = false;
                    break;
                }
                if (success) {
                    return shortId;
                }
            }
            catch (FailedOperationException failedOperationException) {
                // empty catch block
            }
        }
        return id;
    }

    @Override
    public Collection<String> getComponentIDs() {
        try {
            return this.storage.listComponentIDs();
        }
        catch (IOException ex) {
            throw this.env.failure("REGISTRY_ReadingComponentList", ex, ex.getLocalizedMessage());
        }
    }

    private String findAbbreviatedId(String id) {
        String candidate = null;
        String lcid = id.toLowerCase(Locale.ENGLISH);
        String end = "." + lcid;
        Collection<String> ids = this.getComponentIDs();
        String ambiguous = null;
        for (String s : ids) {
            String lcs = s.toLowerCase(Locale.ENGLISH);
            if (lcs.equals(lcid)) {
                return s;
            }
            if (!lcs.endsWith(end)) continue;
            if (candidate != null) {
                ambiguous = s;
                continue;
            }
            candidate = s;
        }
        if (ambiguous != null) {
            throw this.env.failure("COMPONENT_AmbiguousIdFound", null, candidate, ambiguous);
        }
        return candidate;
    }

    @Override
    public Collection<ComponentInfo> loadComponents(String id, Version.Match vmatch, boolean filelist) {
        List<ComponentInfo> v = this.doLoadComponents(id, filelist, false);
        if (v == null) {
            return null;
        }
        if (vmatch.getType() == Version.Match.Type.MOSTRECENT) {
            ComponentInfo comp = this.compatibleComponent(v, this.versionMatch(vmatch, v), true);
            return comp == null ? Collections.emptyList() : Collections.singleton(comp);
        }
        Version.Match resolvedMatch = CatalogContents.resolveMatch(vmatch, v, this.env);
        ArrayList<ComponentInfo> versions = new ArrayList<ComponentInfo>(v);
        Iterator it = versions.iterator();
        while (it.hasNext()) {
            ComponentInfo cv = (ComponentInfo)it.next();
            if (resolvedMatch.test(cv.getVersion())) continue;
            it.remove();
        }
        return versions;
    }

    private List<ComponentInfo> doLoadComponents(String id, boolean filelist, boolean exact) {
        String fid;
        String string = fid = exact ? id : this.findAbbreviatedId(id);
        if (fid == null) {
            return null;
        }
        List<ComponentInfo> v = this.components.get(fid);
        if (v == null) {
            try {
                Set<ComponentInfo> infos = this.storage.loadComponentMetadata(fid);
                if (infos == null || infos.isEmpty()) {
                    this.components.put(fid, NONE);
                    return null;
                }
                ArrayList<ComponentInfo> versions = new ArrayList<ComponentInfo>(infos);
                Iterator it = versions.iterator();
                while (it.hasNext()) {
                    ComponentInfo ci = (ComponentInfo)it.next();
                    if (!this.capVerifier.validateRequirements(ci).hasErrors()) continue;
                    it.remove();
                }
                Collections.sort(versions, ComponentInfo.versionComparator());
                if (filelist) {
                    for (ComponentInfo ci : infos) {
                        this.storage.loadComponentFiles(ci);
                    }
                    this.components.put(fid, versions);
                }
                v = versions;
            }
            catch (NoSuchFileException ex) {
                return null;
            }
            catch (IOException ex) {
                throw this.env.failure("REGISTRY_ReadingComponentMetadata", ex, id, ex.getLocalizedMessage(), fid);
            }
        }
        if (v == NONE) {
            return null;
        }
        return v;
    }

    @Override
    public ComponentInfo findComponentMatch(String id, Version.Match vmatch, boolean localOnly, boolean exact) {
        ComponentInfo ci = this.installed.loadSingleComponent(id, false);
        if (ci != null && vmatch.test(ci.getVersion())) {
            return ci;
        }
        if (localOnly) {
            return null;
        }
        return this.findComponentMatch(id, vmatch, exact);
    }

    @Override
    public Set<String> findDependencies(ComponentInfo start, boolean closure, Boolean inst, Set<ComponentInfo> result) {
        return CatalogContents.findDependencies(start, closure, inst, result, this::findComponentMatch);
    }

    public static Set<String> findDependencies(ComponentInfo start, boolean closure, Boolean inst, Set<ComponentInfo> result, ComponentQuery q) {
        HashSet<String> missing = new HashSet<String>();
        HashSet<String> known = new HashSet<String>();
        ArrayDeque<ComponentInfo> buffer = new ArrayDeque<ComponentInfo>();
        buffer.add(start);
        boolean localOnly = Boolean.TRUE.equals(inst);
        while (!buffer.isEmpty()) {
            ComponentInfo c = (ComponentInfo)buffer.poll();
            Version.Match vm = c.getVersion().match(Version.Match.Type.COMPATIBLE);
            for (String d : c.getDependencies()) {
                if (!known.add(d)) continue;
                ComponentInfo res = q.findComponent(d, vm, localOnly, true);
                if (res == null) {
                    missing.add(d);
                    continue;
                }
                if (closure) {
                    buffer.add(res);
                }
                if (inst != null && inst.booleanValue() != res.isInstalled()) continue;
                result.add(res);
            }
        }
        return missing.isEmpty() ? null : missing;
    }

    @Override
    public ComponentCatalog.DownloadInterceptor getDownloadInterceptor() {
        return this.downloadInterceptor;
    }

    public static interface ComponentQuery {
        public ComponentInfo findComponent(String var1, Version.Match var2, boolean var3, boolean var4);
    }
}

