/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.os;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;

public class WindowsJVMWrapper {
    private final Feedback fb;
    private final FileOperations fileOps;
    private final Path installPath;
    private String mainClass;
    private String jvmBinary;
    private List<String> args = Collections.emptyList();
    private List<String> jvmArgs = Collections.emptyList();
    private String classpath = ".";

    public WindowsJVMWrapper(Feedback fb, FileOperations fops, Path installPath) {
        this.fb = fb.withBundle(WindowsJVMWrapper.class);
        this.fileOps = fops;
        this.installPath = installPath;
    }

    public WindowsJVMWrapper vm(String path, List<String> vmArgs) {
        this.jvmBinary = path;
        this.jvmArgs = vmArgs;
        return this;
    }

    public WindowsJVMWrapper mainClass(String mc) {
        this.mainClass = mc;
        return this;
    }

    public WindowsJVMWrapper classpath(String cp) {
        this.classpath = cp;
        return this;
    }

    public WindowsJVMWrapper args(List<String> a) {
        this.args = a;
        return this;
    }

    public int execute() throws IOException {
        assert (this.mainClass != null);
        assert (this.jvmBinary != null);
        Path copyPath = Files.createTempFile("gu_copy_", ".lst", new FileAttribute[0]);
        Path deletePath = Files.createTempFile("gu_delete", ".lst", new FileAttribute[0]);
        copyPath.toFile().deleteOnExit();
        deletePath.toFile().deleteOnExit();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Map<String, String> env = builder.environment();
        env.put("GU_POST_COPY_CONTENTS", copyPath.toAbsolutePath().toString());
        env.put("GU_POST_DELETE_LIST", deletePath.toAbsolutePath().toString());
        ArrayList<String> all = new ArrayList<String>(this.jvmArgs.size() + this.args.size() + 1);
        all.add(this.jvmBinary);
        if (this.classpath != null) {
            all.add("-classpath");
            all.add(this.classpath);
        }
        all.addAll(this.jvmArgs);
        all.add(this.mainClass);
        all.addAll(this.args);
        Process proc = builder.command(all).inheritIO().start();
        try {
            proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int exitValue = proc.exitValue();
        if (exitValue != 11) {
            return exitValue;
        }
        this.deleteRecursively(deletePath);
        this.copyContents(copyPath);
        return 0;
    }

    void copyContents(Path listFile) throws IOException {
        boolean first = true;
        for (String desc : Files.readAllLines(listFile)) {
            int i = desc.indexOf(124);
            if (i == -1) continue;
            Path p = SystemUtils.fromUserString(desc.substring(0, i));
            Path q = SystemUtils.fromUserString(desc.substring(i + 1));
            if (first) {
                this.fb.message("MSG_CopyNewFiles", new Object[0]);
                first = false;
            }
            SystemUtils.copySubtree(q, p);
            try {
                this.deleteFileRecursively(q);
            }
            catch (IOException ex) {
                this.fb.error("ERR_CannotDeletePath", ex, p, ex.getMessage());
            }
        }
    }

    void deleteRecursively(Path listFile) throws IOException {
        boolean first = true;
        for (String fn : Files.readAllLines(listFile)) {
            if (first) {
                this.fb.message("MSG_DeleteObsoleteFiles", new Object[0]);
                first = false;
            }
            Path p = SystemUtils.fromUserString(fn);
            try {
                this.deleteFileRecursively(p);
            }
            catch (IOException ex) {
                this.fb.error("ERR_CannotDeletePath", ex, p, ex.getMessage());
            }
        }
    }

    void deleteFileRecursively(Path rootPath) throws IOException {
        try (Stream<Path> paths = Files.walk(rootPath, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(p -> {
                if (!p.toAbsolutePath().startsWith(this.installPath)) {
                    return;
                }
                try {
                    this.fileOps.deleteFile((Path)p);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }
}

