/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.graalvm.component.installer.ComponentArchiveReader;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.remote.FileDownloader;

public class DirectoryCatalogProvider
implements ComponentStorage,
SoftwareChannel {
    private final Path directory;
    private final Feedback feedback;
    private boolean verifyJars = true;
    private boolean reportErrors = true;
    private Map<String, Set<ComponentInfo>> dirContents = null;

    public DirectoryCatalogProvider(Path directory, Feedback feedback) {
        this.directory = directory;
        this.feedback = feedback.withBundle(DirectoryCatalogProvider.class);
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public void setVerifyJars(boolean verifyJars) {
        this.verifyJars = verifyJars;
    }

    @Override
    public Set<String> listComponentIDs() throws IOException {
        this.initComponents();
        return this.dirContents.keySet();
    }

    @Override
    public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
        return ci;
    }

    @Override
    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        this.initComponents();
        return this.dirContents.get(id);
    }

    @Override
    public Map<String, String> loadGraalVersionInfo() {
        this.initComponents();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initComponents() {
        if (this.dirContents != null) {
            return;
        }
        this.dirContents = new HashMap<String, Set<ComponentInfo>>();
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(this.directory).forEach(p -> {
                block5: {
                    try {
                        ComponentInfo info = this.maybeCreateComponent((Path)p);
                        if (info != null) {
                            this.dirContents.computeIfAbsent(info.getId(), id -> new HashSet()).add(info);
                        }
                    }
                    catch (MetadataException ex) {
                        if (this.reportErrors) {
                            this.feedback.error("ERR_DirectoryComponentMetadata", ex, p.toString(), ex.getLocalizedMessage());
                        }
                    }
                    catch (IOException | FailedOperationException ex) {
                        if (!this.reportErrors) break block5;
                        this.feedback.error("ERR_DirectoryComponentError", ex, p.toString(), ex.getLocalizedMessage());
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo maybeCreateComponent(Path localFile) throws IOException {
        String serial;
        byte[] fileStart = null;
        if (Files.isRegularFile(localFile, new LinkOption[0])) {
            try (FileChannel ch = FileChannel.open(localFile, StandardOpenOption.READ);){
                ByteBuffer bb = ByteBuffer.allocate(8);
                ch.read(bb);
                fileStart = bb.array();
            }
            serial = SystemUtils.fingerPrint(SystemUtils.computeFileDigest(localFile, null));
        } else {
            fileStart = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            serial = SystemUtils.digestString(localFile.toString(), false);
        }
        try (Closeable ldr = null;){
            for (ComponentArchiveReader provider : ServiceLoader.load(ComponentArchiveReader.class)) {
                ldr = provider.createLoader(localFile, fileStart, serial, this.feedback, this.verifyJars);
                if (ldr == null) continue;
                ComponentInfo info = ldr.getComponentInfo();
                info.setRemoteURL(localFile.toUri().toURL());
                info.setOrigin(this.feedback.l10n("DIR_LocalFile", new Object[0]));
                ComponentInfo componentInfo = info;
                return componentInfo;
            }
        }
        return null;
    }

    @Override
    public ComponentStorage getStorage() throws IOException {
        return this;
    }

    @Override
    public FileDownloader configureDownloader(ComponentInfo info, FileDownloader dn) {
        return dn;
    }
}

