/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.management.AggregatedMemoryPoolBean;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.OptionsEncoder;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class LibGraalMBean
implements DynamicMBean {
    private static final String COMPOSITE_TAG = ".composite";
    private static final Map<Class<?>, OpenType<?>> PRIMITIVE_TO_OPENTYPE = new HashMap();
    private static volatile Factory factory;
    private final long isolate;
    private final long handle;

    LibGraalMBean(long isolate, long handle) {
        this.isolate = isolate;
        this.handle = handle;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeList attributes = this.getAttributes(new String[]{attribute});
        return attributes.isEmpty() ? null : ((Attribute)attributes.get(0)).getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeList list = new AttributeList();
        list.add(attribute);
        this.setAttributes(list);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            byte[] rawData = JMXToLibGraalCalls.getAttributes(scope.getIsolateThreadAddress(), this.handle, attributes);
            AttributeList attributeList = LibGraalMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Object item : attributes) {
                Attribute attribute = (Attribute)item;
                map.put(attribute.getName(), attribute.getValue());
            }
            byte[] rawData = OptionsEncoder.encode(map);
            rawData = JMXToLibGraalCalls.setAttributes(scope.getIsolateThreadAddress(), this.handle, rawData);
            AttributeList attributeList = LibGraalMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    private static AttributeList rawToAttributeList(byte[] rawData) {
        AttributeList res = new AttributeList();
        Map map = OptionsEncoder.decode((byte[])rawData);
        PushBackIterator<Map.Entry<String, Object>> it = new PushBackIterator<Map.Entry<String, Object>>(map.entrySet().iterator());
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String attrName = (String)e.getKey();
            Object attrValue = e.getValue();
            if (LibGraalMBean.isComposite(attrName)) {
                try {
                    attrValue = LibGraalMBean.readComposite(attrName, (String)attrValue, it);
                }
                catch (OpenDataException ex) {
                    attrValue = null;
                    TTY.printf((String)"WARNING: Cannot read composite attribute %s due to %s", (Object[])new Object[]{attrName, ex.getMessage()});
                }
                attrName = LibGraalMBean.compositeAttrName(attrName);
            }
            res.add(new Attribute(attrName, attrValue));
        }
        return res;
    }

    private static boolean isComposite(String name) {
        return name.endsWith(COMPOSITE_TAG);
    }

    private static String compositeAttrName(String name) {
        return name.substring(0, name.length() - COMPOSITE_TAG.length());
    }

    private static CompositeData readComposite(String scope, String typeName, PushBackIterator<Map.Entry<String, Object>> it) throws OpenDataException {
        String prefix = scope + '.';
        ArrayList<String> attrNames = new ArrayList<String>();
        ArrayList<Object> attrValues = new ArrayList<Object>();
        ArrayList attrTypes = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String attrName = e.getKey();
            if (!attrName.startsWith(prefix)) {
                it.pushBack(e);
                break;
            }
            Object attrValue = e.getValue();
            if (LibGraalMBean.isComposite(attrName)) {
                attrValue = LibGraalMBean.readComposite(attrName, (String)attrValue, it);
                attrName = LibGraalMBean.compositeAttrName(attrName);
            }
            attrName = attrName.substring(prefix.length());
            attrNames.add(attrName);
            attrValues.add(attrValue);
            attrTypes.add(LibGraalMBean.getOpenType(attrValue));
        }
        String[] attrNamesArray = attrNames.toArray(new String[attrNames.size()]);
        CompositeType type = new CompositeType(typeName, typeName, attrNamesArray, attrNamesArray, attrTypes.toArray(new OpenType[attrTypes.size()]));
        return new CompositeDataSupport(type, attrNamesArray, attrValues.toArray(new Object[attrValues.size()]));
    }

    private static OpenType<?> getOpenType(Object value) {
        if (value instanceof CompositeData) {
            return ((CompositeData)value).getCompositeType();
        }
        Class clz = value == null ? String.class : value.getClass();
        OpenType<?> openType = PRIMITIVE_TO_OPENTYPE.get(clz);
        if (openType == null) {
            throw new IllegalArgumentException(clz.getName());
        }
        return openType;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    paramsMap.put(Integer.toString(i), params[i]);
                }
            }
            byte[] rawData = OptionsEncoder.encode(paramsMap);
            rawData = JMXToLibGraalCalls.invoke(scope.getIsolateThreadAddress(), this.handle, actionName, rawData, signature);
            if (rawData == null) {
                throw new MBeanException(null);
            }
            AttributeList attributesList = LibGraalMBean.rawToAttributeList(rawData);
            Object object = attributesList.isEmpty() ? null : ((Attribute)attributesList.get(0)).getValue();
            return object;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            byte[] rawData = JMXToLibGraalCalls.getMBeanInfo(scope.getIsolateThreadAddress(), this.handle);
            Map map = OptionsEncoder.decode((byte[])rawData);
            String className = null;
            String description = null;
            ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
            PushBackIterator<Map.Entry<String, Object>> it = new PushBackIterator<Map.Entry<String, Object>>(map.entrySet().iterator());
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (key.equals("bean.class")) {
                    className = (String)entry.getValue();
                    continue;
                }
                if (key.equals("bean.description")) {
                    description = (String)entry.getValue();
                    continue;
                }
                if (key.startsWith("attr.")) {
                    String attrName = (String)entry.getValue();
                    if (!key.equals("attr." + attrName + ".name")) {
                        throw new IllegalStateException("Invalid order of attribute properties");
                    }
                    MBeanAttributeInfo attr = LibGraalMBean.createAttributeInfo(attrName, it);
                    attributes.add(attr);
                    continue;
                }
                if (!key.startsWith("op.")) continue;
                int opId = (Integer)entry.getValue();
                if (!key.equals("op." + opId + ".id")) {
                    throw new IllegalStateException("Invalid order of operation properties");
                }
                MBeanOperationInfo op = LibGraalMBean.createOperationInfo(opId, it);
                operations.add(op);
            }
            Objects.requireNonNull(className, "ClassName must be non null.");
            Objects.requireNonNull(description, "Description must be non null.");
            MBeanInfo mBeanInfo = new MBeanInfo(className, description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
            return mBeanInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Factory getFactory() {
        Factory res = factory;
        if (res != null) return res;
        Class<LibGraalMBean> clazz = LibGraalMBean.class;
        synchronized (LibGraalMBean.class) {
            res = factory;
            if (res != null) return res;
            try {
                res = new Factory();
                res.start();
                factory = res;
            }
            catch (LinkageError e) {
                Throwable cause = LibGraalMBean.findCause(e);
                throw LibGraalMBean.sthrow(RuntimeException.class, cause);
            }
            return res;
        }
    }

    private static Throwable findCause(Throwable e) {
        Throwable current = e;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        return current;
    }

    private static <T extends Throwable> T sthrow(Class<T> exceptionClass, Throwable exception) throws T {
        throw exception;
    }

    private static MBeanAttributeInfo createAttributeInfo(String attrName, PushBackIterator<Map.Entry<String, Object>> it) {
        String attrType = null;
        String attrDescription = null;
        boolean isReadable = false;
        boolean isWritable = false;
        boolean isIs = false;
        String prefix = "attr." + attrName + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    attrType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    attrDescription = (String)entry.getValue();
                    continue block14;
                }
                case "r": {
                    isReadable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "w": {
                    isWritable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "i": {
                    isIs = (Boolean)entry.getValue();
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (attrType == null) {
            throw new IllegalStateException("Attribute type must be given.");
        }
        return new MBeanAttributeInfo(attrName, attrType, attrDescription, isReadable, isWritable, isIs);
    }

    private static MBeanOperationInfo createOperationInfo(int opId, PushBackIterator<Map.Entry<String, Object>> it) {
        String opName = null;
        String opType = null;
        String opDescription = null;
        int opImpact = 0;
        ArrayList<MBeanParameterInfo> params = new ArrayList<MBeanParameterInfo>();
        String prefix = "op." + opId + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            int nextDotIndex = key.indexOf(46, prefix.length());
            nextDotIndex = nextDotIndex < 0 ? key.length() : nextDotIndex;
            switch (propertyName = key.substring(prefix.length(), nextDotIndex)) {
                case "name": {
                    opName = (String)entry.getValue();
                    continue block14;
                }
                case "type": {
                    opType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    opDescription = (String)entry.getValue();
                    continue block14;
                }
                case "i": {
                    opImpact = (Integer)entry.getValue();
                    continue block14;
                }
                case "arg": {
                    String paramName = (String)entry.getValue();
                    if (!key.equals(prefix + "arg." + paramName + ".name")) {
                        throw new IllegalStateException("Invalid order of parameter properties");
                    }
                    MBeanParameterInfo param = LibGraalMBean.createParameterInfo(prefix, paramName, it);
                    params.add(param);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (opName == null) {
            throw new IllegalStateException("Operation name must be given.");
        }
        if (opType == null) {
            throw new IllegalStateException("Operation return type must be given.");
        }
        return new MBeanOperationInfo(opName, opDescription, params.toArray(new MBeanParameterInfo[params.size()]), opType, opImpact);
    }

    private static MBeanParameterInfo createParameterInfo(String owner, String paramName, PushBackIterator<Map.Entry<String, Object>> it) {
        String paramType = null;
        String paramDescription = null;
        String prefix = owner + "arg." + paramName + ".";
        block8: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    paramType = (String)entry.getValue();
                    continue block8;
                }
                case "description": {
                    paramDescription = (String)entry.getValue();
                    continue block8;
                }
            }
            throw new IllegalStateException("Unkown parameter property: " + propertyName);
        }
        if (paramType == null) {
            throw new IllegalStateException("Parameter type must be given.");
        }
        return new MBeanParameterInfo(paramName, paramType, paramDescription);
    }

    static {
        PRIMITIVE_TO_OPENTYPE.put(Void.class, SimpleType.VOID);
        PRIMITIVE_TO_OPENTYPE.put(Boolean.class, SimpleType.BOOLEAN);
        PRIMITIVE_TO_OPENTYPE.put(Byte.class, SimpleType.BYTE);
        PRIMITIVE_TO_OPENTYPE.put(Character.class, SimpleType.CHARACTER);
        PRIMITIVE_TO_OPENTYPE.put(Short.class, SimpleType.SHORT);
        PRIMITIVE_TO_OPENTYPE.put(Integer.class, SimpleType.INTEGER);
        PRIMITIVE_TO_OPENTYPE.put(Float.class, SimpleType.FLOAT);
        PRIMITIVE_TO_OPENTYPE.put(Long.class, SimpleType.LONG);
        PRIMITIVE_TO_OPENTYPE.put(Double.class, SimpleType.DOUBLE);
        PRIMITIVE_TO_OPENTYPE.put(String.class, SimpleType.STRING);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class Factory
    extends Thread {
        private static final String DOMAIN_JAVA_LANG = Object.class.getPackage().getName();
        private static final String TYPE_MEMORY_POOL = "MemoryPool";
        private static final String ATTR_TYPE = "type";
        private static final int POLL_INTERVAL_MS = 2000;
        private MBeanServer platformMBeanServer;
        private volatile AggregatedMemoryPoolBean aggregatedMemoryPoolBean;
        private final Set<Long> pendingIsolates = new LinkedHashSet<Long>();

        private Factory() {
            super("Libgraal MBean Registration");
            this.setPriority(1);
            this.setDaemon(true);
            LibGraal.registerNativeMethods(JMXToLibGraalCalls.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (true) {
                        Factory factory = this;
                        synchronized (factory) {
                            while (this.pendingIsolates.isEmpty()) {
                                this.wait();
                            }
                            try {
                                this.poll();
                            }
                            catch (NoClassDefFoundError | SecurityException | UnsatisfiedLinkError | UnsupportedOperationException e) {
                                break block7;
                            }
                        }
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace(TTY.out);
                    continue;
                }
                break;
            }
        }

        synchronized void signalRegistrationRequest(long isolate) {
            this.pendingIsolates.add(isolate);
            this.notify();
        }

        synchronized void unregister(long isolate, String[] objectIds) {
            this.pendingIsolates.remove(isolate);
            MBeanServer mBeanServer = this.findMBeanServer();
            if (mBeanServer == null) {
                return;
            }
            for (String objectId : objectIds) {
                try {
                    ObjectName objectName = new ObjectName(objectId);
                    if (this.aggregatedMemoryPoolBean != null && Factory.parseMemoryPoolObjectName(objectName) != null) {
                        this.aggregatedMemoryPoolBean.removeDelegate(objectName);
                    }
                    if (!mBeanServer.isRegistered(objectName)) continue;
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
                    e.printStackTrace(TTY.out);
                }
            }
        }

        private boolean poll() {
            assert (Thread.holdsLock(this));
            MBeanServer mBeanServer = this.findMBeanServer();
            if (mBeanServer != null) {
                return this.process();
            }
            return false;
        }

        private MBeanServer findMBeanServer() {
            ArrayList<MBeanServer> servers;
            assert (Thread.holdsLock(this));
            if (this.platformMBeanServer == null && !(servers = MBeanServerFactory.findMBeanServer(null)).isEmpty()) {
                this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            return this.platformMBeanServer;
        }

        private boolean process() {
            Iterator<Long> iter = this.pendingIsolates.iterator();
            while (iter.hasNext()) {
                long isolate = iter.next();
                iter.remove();
                try (LibGraalScope scope = new LibGraalScope(isolate);){
                    long isolateThread = scope.getIsolateThreadAddress();
                    long[] handles = JMXToLibGraalCalls.pollRegistrations(isolateThread);
                    if (handles.length <= 0) continue;
                    for (long handle : handles) {
                        LibGraalMBean bean = new LibGraalMBean(isolate, handle);
                        String name = JMXToLibGraalCalls.getObjectName(isolateThread, handle);
                        try {
                            ObjectName objectName = new ObjectName(name);
                            Hashtable<String, String> props = Factory.parseMemoryPoolObjectName(objectName);
                            if (props != null) {
                                if (this.aggregatedMemoryPoolBean == null) {
                                    props.remove("isolate");
                                    ObjectName aggregatedMemoryPoolObjectName = new ObjectName(DOMAIN_JAVA_LANG, props);
                                    this.aggregatedMemoryPoolBean = new AggregatedMemoryPoolBean(aggregatedMemoryPoolObjectName, bean, objectName);
                                    this.platformMBeanServer.registerMBean(this.aggregatedMemoryPoolBean, aggregatedMemoryPoolObjectName);
                                } else {
                                    this.aggregatedMemoryPoolBean.addDelegate(bean, objectName);
                                }
                            }
                            this.platformMBeanServer.registerMBean(bean, objectName);
                        }
                        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                            e.printStackTrace(TTY.out);
                        }
                    }
                }
            }
            return true;
        }

        private static Hashtable<String, String> parseMemoryPoolObjectName(ObjectName objectName) {
            Hashtable<String, String> props = objectName.getKeyPropertyList();
            if (DOMAIN_JAVA_LANG.equals(objectName.getDomain()) && TYPE_MEMORY_POOL.equals(props.get(ATTR_TYPE))) {
                return props;
            }
            return null;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class PushBackIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private T pushBack;

        PushBackIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.pushBack != null || this.delegate.hasNext();
        }

        @Override
        public T next() {
            if (this.pushBack != null) {
                T res = this.pushBack;
                this.pushBack = null;
                return res;
            }
            return this.delegate.next();
        }

        void pushBack(T e) {
            if (this.pushBack != null) {
                throw new IllegalStateException("Push back element already exists.");
            }
            this.pushBack = e;
        }
    }
}

