/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.HotSpotGraalRuntimeMBean;
import org.graalvm.compiler.hotspot.management.libgraal.MBeanProxy;

public final class LibGraalHotSpotGraalManagement
extends MBeanProxy<HotSpotGraalRuntimeMBean>
implements HotSpotGraalManagementRegistration {
    public void initialize(HotSpotGraalRuntime runtime, GraalHotSpotVMConfig config) {
        if (!LibGraalHotSpotGraalManagement.initializeJNI(config, runtime)) {
            return;
        }
        HotSpotGraalRuntimeMBean mbean = (HotSpotGraalRuntimeMBean)this.getBean();
        if (mbean == null) {
            if (runtime.getManagement() != this) {
                throw new IllegalArgumentException("Cannot initialize a second management object for runtime " + runtime.getName());
            }
            try {
                String beanName = LibGraalHotSpotGraalManagement.nameWithIsolateId("org.graalvm.compiler.hotspot:type=" + runtime.getName().replace(':', '_'));
                ObjectName objectName = new ObjectName(beanName);
                mbean = new HotSpotGraalRuntimeMBean(objectName, runtime);
                this.initialize(mbean, beanName, objectName);
                LibGraalHotSpotGraalManagement.enqueueForRegistrationAndNotify(this, runtime);
            }
            catch (MalformedObjectNameException err) {
                err.printStackTrace(TTY.out);
            }
        } else if (mbean.getRuntime() != runtime) {
            throw new IllegalArgumentException("Cannot change the runtime a management interface is associated with");
        }
    }

    public ObjectName poll(boolean sync) {
        return this.poll();
    }

    static final class Factory
    implements Supplier<HotSpotGraalManagementRegistration> {
        Factory() {
        }

        @Override
        public HotSpotGraalManagementRegistration get() {
            return new LibGraalHotSpotGraalManagement();
        }
    }
}

