/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common.processor;

public class Option {
    static final Option[] options = new Option[]{Option.option("TruffleCompileOnly").type("String").category("INTERNAL").def("PolyglotCompilerOptions.CompileOnly.getDefaultValue()").help("Restrict compilation to comma-separated list of includes (or excludes prefixed with tilde).", "EBNF format of argument value:  CompileOnly = Element, { ',', Element } ;").deprecatedBy("CompileOnly"), Option.option("TruffleCompilation").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.Compilation.getDefaultValue()").help("Enable or disable truffle compilation.").deprecatedBy("Compilation"), Option.option("TruffleCompileImmediately").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompileImmediately.getDefaultValue()").help("Compile immediately to test truffle compiler").deprecatedBy("CompileImmediately"), Option.option("TruffleCompilationThreshold").type("Integer").category("USER").def("PolyglotCompilerOptions.CompilationThreshold.getDefaultValue()").help("Compile call target when call count exceeds this threshold.").deprecatedBy("CompilationThreshold"), Option.option("TruffleFirstTierCompilationThreshold").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.FirstTierCompilationThreshold.getDefaultValue()").help("Compile call target in the first tier when call count exceeds this threshold.").deprecatedBy("FirstTierCompilationThreshold"), Option.option("TruffleFirstTierMinInvokeThreshold").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.FirstTierMinInvokeThreshold.getDefaultValue()").help("Minimum number of calls before a call target is compiled in the first tier.").deprecatedBy("FirstTierMinInvokeThreshold"), Option.option("TruffleMinInvokeThreshold").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.MinInvokeThreshold.getDefaultValue()").help("Minimum number of calls before a call target is compiled").deprecatedBy("MinInvokeThreshold"), Option.option("TruffleInvalidationReprofileCount").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.InvalidationReprofileCount.getDefaultValue()").help("Delay compilation after an invalidation to allow for reprofiling").deprecatedBy("InvalidationReprofileCount"), Option.option("TruffleReplaceReprofileCount").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.ReplaceReprofileCount.getDefaultValue()").help("Delay compilation after a node replacement").deprecatedBy("ReplaceReprofileCount"), Option.option("TruffleFunctionInlining").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.Inlining.getDefaultValue()").help("Enable automatic inlining of call targets").deprecatedBy("Inlining"), Option.option("TruffleLanguageAgnosticInlining").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.LanguageAgnosticInlining.getDefaultValue()").help("Use language-agnostic inlining (overrides the TruffleFunctionInlining setting, option is experimental).").deprecatedBy("LanguageAgnosticInlining"), Option.option("TruffleInliningMaxCallerSize").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.InliningNodeBudget.getDefaultValue()").help("Stop inlining if caller's cumulative tree size would exceed this limit").deprecatedBy("InliningNodeBudget"), Option.option("TruffleMaximumRecursiveInlining").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.InliningRecursionDepth.getDefaultValue()").help("Maximum level of recursive inlining").deprecatedBy("InliningRecursionDepth"), Option.option("TruffleSplitting").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.Splitting.getDefaultValue()").help("Enable call target splitting").deprecatedBy("Splitting"), Option.option("TruffleOSR").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.OSR.getDefaultValue()").help("Enable on stack replacement for Truffle loops.").deprecatedBy("OSR"), Option.option("TruffleOSRCompilationThreshold").type("Integer").category("INTERNAL").def("PolyglotCompilerOptions.OSRCompilationThreshold.getDefaultValue()").help("Number of loop iterations until on-stack-replacement compilation is triggered.").deprecatedBy("OSRCompilationThreshold"), Option.option("TruffleSplittingMaxCalleeSize").type("Integer").category("INTERNAL").def("PolyglotCompilerOptions.SplittingMaxCalleeSize.getDefaultValue()").help("Disable call target splitting if tree size exceeds this limit").deprecatedBy("SplittingMaxCalleeSize"), Option.option("TruffleSplittingGrowthLimit").type("Double").category("INTERNAL").def("PolyglotCompilerOptions.SplittingGrowthLimit.getDefaultValue()").help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count").deprecatedBy("SplittingGrowthLimit"), Option.option("TruffleSplittingMaxNumberOfSplitNodes").type("Integer").category("INTERNAL").def("PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes.getDefaultValue()").help("Disable call target splitting if number of nodes created by splitting exceeds this limit").deprecatedBy("SplittingMaxNumberOfSplitNodes"), Option.option("TruffleSplittingMaxPropagationDepth").type("Integer").category("INTERNAL").def("PolyglotCompilerOptions.SplittingMaxPropagationDepth.getDefaultValue()").help("Propagate info about a polymorphic specialize through maximum this many call targets").deprecatedBy("SplittingMaxPropagationDepth"), Option.option("TruffleTraceSplittingSummary").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.TraceSplittingSummary.getDefaultValue()").help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").deprecatedBy("TraceSplittingSummary"), Option.option("TruffleSplittingTraceEvents").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.SplittingTraceEvents.getDefaultValue()").help("Trace details of splitting events and decisions.").deprecatedBy("SplittingTraceEvents"), Option.option("TruffleSplittingDumpDecisions").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.SplittingDumpDecisions.getDefaultValue()").help("Dumps to IGV information on polymorphic events").deprecatedBy("SplittingDumpDecisions"), Option.option("TruffleSplittingAllowForcedSplits").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.SplittingAllowForcedSplits.getDefaultValue()").help("Should forced splits be allowed.").deprecatedBy("SplittingAllowForcedSplits"), Option.option("TruffleBackgroundCompilation").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.BackgroundCompilation.getDefaultValue()").help("Enable asynchronous truffle compilation in background thread").deprecatedBy("BackgroundCompilation"), Option.option("TruffleCompilerThreads").type("Integer").category("EXPERT").def("PolyglotCompilerOptions.CompilerThreads.getDefaultValue()").help("Manually set the number of compiler threads").deprecatedBy("CompilerThreads"), Option.option("TruffleReturnTypeSpeculation").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.ReturnTypeSpeculation.getDefaultValue()").deprecatedBy("ReturnTypeSpeculation"), Option.option("TruffleArgumentTypeSpeculation").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.ArgumentTypeSpeculation.getDefaultValue()").deprecatedBy("ArgumentTypeSpeculation"), Option.option("TraceTruffleCompilation").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceCompilation.getDefaultValue()").help("Print information for compilation results").deprecatedBy("TraceCompilation"), Option.option("TraceTruffleCompilationDetails").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceCompilationDetails.getDefaultValue()").help("Print information for compilation queuing").deprecatedBy("TraceCompilationDetails"), Option.option("TraceTruffleCompilationPolymorphism").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceCompilationPolymorphism.getDefaultValue()").help("Print all polymorphic and generic nodes after each compilation").deprecatedBy("TraceCompilationPolymorphism"), Option.option("TraceTruffleCompilationAST").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceCompilationAST.getDefaultValue()").help("Print the entire AST after each compilation").deprecatedBy("TraceCompilationAST"), Option.option("TraceTruffleCompilationCallTree").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceCompilationCallTree.getDefaultValue()").help("Print the inlined call tree for each compiled method").deprecatedBy("TraceCompilationCallTree"), Option.option("TruffleCompilationExceptionsAreFatal").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompilationExceptionsAreFatal.getDefaultValue()").help("Treat compilation exceptions as fatal exceptions that will exit the application").deprecatedBy("CompilationExceptionsAreFatal"), Option.option("TrufflePerformanceWarningsAreFatal").type("Boolean").category("INTERNAL").def("false").help("Treat performance warnings as fatal occurrences that will exit the applications").deprecatedBy("PerformanceWarningsAreFatal"), Option.option("TruffleCompilationExceptionsArePrinted").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompilationExceptionsArePrinted.getDefaultValue()").help("Prints the exception stack trace for compilation exceptions").deprecatedBy("CompilationExceptionsArePrinted"), Option.option("TruffleCompilationExceptionsAreThrown").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompilationExceptionsAreThrown.getDefaultValue()").help("Treat compilation exceptions as thrown runtime exceptions").deprecatedBy("CompilationExceptionsAreThrown"), Option.option("TraceTruffleInlining").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceInlining.getDefaultValue()").help("Print information for inlining for each compilation.").deprecatedBy("TraceInlining"), Option.option("TraceTruffleSplitting").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceSplitting.getDefaultValue()").help("Print information for each splitted call site.").deprecatedBy("TraceSplitting"), Option.option("TraceTruffleAssumptions").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceAssumptions.getDefaultValue()").help("Print stack trace on assumption invalidation").deprecatedBy("TraceAssumptions"), Option.option("TraceTruffleStackTraceLimit").type("Integer").category("INTERNAL").def("PolyglotCompilerOptions.TraceStackTraceLimit.getDefaultValue()").help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions").deprecatedBy("TraceStackTraceLimit"), Option.option("TruffleCompilationStatistics").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompilationStatistics.getDefaultValue()").help("Print Truffle compilation statistics at the end of a run.").deprecatedBy("CompilationStatistics"), Option.option("TruffleCompilationStatisticDetails").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.CompilationStatisticDetails.getDefaultValue()").help("Print additional more verbose Truffle compilation statistics at the end of a run.").deprecatedBy("CompilationStatisticDetails"), Option.option("TruffleProfilingEnabled").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.Profiling.getDefaultValue()").help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles.").deprecatedBy("Profiling"), Option.option("TraceTruffleTransferToInterpreter").type("Boolean").category("INTERNAL").def("PolyglotCompilerOptions.TraceTransferToInterpreter.getDefaultValue()").help("Print stack trace on transfer to interpreter.").deprecatedBy("TraceTransferToInterpreter"), Option.option("TruffleMultiTier").type("Boolean").category("EXPERT").def("PolyglotCompilerOptions.MultiTier.getDefaultValue()").help("Whether to use multiple Truffle compilation tiers by default.").deprecatedBy("MultiTier"), Option.option("PrintTruffleTrees").type("Boolean").category("INTERNAL").def("true").help("Enable dumping Truffle ASTs to the IdealGraphVisualizer.").deprecated("Deprecated with no replacement.")};
    String name;
    String category;
    String type;
    String defaultValue;
    String[] help = new String[]{""};
    String deprecationMessage;

    Option name(String value) {
        this.name = value;
        return this;
    }

    Option type(String value) {
        this.type = value;
        return this;
    }

    Option category(String value) {
        this.category = value;
        return this;
    }

    Option def(String value) {
        this.defaultValue = value;
        return this;
    }

    Option help(String ... lines) {
        this.help = lines;
        return this;
    }

    Option deprecatedBy(String replacement) {
        this.deprecationMessage = "Deprecated by {@link PolyglotCompilerOptions#" + replacement + "}.";
        return this;
    }

    Option deprecated(String message) {
        this.deprecationMessage = message;
        return this;
    }

    static Option option(String name) {
        return new Option().name(name);
    }
}

