/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common.processor;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.graalvm.compiler.options.processor.OptionProcessor;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.truffle.common.processor.Option;

@SupportedAnnotationTypes(value={"org.graalvm.compiler.truffle.common.SharedTruffleOptions"})
public class SharedTruffleOptionsProcessor
extends AbstractProcessor {
    private static final String SHARED_TRUFFLE_OPTIONS_CLASS_NAME = "org.graalvm.compiler.truffle.common.SharedTruffleOptions";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        TypeElement sharedTruffleOptionsTypeElement = this.getTypeElement(SHARED_TRUFFLE_OPTIONS_CLASS_NAME);
        TypeMirror sharedTruffleOptionsTypeMirror = sharedTruffleOptionsTypeElement.asType();
        for (Element element : roundEnv.getElementsAnnotatedWith(sharedTruffleOptionsTypeElement)) {
            Element pkgElement = element.getEnclosingElement();
            if (pkgElement.getKind() != ElementKind.PACKAGE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Truffle options holder must be a top level class", element);
                break;
            }
            TypeElement topDeclaringType = (TypeElement)element;
            AnnotationMirror annotation = this.getAnnotation(topDeclaringType, sharedTruffleOptionsTypeMirror);
            Boolean isRuntime = SharedTruffleOptionsProcessor.getAnnotationValue(annotation, "runtime", Boolean.class);
            String className = SharedTruffleOptionsProcessor.getAnnotationValue(annotation, "name", String.class);
            String pkg = ((PackageElement)pkgElement).getQualifiedName().toString();
            String optionKeyClassName = isRuntime != false ? "org.graalvm.options.OptionKey" : "org.graalvm.compiler.options.OptionKey";
            OptionProcessor.OptionsInfo info = new OptionProcessor.OptionsInfo(pkg, className);
            info.originatingElements.add(topDeclaringType);
            Filer filer = this.processingEnv.getFiler();
            PrintWriter out = OptionProcessor.createSourceFile(pkg, className, filer, topDeclaringType);
            try {
                out.println("// CheckStyle: stop header check");
                out.println("// CheckStyle: stop line length check");
                out.println("package " + pkg + ";");
                out.println("");
                out.println("import " + optionKeyClassName + ";");
                out.println("import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;");
                if (isRuntime.booleanValue()) {
                    out.println("import com.oracle.truffle.api.Option;");
                    out.println("import org.graalvm.options.OptionCategory;");
                    out.println("import org.graalvm.options.OptionType;");
                }
                out.println("");
                out.println("/**");
                out.println(" * Options shared between the Truffle runtime and compiler.");
                out.println(" *");
                out.println(" * To modify these options, edit " + Option.class.getName());
                out.println(" * and re-build. For Eclipse, this means restarting the IDE given");
                out.println(" * that an annotation processor is not reloaded when the jar");
                out.println(" * containing the annotation processor is updated.");
                out.println(" *");
                out.println(" * GENERATED CONTENT - DO NOT EDIT");
                out.println(" * GeneratedBy: " + this.getClass().getName());
                out.println(" * SpecifiedBy: " + Option.class.getName());
                out.println(" */");
                out.println("public abstract class " + className + " {");
                for (Option option : Option.options) {
                    String defaultValue;
                    if (isRuntime.booleanValue()) {
                        if (option.deprecationMessage != null) {
                            out.printf("    /**\n", new Object[0]);
                            out.printf("     * %s\n", option.deprecationMessage);
                            out.printf("     */\n", new Object[0]);
                        }
                        String help = option.help == null ? "" : (option.help.length > 1 ? option.help[0] + "%n" + Arrays.asList(option.help).subList(1, option.help.length).stream().map(s -> "%n\" +" + System.lineSeparator() + "                   \"" + s).collect(Collectors.joining()) : option.help[0]);
                        defaultValue = option.defaultValue + ", OptionType.defaultType(" + option.type + ".class)";
                        out.printf("    @Option(help = \"%s\", category = OptionCategory.%s)\n", help, option.category);
                    } else {
                        defaultValue = option.defaultValue;
                        String optionType = option.category.equals("INTERNAL") ? "Debug" : option.category.charAt(0) + option.category.substring(1).toLowerCase();
                        out.printf("    /**\n", new Object[0]);
                        for (int i = 0; i < option.help.length; ++i) {
                            String line = option.help[i];
                            if (i == option.help.length - 1) {
                                out.printf("     * %s%s\n", line, line.endsWith(".") ? "" : ".");
                                out.printf("     *\n", new Object[0]);
                                continue;
                            }
                            out.printf("     * %s\n", line);
                        }
                        out.printf("     * OptionType: %s\n", optionType);
                        if (option.deprecationMessage != null) {
                            out.printf("     *\n", new Object[0]);
                            out.printf("     * %s\n", option.deprecationMessage);
                        }
                        out.printf("     */\n", new Object[0]);
                        String help = option.help[0];
                        ArrayList<String> extraHelp = option.help.length > 1 ? Arrays.asList(option.help).subList(1, option.help.length) : new ArrayList<String>();
                        info.options.add(new OptionProcessor.OptionInfo(option.name, optionType, help, extraHelp, option.type, pkg + '.' + className, option.name, true));
                    }
                    out.printf("    static final OptionKey<%s> %s = new OptionKey<>(%s);\n", option.type, option.name, defaultValue);
                    out.println();
                }
                out.println("}");
                if (info.options.isEmpty()) continue;
                OptionProcessor.createOptionsDescriptorsFile(this.processingEnv, info);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
        return true;
    }
}

