/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.graalvm.visualvm.modules.appui.welcome.Constants;
import org.graalvm.visualvm.modules.appui.welcome.Utils;
import org.graalvm.visualvm.modules.appui.welcome.WebLink;

class ContentsPanel
extends JPanel
implements Constants {
    public ContentsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridLayout(4, 2, 0, 0));
        this.addLink("Link1", true, false, false);
        this.addLink("Link2", false, false, true);
        this.addLink("Link3", true, false, false);
        this.addLink("Link4", false, false, true);
        this.addLink("Link5", true, false, false);
        this.addLink("Link6", false, false, true);
        this.addLink("Link7", true, true, false);
        this.addLink("Link8", false, true, true);
        this.setBackground(Utils.getColor("ContentBackgroundColor"));
    }

    private void addLink(String resourceKey, boolean includeSource, boolean drawBottom, boolean drawRight) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)new WebLink(resourceKey, includeSource), "Center");
        panel.setBorder(new MyBorder(drawBottom, drawRight));
        this.add(panel);
    }

    private static class MyBorder
    implements Border {
        private static final Color COLOR = Utils.getColor("BorderColor");
        private boolean drawBottom;
        private boolean drawRight;

        public MyBorder(boolean drawBottom, boolean drawRight) {
            this.drawBottom = drawBottom;
            this.drawRight = drawRight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(COLOR);
            g.drawLine(x, y, x + width, y);
            g.drawLine(x, y, x, y + height);
            if (this.drawRight) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
            if (this.drawBottom) {
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(8, 8, 8, 8);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

