/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.common.AttachSettings;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.profiler.actions.ResetResultsAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.graalvm.visualvm.lib.profiler.v2.Bundle;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeature;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeatures;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerPlugins;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSessions;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerWindow;
import org.graalvm.visualvm.lib.profiler.v2.SessionStorage;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ProfilerSession {
    private static ProfilerSession CURRENT_SESSION;
    private static final Object CURRENT_SESSION_LOCK;
    private Lookup context;
    private final Profiler profiler;
    private ProfilerWindow window;
    private ProfilingSettings profilingSettings;
    private AttachSettings attachSettings;
    private boolean isAttach;
    private SessionStorage storage;
    private final Set<ProfilingStateListener> profilingStateListeners = new HashSet<ProfilingStateListener>();
    private ProfilerFeatures features;
    private ProfilerPlugins plugins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerSession currentSession() {
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            return CURRENT_SESSION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerSession forContext(Lookup context) {
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            if (CURRENT_SESSION != null) {
                if (CURRENT_SESSION.isCompatibleContext(context)) {
                    CURRENT_SESSION.setContext(context);
                    return CURRENT_SESSION;
                }
                if (!CURRENT_SESSION.close()) {
                    return null;
                }
            }
        }
        if (!ProfilerSessions.waitForProfiler()) {
            return null;
        }
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        ProfilerSession session = provider == null ? null : provider.createSession(context);
        Object object2 = CURRENT_SESSION_LOCK;
        synchronized (object2) {
            CURRENT_SESSION = session;
        }
        ProfilerSession.notifyStopAction();
        return session;
    }

    public static void findAndConfigure(Lookup context, Lookup.Provider project, String actionName) {
        ProfilerSession current = ProfilerSession.currentSession();
        if (current != null) {
            ProfilerSessions.configure(current, context, actionName);
        } else {
            ProfilerSessions.createAndConfigure(context, project, actionName);
        }
    }

    protected ProfilerSession(Profiler _profiler, Lookup context) {
        if (_profiler == null) {
            throw new IllegalArgumentException("Profiler cannot be null");
        }
        this.profiler = _profiler;
        this.setContext(context);
    }

    protected final synchronized Lookup getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setContext(Lookup _context) {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            this.context = _context;
        }
        this.notifyWindow();
    }

    protected abstract boolean start();

    protected abstract boolean modify();

    protected abstract boolean stop();

    public abstract Lookup.Provider getProject();

    public abstract FileObject getFile();

    protected abstract boolean isCompatibleContext(Lookup var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttach(final boolean attach) {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (attach == this.isAttach) {
                return;
            }
        }
        boolean sessionInProgress = this.inProgress();
        if (sessionInProgress && !this.confirmedStop()) {
            return;
        }
        Runnable updater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ProfilerSession.this.isAttach = attach;
                }
                ProfilerSession.notifyStopAction();
                ProfilerSession.this.notifyWindow();
            }
        };
        if (!sessionInProgress) {
            updater.run();
        } else {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)updater);
        }
    }

    public final synchronized boolean isAttach() {
        return this.isAttach;
    }

    public final Profiler getProfiler() {
        return this.profiler;
    }

    public final ProfilingSettings getProfilingSettings() {
        return this.profilingSettings;
    }

    public final AttachSettings getAttachSettings() {
        return this.attachSettings;
    }

    public final synchronized SessionStorage getStorage() {
        if (this.storage == null) {
            this.storage = new SessionStorage(this.getProject());
        }
        return this.storage;
    }

    public final void open() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilerWindow w = ProfilerSession.this.getWindow();
                w.open();
                w.requestActive();
            }
        });
    }

    public final int getState() {
        return this.profiler.getProfilingState();
    }

    public final boolean inProgress() {
        return this.getState() != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ProfilingStateListener listener) {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            this.profiler.addProfilingStateListener(listener);
            this.profilingStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(ProfilingStateListener listener) {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            this.profiler.removeProfilingStateListener(listener);
            this.profilingStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupAllListeners() {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            for (ProfilingStateListener listener : this.profilingStateListeners) {
                this.profiler.removeProfilingStateListener(listener);
            }
        }
    }

    final boolean doStart(ProfilingSettings pSettings, AttachSettings aSettings) {
        this.profilingSettings = pSettings;
        this.attachSettings = aSettings;
        this.plugins.notifyStarting();
        return this.start();
    }

    final boolean doModify(ProfilingSettings pSettings) {
        this.profilingSettings = pSettings;
        return this.modify();
    }

    final boolean doStop() {
        this.plugins.notifyStopping();
        return this.stop();
    }

    private final boolean confirmedStop() {
        if (this.inProgress()) {
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerWindow_terminateMsg(), (String)Bundle.ProfilerWindow_terminateCaption())) {
                return false;
            }
            if (!this.doStop()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean close() {
        if (!this.confirmedStop()) {
            return false;
        }
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            if (CURRENT_SESSION == this) {
                CURRENT_SESSION = null;
            }
        }
        ProfilerSession.notifyStopAction();
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerSession.this.window != null) {
                    if (!((ProfilerSession)ProfilerSession.this).window.closing && ProfilerSession.this.window.isOpened()) {
                        ((ProfilerSession)ProfilerSession.this).window.closing = true;
                        ProfilerSession.this.window.close();
                    }
                } else {
                    ProfilerSession.this.cleanup();
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProfilerFeatures getFeatures() {
        assert (!SwingUtilities.isEventDispatchThread());
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.features == null) {
                this.features = new ProfilerFeatures(this);
            }
        }
        return this.features;
    }

    final void selectFeature(final ProfilerFeature feature) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ProfilerSession.this.getWindow().selectFeature(feature);
            }
        };
        UIUtils.runInEventDispatchThread((Runnable)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProfilerPlugins getPlugins() {
        assert (!SwingUtilities.isEventDispatchThread());
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.plugins == null) {
                this.plugins = new ProfilerPlugins(this);
            }
        }
        return this.plugins;
    }

    final synchronized void persistStorage(boolean immediately) {
        if (this.storage != null) {
            this.storage.persist(immediately);
        }
    }

    private ProfilerWindow getWindow() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.window == null) {
            this.window = new ProfilerWindow(this){

                @Override
                protected void componentClosed() {
                    super.componentClosed();
                    ProfilerSession.this.window = null;
                    ProfilerSession.this.cleanup();
                }
            };
        }
        return this.window;
    }

    private void notifyWindow() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerSession.this.window != null) {
                    ProfilerSession.this.window.updateSession();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.features != null) {
                this.features.sessionFinished();
            }
        }
        this.cleanupAllListeners();
        ResetResultsAction.getInstance().performAction();
        this.persistStorage(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyStopAction() {
        ProfilerSession CURRENT_SESSION_F;
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            CURRENT_SESSION_F = CURRENT_SESSION;
        }
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilerSessions.StopAction.getInstance().setSession(CURRENT_SESSION_F);
            }
        });
    }

    static {
        CURRENT_SESSION_LOCK = new Object();
    }

    public static abstract class Provider {
        public abstract ProfilerSession createSession(Lookup var1);
    }
}

