/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.NFILibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFILibrary.class)
final class NFILibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NFILibraryGen() {
    }

    static {
        LibraryExport.register(NFILibrary.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=NFILibrary.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFILibrary.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFILibrary);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFILibrary);
            return new Cached();
        }

        @GeneratedBy(value=NFILibrary.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFILibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                return arg0Value.readMember(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary)receiver).isMemberInvocable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), BranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.hasLanguage((NFILibrary)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.getLanguage((NFILibrary)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.toDisplayString((NFILibrary)receiver, allowSideEffects);
            }
        }

        @GeneratedBy(value=NFILibrary.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private IsMemberReadableNode_IsMemberReadable0Data isMemberReadableNode__isMemberReadable0_cache;
            @Node.Child
            private ReadMemberNode_ReadMember0Data readMemberNode__readMember0_cache;
            @Node.Child
            private InteropLibrary invokeMemberNode__executables_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile invokeMemberNode__exception_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFILibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFILibrary)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFILibrary)receiver).getMembers(includeInternal);
            }

            @ExplodeLoop
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0) {
                        IsMemberReadableNode_IsMemberReadable0Data s1_ = this.isMemberReadableNode__isMemberReadable0_cache;
                        while (s1_ != null) {
                            if (s1_.recursive_.accepts(arg0Value.getLibrary())) {
                                return arg0Value.isMemberReadable(arg1Value, s1_.recursive_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return this.isMemberReadable1Boundary(state, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private boolean isMemberReadable1Boundary(int state, NFILibrary arg0Value, String arg1Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary isMemberReadableNode__isMemberReadable1_recursive__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary());
                    boolean bl = arg0Value.isMemberReadable(arg1Value, isMemberReadableNode__isMemberReadable1_recursive__);
                    return bl;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    boolean bl;
                    if ((exclude & 1) == 0) {
                        int count1_ = 0;
                        IsMemberReadableNode_IsMemberReadable0Data s1_ = this.isMemberReadableNode__isMemberReadable0_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null && !s1_.recursive_.accepts(arg0Value.getLibrary())) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (IsMemberReadableNode_IsMemberReadable0Data)super.insert((Node)new IsMemberReadableNode_IsMemberReadable0Data(this.isMemberReadableNode__isMemberReadable0_cache));
                            s1_.recursive_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value.getLibrary()));
                            this.isMemberReadableNode__isMemberReadable0_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl2 = arg0Value.isMemberReadable(arg1Value, s1_.recursive_);
                            return bl2;
                        }
                    }
                    InteropLibrary isMemberReadableNode__isMemberReadable1_recursive__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        isMemberReadableNode__isMemberReadable1_recursive__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary());
                        this.exclude_ = exclude |= 1;
                        this.isMemberReadableNode__isMemberReadable0_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        bl = arg0Value.isMemberReadable(arg1Value, isMemberReadableNode__isMemberReadable1_recursive__);
                    }
                    catch (Throwable throwable) {
                        encapsulating_.set(prev_);
                        throw throwable;
                    }
                    encapsulating_.set(prev_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                IsMemberReadableNode_IsMemberReadable0Data s1_;
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0 && ((s1_ = this.isMemberReadableNode__isMemberReadable0_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                int state = this.state_;
                if ((state & 0xC) != 0) {
                    if ((state & 4) != 0) {
                        ReadMemberNode_ReadMember0Data s1_ = this.readMemberNode__readMember0_cache;
                        while (s1_ != null) {
                            if (s1_.recursive_.accepts(arg0Value.getLibrary())) {
                                return arg0Value.readMember(arg1Value, s1_.recursive_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 8) != 0) {
                        return this.readMember1Boundary(state, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object readMember1Boundary(int state, NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary readMemberNode__readMember1_recursive__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary());
                    Object object = arg0Value.readMember(arg1Value, readMemberNode__readMember1_recursive__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    Object object;
                    if ((exclude & 2) == 0) {
                        int count1_ = 0;
                        ReadMemberNode_ReadMember0Data s1_ = this.readMemberNode__readMember0_cache;
                        if ((state & 4) != 0) {
                            while (s1_ != null && !s1_.recursive_.accepts(arg0Value.getLibrary())) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (ReadMemberNode_ReadMember0Data)super.insert((Node)new ReadMemberNode_ReadMember0Data(this.readMemberNode__readMember0_cache));
                            s1_.recursive_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value.getLibrary()));
                            this.readMemberNode__readMember0_cache = s1_;
                            this.state_ = state |= 4;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object2 = arg0Value.readMember(arg1Value, s1_.recursive_);
                            return object2;
                        }
                    }
                    InteropLibrary readMemberNode__readMember1_recursive__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        readMemberNode__readMember1_recursive__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary());
                        this.exclude_ = exclude |= 2;
                        this.readMemberNode__readMember0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        object = arg0Value.readMember(arg1Value, readMemberNode__readMember1_recursive__);
                    }
                    catch (Throwable throwable) {
                        encapsulating_.set(prev_);
                        throw throwable;
                    }
                    encapsulating_.set(prev_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFILibrary)receiver).isMemberInvocable(member);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFILibrary arg0Value = (NFILibrary)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__executables_, this.invokeMemberNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.invokeMemberNode__executables_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                    this.invokeMemberNode__exception_ = BranchProfile.create();
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__executables_, this.invokeMemberNode__exception_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NFILibrary.hasLanguage((NFILibrary)receiver);
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NFILibrary.getLanguage((NFILibrary)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NFILibrary.toDisplayString((NFILibrary)receiver, allowSideEffects);
            }

            @GeneratedBy(value=NFILibrary.class)
            private static final class ReadMemberNode_ReadMember0Data
            extends Node {
                @Node.Child
                ReadMemberNode_ReadMember0Data next_;
                @Node.Child
                InteropLibrary recursive_;

                ReadMemberNode_ReadMember0Data(ReadMemberNode_ReadMember0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }

            @GeneratedBy(value=NFILibrary.class)
            private static final class IsMemberReadableNode_IsMemberReadable0Data
            extends Node {
                @Node.Child
                IsMemberReadableNode_IsMemberReadable0Data next_;
                @Node.Child
                InteropLibrary recursive_;

                IsMemberReadableNode_IsMemberReadable0Data(IsMemberReadableNode_IsMemberReadable0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

