/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NativeAllocation;
import java.util.concurrent.atomic.AtomicInteger;

final class ClosureNativePointer {
    private final NFIContext context;
    private final long codePointer;
    private final AtomicInteger refCount;
    final CallTarget callTarget;
    final LibFFISignature signature;
    private final NativeAllocation.Queue releaseRefQueue;

    static ClosureNativePointer create(NFIContext context, long nativeClosure, long codePointer, CallTarget callTarget, LibFFISignature signature) {
        ClosureNativePointer ret = new ClosureNativePointer(context, codePointer, callTarget, signature);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new NativeDestructor(nativeClosure));
        return ret;
    }

    private ClosureNativePointer(NFIContext context, long codePointer, CallTarget callTarget, LibFFISignature signature) {
        this.context = context;
        this.codePointer = codePointer;
        this.callTarget = callTarget;
        this.signature = signature;
        this.refCount = new AtomicInteger(0);
        this.releaseRefQueue = new NativeAllocation.Queue();
    }

    void registerManagedRef(LibFFIClosure closure) {
        this.addRef();
        this.releaseRefQueue.registerNativeAllocation(closure, new ReleaseRef(this));
    }

    void addRef() {
        int refs = this.refCount.incrementAndGet();
        assert (refs > 0) : "closure still dead after addRef";
    }

    void releaseRef() {
        int refs = this.refCount.decrementAndGet();
        assert (refs >= 0) : "releaseRef on already dead closure";
        if (refs == 0) {
            this.context.removeClosureNativePointer(this.codePointer);
        }
    }

    long getCodePointer() {
        assert (this.refCount.get() > 0) : "accessing dead closure";
        return this.codePointer;
    }

    private static native void freeClosure(long var0);

    private static class NativeDestructor
    extends NativeAllocation.Destructor {
        private final long nativeClosure;

        NativeDestructor(long nativeClosure) {
            this.nativeClosure = nativeClosure;
        }

        @Override
        protected void destroy() {
            ClosureNativePointer.freeClosure(this.nativeClosure);
        }
    }

    private static final class ReleaseRef
    extends NativeAllocation.Destructor {
        private final ClosureNativePointer pointer;

        ReleaseRef(ClosureNativePointer pointer) {
            this.pointer = pointer;
        }

        @Override
        protected void destroy() {
            this.pointer.releaseRef();
        }
    }
}

