/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FunctionExecuteNode.class)
final class FunctionExecuteNodeGen
extends FunctionExecuteNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<NativeArgumentLibrary> NATIVE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(NativeArgumentLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
    @Node.Child
    private CachedSignatureData cachedSignature_cache;
    @Node.Child
    private CachedArgCountData cachedArgCount_cache;
    @Node.Child
    private NativeArgumentLibrary genericExecute_nativeArguments_;

    private FunctionExecuteNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    if (arg1Value == s1_.cachedSignature_) {
                        return this.cachedSignature(arg0Value, arg1Value, arg2Value, s1_.cachedSignature_, s1_.execute_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                CachedArgCountData s2_ = this.cachedArgCount_cache;
                while (s2_ != null) {
                    if (arg1Value.getArgTypes().length == s2_.libs_.length) {
                        return this.cachedArgCount(arg0Value, arg1Value, arg2Value, s2_.libs_, s2_.slowPathCall_, s2_.exception_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                NFILanguageImpl genericExecute_language__ = (NFILanguageImpl)nFILanguageImplReference__.get();
                return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, this.genericExecute_nativeArguments_, genericExecute_language__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Object object;
            if ((exclude & 1) == 0) {
                int count1_ = 0;
                CachedSignatureData s1_ = this.cachedSignature_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && arg1Value != s1_.cachedSignature_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = (CachedSignatureData)super.insert((Node)new CachedSignatureData(this.cachedSignature_cache));
                    s1_.cachedSignature_ = arg1Value;
                    s1_.execute_ = s1_.insertAccessor(this.createCachedSignatureCall(s1_.cachedSignature_));
                    this.cachedSignature_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object2 = this.cachedSignature(arg0Value, arg1Value, arg2Value, s1_.cachedSignature_, s1_.execute_);
                    return object2;
                }
            }
            if ((exclude & 2) == 0) {
                int count2_ = 0;
                CachedArgCountData s2_ = this.cachedArgCount_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && arg1Value.getArgTypes().length != s2_.libs_.length) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null) {
                    NativeArgumentLibrary[] libs__ = (NativeArgumentLibrary[])super.insert((Node[])FunctionExecuteNode.getGenericNativeArgumentLibraries(arg1Value.getArgTypes().length));
                    if (arg1Value.getArgTypes().length == libs__.length && count2_ < 3) {
                        s2_ = (CachedArgCountData)super.insert((Node)new CachedArgCountData(this.cachedArgCount_cache));
                        s2_.libs_ = s2_.insertAccessor(libs__);
                        s2_.slowPathCall_ = s2_.insertAccessor(this.createSlowPathCall());
                        s2_.exception_ = BranchProfile.create();
                        this.cachedArgCount_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.cachedSignature_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    object = this.cachedArgCount(arg0Value, arg1Value, arg2Value, s2_.libs_, s2_.slowPathCall_, s2_.exception_);
                    return object;
                }
            }
            NFILanguageImpl genericExecute_language__ = null;
            this.genericExecute_nativeArguments_ = (NativeArgumentLibrary)super.insert((Node)((NativeArgumentLibrary)NATIVE_ARGUMENT_LIBRARY_.createDispatched(5)));
            TruffleLanguage.LanguageReference nFILanguageImplReference__1 = this.nFILanguageImplReference_;
            if (nFILanguageImplReference__1 == null) {
                this.nFILanguageImplReference_ = nFILanguageImplReference__1 = super.lookupLanguageReference(NFILanguageImpl.class);
            }
            genericExecute_language__ = (NFILanguageImpl)nFILanguageImplReference__1.get();
            this.exclude_ = exclude |= 3;
            this.cachedSignature_cache = null;
            this.cachedArgCount_cache = null;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            object = FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, this.genericExecute_nativeArguments_, genericExecute_language__);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedSignatureData s1_ = this.cachedSignature_cache;
            CachedArgCountData s2_ = this.cachedArgCount_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static FunctionExecuteNode create() {
        return new FunctionExecuteNodeGen();
    }

    public static FunctionExecuteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=FunctionExecuteNode.class)
    private static final class Uncached
    extends FunctionExecuteNode {
        private final TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = this.lookupLanguageReference(NFILanguageImpl.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
            return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, (NativeArgumentLibrary)NATIVE_ARGUMENT_LIBRARY_.getUncached(), (NFILanguageImpl)this.nFILanguageImplReference_.get());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=FunctionExecuteNode.class)
    private static final class CachedArgCountData
    extends Node {
        @Node.Child
        CachedArgCountData next_;
        @Node.Children
        NativeArgumentLibrary[] libs_;
        @Node.Child
        DirectCallNode slowPathCall_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        CachedArgCountData(CachedArgCountData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=FunctionExecuteNode.class)
    private static final class CachedSignatureData
    extends Node {
        @Node.Child
        CachedSignatureData next_;
        @CompilerDirectives.CompilationFinal
        LibFFISignature cachedSignature_;
        @Node.Child
        DirectCallNode execute_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

