/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeAllocation;

@ExportLibrary(value=InteropLibrary.class)
final class LibFFILibrary
implements TruffleObject {
    private static final EmptyKeysArray KEYS = new EmptyKeysArray();
    protected final long handle;

    static LibFFILibrary createDefault() {
        return new LibFFILibrary(0L);
    }

    static LibFFILibrary create(long handle) {
        assert (handle != 0L);
        LibFFILibrary ret = new LibFFILibrary(handle);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new Destructor(handle));
        return ret;
    }

    private LibFFILibrary(long handle) {
        this.handle = handle;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @ExportMessage
    boolean isMemberReadable(String member) {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return NFILanguageImpl.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "LibFFILibrary(" + this.handle + ")";
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class EmptyKeysArray
    implements TruffleObject {
        EmptyKeysArray() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 0L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    private static final class Destructor
    extends NativeAllocation.Destructor {
        private final long handle;

        private Destructor(long handle) {
            this.handle = handle;
        }

        @Override
        protected void destroy() {
            NFIContext.freeLibrary(this.handle);
        }
    }

    @ExportMessage
    @ImportStatic(value={NFILanguageImpl.class})
    static abstract class ReadMember {
        ReadMember() {
        }

        @Specialization(limit="3", guards={"receiver == cachedReceiver", "symbol.equals(cachedSymbol)"})
        static Object doCached(LibFFILibrary receiver, String symbol, @Cached(value="receiver") LibFFILibrary cachedReceiver, @Cached(value="symbol") String cachedSymbol, @CachedContext(value=NFILanguageImpl.class) TruffleLanguage.ContextReference<NFIContext> ctxRef, @Cached(value="lookupCached(cachedReceiver, cachedSymbol, ctxRef)") Object cachedRet) {
            return cachedRet;
        }

        static Object lookupCached(LibFFILibrary receiver, String symbol, TruffleLanguage.ContextReference<NFIContext> ctxRef) throws UnknownIdentifierException {
            return ReadMember.doGeneric(receiver, symbol, BranchProfile.getUncached(), (NFIContext)ctxRef.get());
        }

        @Specialization(replaces={"doCached"})
        static Object doGeneric(LibFFILibrary receiver, String symbol, @Cached BranchProfile exception, @CachedContext(value=NFILanguageImpl.class) NFIContext ctx) throws UnknownIdentifierException {
            try {
                return ctx.lookupSymbol(receiver, symbol);
            }
            catch (UnsatisfiedLinkError ex) {
                exception.enter();
                throw UnknownIdentifierException.create((String)symbol);
            }
        }
    }
}

