/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;

@GeneratedBy(value=NativeString.class)
final class NativeStringGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativeStringGen() {
    }

    static {
        LibraryExport.register(NativeString.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new SerializeArgumentLibraryExports()});
    }

    @GeneratedBy(value=NativeString.class)
    private static final class SerializeArgumentLibraryExports
    extends LibraryExport<SerializeArgumentLibrary> {
        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, NativeString.class, false);
        }

        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativeString);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof NativeString);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeString.class)
        private static final class Uncached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativeString> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativeString)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)receiver).putPointer(buffer, ptrSize);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void putString(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)receiver).putPointer(buffer, ptrSize);
            }
        }

        @GeneratedBy(value=NativeString.class)
        private static final class Cached
        extends SerializeArgumentLibrary {
            private final Class<? extends NativeString> receiverClass_;

            Cached(Object originalReceiver) {
                NativeString receiver = (NativeString)originalReceiver;
                this.receiverClass_ = receiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).putPointer(buffer, ptrSize);
            }

            @Override
            public void putString(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).putPointer(buffer, ptrSize);
            }
        }
    }

    @GeneratedBy(value=NativeString.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NativeString.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NativeString);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NativeString);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeString.class)
        private static final class Uncached
        extends InteropLibrary {
            private final Class<? extends NativeString> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativeString)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).isNull();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).isString();
            }

            @CompilerDirectives.TruffleBoundary
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).asString();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)receiver).toNative();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=NativeString.class)
        private static final class Cached
        extends InteropLibrary {
            private final Class<? extends NativeString> receiverClass_;

            Cached(Object originalReceiver) {
                NativeString receiver = (NativeString)originalReceiver;
                this.receiverClass_ = receiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isNull();
            }

            public boolean isString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isString();
            }

            public String asString(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asString();
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isPointer();
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asPointer();
            }

            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).toNative();
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativeString)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).toDisplayString(allowSideEffects);
            }
        }
    }
}

