/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativeSymbolLibrary.class)
final class NativeSymbolLibraryGen
extends LibraryFactory<NativeSymbolLibrary> {
    private static final Class<NativeSymbolLibrary> LIBRARY_CLASS = NativeSymbolLibraryGen.lazyLibraryClass();
    private static final Message IS_BINDABLE = new MessageImpl("isBindable", 0, Boolean.TYPE, Object.class);
    private static final Message PREPARE_SIGNATURE = new MessageImpl("prepareSignature", 1, Object.class, Object.class, NativeSignature.class);
    private static final Message CALL = new MessageImpl("call", 2, Object.class, Object.class, Object.class, Object[].class);
    private static final NativeSymbolLibraryGen INSTANCE = new NativeSymbolLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativeSymbolLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(IS_BINDABLE, PREPARE_SIGNATURE, CALL)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NativeSymbolLibrary.class;
    }

    protected NativeSymbolLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NativeSymbolLibrary createDelegate(NativeSymbolLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeSymbolLibrary lib = (NativeSymbolLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.isBindable(receiver);
            }
            case 1: {
                return lib.prepareSignature(receiver, (NativeSignature)args[offset]);
            }
            case 2: {
                return lib.call(receiver, args[offset], (Object[])args[offset + 1]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NativeSymbolLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NativeSymbolLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NativeSymbolLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.spi.NativeSymbolLibrary", false, NativeSymbolLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static abstract class CachedDispatch
    extends NativeSymbolLibrary {
        @Node.Child
        NativeSymbolLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NativeSymbolLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isBindable(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isBindable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.prepareSignature(receiver_, signature);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object call(Object receiver_, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.call(receiver_, signature, args);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            NativeSymbolLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NativeSymbolLibrary)this.insert((Node)((NativeSymbolLibrary)INSTANCE.create(receiver_)));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NativeSymbolLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NativeSymbolLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NativeSymbolLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NativeSymbolLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NativeSymbolLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class UncachedDispatch
    extends NativeSymbolLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isBindable(Object receiver_) {
            return ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).isBindable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            return ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).prepareSignature(receiver_, signature);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            return ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, signature, args);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NativeSymbolLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isBindable(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).isBindable(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).prepareSignature(receiver_, signature);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NativeSymbolLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, signature, args);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class Delegate
    extends NativeSymbolLibrary {
        @Node.Child
        private NativeSymbolLibrary delegateLibrary;

        Delegate(NativeSymbolLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isBindable(Object receiver_) {
            if (NativeSymbolLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NativeSymbolLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeSymbolLibrary)NativeSymbolLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isBindable(delegate);
            }
            return this.delegateLibrary.isBindable(receiver_);
        }

        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            if (NativeSymbolLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NativeSymbolLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeSymbolLibrary)NativeSymbolLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).prepareSignature(delegate, signature);
            }
            return this.delegateLibrary.prepareSignature(receiver_, signature);
        }

        @Override
        public Object call(Object receiver_, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            if (NativeSymbolLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = NativeSymbolLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NativeSymbolLibrary)NativeSymbolLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).call(delegate, signature, args);
            }
            return this.delegateLibrary.call(receiver_, signature, args);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class Proxy
    extends NativeSymbolLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isBindable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_BINDABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            try {
                return this.lib.send(receiver_, PREPARE_SIGNATURE, new Object[]{signature});
            }
            catch (UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object call(Object receiver_, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            try {
                return this.lib.send(receiver_, CALL, new Object[]{signature, args});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NativeSymbolLibrary.class)
    private static final class Default
    extends LibraryExport<NativeSymbolLibrary> {
        private Default() {
            super(NativeSymbolLibrary.class, Object.class, false);
        }

        protected NativeSymbolLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NativeSymbolLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeSymbolLibrary.class)
        private static final class Uncached
        extends NativeSymbolLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBindable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBindable(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object prepareSignature(Object receiver, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.prepareSignature(receiver, signature);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object receiver, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.call(receiver, signature, args);
            }
        }

        @GeneratedBy(value=NativeSymbolLibrary.class)
        private static final class Cached
        extends NativeSymbolLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isBindable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBindable(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object prepareSignature(Object receiver, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.prepareSignature(this.dynamicDispatch_.cast(receiver), signature);
            }

            @Override
            public Object call(Object receiver, Object signature, Object ... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.call(this.dynamicDispatch_.cast(receiver), signature, args);
            }
        }
    }
}

