/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.impl;

import com.oracle.truffle.tck.impl.TruffleLanguageRunner;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=TruffleLanguageRunner.RubyRunner.class)
public class PolyglotEngineWithRuby {
    private Context context;

    @Before
    public void initEngine() {
        this.context = Context.newBuilder((String[])new String[0]).build();
    }

    @After
    public void disposeEngine() {
        this.context.close();
    }

    @Test
    public void testCallRubyFunctionFromJava() {
        this.callRubyFunctionFromJava();
    }

    public void callRubyFunctionFromJava() {
        Source src = Source.newBuilder((String)"ruby", (CharSequence)"proc { |a, b|\n  a * b}", (String)"mul.rb").buildLiteral();
        Value rbFunction = this.context.eval(src);
        Multiplier mul = (Multiplier)rbFunction.as(Multiplier.class);
        Assert.assertEquals((long)42L, (long)mul.multiply(6, 7));
        Assert.assertEquals((long)144L, (long)mul.multiply(12, 12));
        Assert.assertEquals((long)256L, (long)mul.multiply(32, 8));
    }

    @FunctionalInterface
    static interface Multiplier {
        public int multiply(int var1, int var2);
    }
}

