/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.llvm.LLVMGenerator;
import com.oracle.svm.core.graal.llvm.lowering.LLVMAddressLowering;
import com.oracle.svm.core.graal.llvm.runtime.LLVMExceptionUnwind;
import com.oracle.svm.core.graal.llvm.util.LLVMIRBuilder;
import com.oracle.svm.core.graal.llvm.util.LLVMOptions;
import com.oracle.svm.core.graal.llvm.util.LLVMUtils;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMTypeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMValueRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.global.LLVM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.java.TypeSwitchNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.nodes.spi.NodeWithState;

public class NodeLLVMBuilder
implements NodeLIRBuilderTool,
SubstrateNodeLIRBuilder {
    private final LLVMGenerator gen;
    private final LLVMIRBuilder builder;
    private final RuntimeConfiguration runtimeConfiguration;
    private final DebugInfoBuilder debugInfoBuilder;
    private Map<Node, LLVMUtils.LLVMValueWrapper> valueMap = new HashMap<Node, LLVMUtils.LLVMValueWrapper>();
    private final Set<AbstractBlockBase<?>> processedBlocks = new HashSet();
    private Map<ValuePhiNode, LLVMValueRef> backwardsPhi = new HashMap<ValuePhiNode, LLVMValueRef>();
    private long nextCGlobalId = 0L;
    private final Map<String, CGlobalDataReference> cGlobals = new HashMap<String, CGlobalDataReference>();

    protected NodeLLVMBuilder(StructuredGraph graph, LLVMGenerator gen, RuntimeConfiguration runtimeConfiguration) {
        this.gen = gen;
        this.builder = gen.getBuilder();
        this.runtimeConfiguration = runtimeConfiguration;
        this.debugInfoBuilder = new SubstrateDebugInfoBuilder(graph, gen.getProviders().getMetaAccessExtensionProvider(), (NodeValueMap)this);
        NodeLLVMBuilder.setCompilationResultMethod(gen.getCompilationResult(), graph);
        for (Block block : graph.getLastSchedule().getCFG().getBlocks()) {
            gen.appendBasicBlock(block);
        }
    }

    private static void setCompilationResultMethod(CompilationResult result, StructuredGraph graph) {
        ResolvedJavaMethod rootMethod;
        Assumptions assumptions = graph.getAssumptions();
        if (assumptions != null && !assumptions.isEmpty()) {
            result.setAssumptions(assumptions.toArray());
        }
        if ((rootMethod = graph.method()) != null) {
            result.setMethods(rootMethod, (Collection)graph.getMethods());
            result.setFields(graph.getFields());
        }
        result.setHasUnsafeAccess(graph.hasUnsafeAccess());
    }

    public LLVMGenerator getLIRGeneratorTool() {
        return this.gen;
    }

    private LLVMTypeRef getLLVMType(ValueNode node) {
        return this.gen.getLLVMType(node.stamp(NodeView.DEFAULT));
    }

    public void doBlock(Block block, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        assert (!this.processedBlocks.contains(block)) : "Block already processed " + block;
        assert (this.verifyPredecessors(block));
        this.gen.beginBlock(block);
        if (block == graph.getLastSchedule().getCFG().getStartBlock()) {
            assert (block.getPredecessorCount() == 0);
            long startPatchpointID = LLVMGenerator.nextPatchpointId.getAndIncrement();
            this.builder.buildStackmap(this.builder.constantLong(startPatchpointID), new LLVMValueRef[0]);
            this.gen.getCompilationResult().recordInfopoint(NumUtil.safeToInt((long)startPatchpointID), null, InfopointReason.METHOD_START);
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                int offset = this.gen.isEntryPoint() ? 0 : LLVMGenerator.SpecialRegister.count();
                LLVMValueRef lLVMValueRef = this.builder.getFunctionParam(param.index() + offset);
                this.setResult((ValueNode)param, lLVMValueRef);
            }
            if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
                for (LLVMGenerator.SpecialRegister specialRegister : LLVMGenerator.SpecialRegister.registers()) {
                    this.gen.setInitialSpecialRegisterValue(specialRegister, this.gen.isEntryPoint() ? this.builder.constantNull(this.builder.wordType()) : this.builder.getFunctionParam(specialRegister.getIndex()));
                }
            } else {
                this.gen.allocateRegisterSlots();
            }
            this.gen.getDebugInfoPrinter().printFunction(graph, this);
        } else {
            assert (block.getPredecessorCount() > 0);
            AbstractBeginNode begin = block.getBeginNode();
            if (begin instanceof AbstractMergeNode) {
                AbstractMergeNode merge = (AbstractMergeNode)begin;
                if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
                    for (LLVMGenerator.SpecialRegister specialRegister : LLVMGenerator.SpecialRegister.registers()) {
                        ArrayList<LLVMValueRef> forwardPredValues = new ArrayList<LLVMValueRef>();
                        ArrayList<LLVMBasicBlockRef> forwardBlocks = new ArrayList<LLVMBasicBlockRef>();
                        for (Block predecessor : (Block[])block.getPredecessors()) {
                            if (!this.processedBlocks.contains(predecessor)) continue;
                            forwardPredValues.add(block.isExceptionEntry() ? this.gen.getHandlerSpecialRegisterValue(specialRegister, predecessor) : this.gen.getSpecialRegisterValue(specialRegister, predecessor));
                            forwardBlocks.add(this.gen.getBlockEnd(predecessor));
                        }
                        LLVMValueRef registerPhi = this.builder.buildPhi(this.builder.wordType(), forwardPredValues.toArray(new LLVMValueRef[0]), forwardBlocks.toArray(new LLVMBasicBlockRef[0]));
                        this.gen.setInitialSpecialRegisterValue(specialRegister, registerPhi);
                    }
                }
                for (ValuePhiNode phiNode : merge.valuePhis()) {
                    ArrayList<LLVMValueRef> forwardPhis = new ArrayList<LLVMValueRef>();
                    ArrayList<LLVMBasicBlockRef> arrayList = new ArrayList<LLVMBasicBlockRef>();
                    LLVMTypeRef phiType = this.getLLVMType((ValueNode)phiNode);
                    boolean hasBackwardIncomingEdges = false;
                    for (Block predecessor : (LLVMValueRef)block.getPredecessors()) {
                        if (this.processedBlocks.contains(predecessor)) {
                            LLVMValueRef value;
                            ValueNode phiValue = phiNode.valueAt((AbstractEndNode)predecessor.getEndNode());
                            if (this.operand((Node)phiValue) instanceof LLVMUtils.LLVMPendingSpecialRegisterRead) {
                                Block currentBlock = (Block)this.gen.getCurrentBlock();
                                this.gen.editBlock(predecessor);
                                value = this.llvmOperand((Node)phiValue);
                                this.gen.resumeBlock(currentBlock);
                            } else {
                                value = this.llvmOperand((Node)phiValue);
                            }
                            LLVMBasicBlockRef parentBlock = this.gen.getBlockEnd(predecessor);
                            forwardPhis.add(value);
                            arrayList.add(parentBlock);
                            continue;
                        }
                        hasBackwardIncomingEdges = true;
                    }
                    LLVMValueRef[] incomingValues = forwardPhis.toArray(new LLVMValueRef[0]);
                    LLVMBasicBlockRef[] incomingBlocks = arrayList.toArray(new LLVMBasicBlockRef[0]);
                    LLVMValueRef phi = this.builder.buildPhi(phiType, incomingValues, incomingBlocks);
                    if (hasBackwardIncomingEdges) {
                        this.backwardsPhi.put(phiNode, phi);
                    }
                    this.setResult((ValueNode)phiNode, phi);
                }
            } else if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
                assert (block.getPredecessorCount() == 1);
                Block predecessor = block.getFirstPredecessor();
                for (LLVMGenerator.SpecialRegister specialRegister : LLVMGenerator.SpecialRegister.registers()) {
                    this.gen.setInitialSpecialRegisterValue(specialRegister, block.isExceptionEntry() ? this.gen.getHandlerSpecialRegisterValue(specialRegister, predecessor) : this.gen.getSpecialRegisterValue(specialRegister, predecessor));
                }
            }
        }
        this.gen.getDebugInfoPrinter().printBlock(block);
        for (Node node : (List)blockMap.get((AbstractBlockBase)block)) {
            if (!(node instanceof ValueNode) || this.valueMap.containsKey(node)) continue;
            ValueNode valueNode = (ValueNode)node;
            try {
                this.gen.getDebugInfoPrinter().printNode(valueNode);
                this.emitNode(valueNode);
            }
            catch (GraalError e) {
                throw GraalGraphError.transformAndAddContext((GraalError)e, (Node)valueNode);
            }
            catch (Throwable e) {
                throw new GraalGraphError(e).addContext((Node)valueNode);
            }
        }
        if (this.builder.blockTerminator(this.gen.getBlockEnd(block)) == null) {
            NodeIterable successors = block.getEndNode().successors();
            assert (successors.count() == block.getSuccessorCount());
            if (block.getSuccessorCount() != 1) {
                throw new GraalError("Block without BlockEndOp: " + block.getEndNode());
            }
            this.builder.buildBranch(this.gen.getBlock(block.getFirstSuccessor()));
        }
        this.processedBlocks.add((AbstractBlockBase<?>)block);
    }

    private boolean verifyPredecessors(Block block) {
        for (Block pred : (Block[])block.getPredecessors()) {
            assert (block.isLoopHeader() && pred.isLoopEnd() || this.processedBlocks.contains(pred)) : "Predecessor not yet processed " + pred;
        }
        return true;
    }

    private void emitNode(ValueNode node) {
        DebugContext debug = node.getDebug();
        debug.log("Visiting %s", (Object)node);
        if (node.getDebug().isLogEnabled() && node.stamp(NodeView.DEFAULT).isEmpty()) {
            node.getDebug().log("This node has an empty stamp, we are emitting dead code(?): %s", (Object)node);
        }
        if (!(node instanceof LIRLowerable)) {
            throw GraalError.shouldNotReachHere((String)("node is not LIRLowerable: " + node));
        }
        ((LIRLowerable)node).generate((NodeLIRBuilderTool)this);
        debug.log("Operand for %s = %s", (Object)node, (Object)this.operand((Node)node));
    }

    void finish() {
        this.cGlobals.forEach((symbolName, reference) -> this.gen.getCompilationResult().recordDataPatchWithNote(0, (Reference)reference, symbolName));
    }

    public void emitIf(IfNode i) {
        LLVMValueRef condition = this.emitCondition(i.condition());
        LLVMBasicBlockRef thenBlock = this.gen.getBlock(i.trueSuccessor());
        LLVMBasicBlockRef elseBlock = this.gen.getBlock(i.falseSuccessor());
        LLVMValueRef instr = this.builder.buildIf(condition, thenBlock, elseBlock);
        int trueProbability = NodeLLVMBuilder.expandProbability(i.getTrueSuccessorProbability());
        int falseProbability = NodeLLVMBuilder.expandProbability(1.0 - i.getTrueSuccessorProbability());
        LLVMValueRef branchWeights = this.builder.branchWeights(this.builder.constantInt(trueProbability), this.builder.constantInt(falseProbability));
        this.builder.setMetadata(instr, "prof", branchWeights);
    }

    private LLVMValueRef emitCondition(LogicNode condition) {
        if (condition instanceof IsNullNode) {
            return this.builder.buildIsNull(this.llvmOperand((Node)((IsNullNode)condition).getValue()));
        }
        if (condition instanceof LogicConstantNode) {
            return this.builder.constantBoolean(((LogicConstantNode)condition).getValue());
        }
        if (condition instanceof CompareNode) {
            CompareNode compareNode = (CompareNode)condition;
            return this.builder.buildCompare(compareNode.condition().asCondition(), this.llvmOperand((Node)compareNode.getX()), this.llvmOperand((Node)compareNode.getY()), compareNode.unorderedIsTrue());
        }
        if (condition instanceof IntegerTestNode) {
            IntegerTestNode integerTestNode = (IntegerTestNode)condition;
            LLVMValueRef and = this.builder.buildAnd(this.llvmOperand((Node)integerTestNode.getX()), this.llvmOperand((Node)integerTestNode.getY()));
            return this.builder.buildIsNull(and);
        }
        if (condition instanceof SafepointCheckNode) {
            LLVMValueRef threadData = this.gen.getSpecialRegister(LLVMGenerator.SpecialRegister.ThreadPointer);
            threadData = this.builder.buildIntToPtr(threadData, this.builder.rawPointerType());
            LLVMValueRef safepointCounterAddr = this.builder.buildGEP(threadData, this.builder.constantInt(Math.toIntExact(Safepoint.getThreadLocalSafepointRequestedOffset())));
            LLVMValueRef safepointCount = this.builder.buildLoad(safepointCounterAddr, this.builder.intType());
            if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
                safepointCount = this.builder.buildSub(safepointCount, this.builder.constantInt(1));
                this.builder.buildStore(safepointCount, this.builder.buildBitcast(safepointCounterAddr, this.builder.pointerType(this.builder.intType())));
            }
            return this.builder.buildICmp(Condition.LE, safepointCount, this.builder.constantInt(0));
        }
        throw GraalError.shouldNotReachHere((String)("logic node: " + condition.getClass().getName()));
    }

    public void emitConditional(ConditionalNode conditional) {
        Variable conditionalValue;
        Value trueValue = this.operand((Node)conditional.trueValue());
        Value falseValue = this.operand((Node)conditional.falseValue());
        LogicNode condition = conditional.condition();
        if (condition instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)condition;
            conditionalValue = this.gen.emitIsNullMove(this.operand((Node)isNullNode.getValue()), trueValue, falseValue);
        } else if (condition instanceof CompareNode) {
            CompareNode compare = (CompareNode)condition;
            conditionalValue = this.gen.emitConditionalMove(null, this.operand((Node)compare.getX()), this.operand((Node)compare.getY()), compare.condition().asCondition(), compare.unorderedIsTrue(), trueValue, falseValue);
        } else if (condition instanceof LogicConstantNode) {
            conditionalValue = this.gen.emitMove(((LogicConstantNode)condition).getValue() ? trueValue : falseValue);
        } else if (condition instanceof IntegerTestNode) {
            IntegerTestNode test = (IntegerTestNode)condition;
            conditionalValue = this.gen.emitIntegerTestMove(this.operand((Node)test.getX()), this.operand((Node)test.getY()), trueValue, falseValue);
        } else {
            throw GraalError.unimplemented((String)condition.toString());
        }
        this.setResult((ValueNode)conditional, (Value)conditionalValue);
    }

    public void emitSwitch(SwitchNode switchNode) {
        if (switchNode instanceof TypeSwitchNode) {
            this.emitTypeSwitch((TypeSwitchNode)switchNode);
            return;
        }
        int numCases = switchNode.keyCount();
        LLVMValueRef[] values = new LLVMValueRef[numCases];
        LLVMBasicBlockRef[] blocks = new LLVMBasicBlockRef[numCases];
        LLVMValueRef[] weights = new LLVMValueRef[numCases + 1];
        int defaultProbability = NodeLLVMBuilder.expandProbability(switchNode.probability(switchNode.defaultSuccessor()));
        weights[0] = this.builder.constantInt(defaultProbability);
        for (int i = 0; i < numCases; ++i) {
            JavaConstant key = (JavaConstant)switchNode.keyAt(i);
            values[i] = this.builder.constantInt(key.asInt());
            blocks[i] = this.gen.getBlock(switchNode.keySuccessor(i));
            int keyProbability = NodeLLVMBuilder.expandProbability(switchNode.probability(switchNode.keySuccessor(i)));
            weights[i + 1] = this.builder.constantInt(keyProbability);
        }
        LLVMValueRef switchInstr = this.builder.buildSwitch(this.llvmOperand((Node)switchNode.value()), this.gen.getBlock(switchNode.defaultSuccessor()), values, blocks);
        LLVMValueRef branchWeights = this.builder.branchWeights(weights);
        this.builder.setMetadata(switchInstr, "prof", branchWeights);
    }

    private void emitTypeSwitch(TypeSwitchNode switchNode) {
        int numCases = switchNode.keyCount();
        LLVMValueRef value = this.llvmOperand((Node)switchNode.value());
        LLVMBasicBlockRef defaultSuccessor = this.gen.getBlock(switchNode.defaultSuccessor());
        switch (numCases) {
            case 0: {
                this.builder.buildBranch(defaultSuccessor);
                break;
            }
            case 1: {
                LLVMValueRef hub = this.gen.emitLLVMConstant(this.builder.objectType(false), (JavaConstant)switchNode.keyAt(0));
                LLVMValueRef cond = this.builder.buildCompare(Condition.EQ, value, hub, false);
                this.builder.buildIf(cond, this.gen.getBlock(switchNode.keySuccessor(0)), defaultSuccessor);
                break;
            }
            default: {
                throw GraalError.unimplemented();
            }
        }
    }

    private static int expandProbability(double probability) {
        return (int)(probability * 2.147483647E9);
    }

    public void visitMerge(AbstractMergeNode i) {
    }

    public void visitEndNode(AbstractEndNode i) {
        LLVMBasicBlockRef nextBlock = this.gen.getBlock((AbstractBeginNode)i.merge());
        this.builder.buildBranch(nextBlock);
    }

    public void visitLoopEnd(LoopEndNode i) {
        LLVMBasicBlockRef[] basicBlocks = new LLVMBasicBlockRef[]{this.gen.getBlockEnd((Block)this.gen.getCurrentBlock())};
        if (((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            assert (this.gen.getCurrentBlock().getSuccessorCount() == 1);
            for (LLVMGenerator.SpecialRegister reg : LLVMGenerator.SpecialRegister.registers()) {
                Block successor = ((Block)this.gen.getCurrentBlock()).getFirstSuccessor();
                LLVMValueRef phi = this.gen.getInitialSpecialRegisterValue(reg, successor);
                assert (LLVM.LLVMGetInstructionOpcode((LLVMValueRef)phi) == 44);
                this.builder.addIncoming(phi, new LLVMValueRef[]{this.gen.getSpecialRegisterValue(reg)}, basicBlocks);
            }
        }
        for (ValuePhiNode phiNode : i.merge().valuePhis()) {
            LLVMValueRef phi = this.backwardsPhi.get(phiNode);
            LLVMValueRef value = this.llvmOperand((Node)phiNode.valueAt((AbstractEndNode)i));
            LLVMValueRef[] values = new LLVMValueRef[]{value};
            this.builder.addIncoming(phi, values, basicBlocks);
        }
    }

    public void emitInvoke(Invoke i) {
        boolean isVoid;
        LLVMValueRef callee;
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)i.callTarget();
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        NodeInputList arguments = callTarget.arguments();
        LIRFrameState state = this.state((DeoptimizingNode)i);
        state.initDebugInfo(null, false);
        DebugInfo debugInfo = state.debugInfo();
        LLVMValueRef[] args = this.getCallArguments((NodeInputList<ValueNode>)arguments, callTarget.callType(), targetMethod);
        long patchpointId = LLVMGenerator.nextPatchpointId.getAndIncrement();
        if (callTarget instanceof DirectCallTargetNode) {
            callee = this.gen.getFunction(targetMethod);
            isVoid = this.gen.isVoidReturnType(this.gen.getLLVMFunctionReturnType(targetMethod, false));
            this.gen.getCompilationResult().recordCall(NumUtil.safeToInt((long)patchpointId), 0, (InvokeTarget)targetMethod, debugInfo, true);
        } else if (callTarget instanceof IndirectCallTargetNode) {
            LLVMTypeRef functionType;
            LLVMValueRef computedAddress = this.llvmOperand((Node)((IndirectCallTargetNode)callTarget).computedAddress());
            if (targetMethod != null) {
                functionType = this.gen.getLLVMFunctionPointerType(targetMethod);
                isVoid = this.gen.isVoidReturnType(this.gen.getLLVMFunctionReturnType(targetMethod, false));
            } else {
                LLVMTypeRef returnType = this.getUnknownCallReturnType(callTarget);
                isVoid = this.gen.isVoidReturnType(returnType);
                LLVMTypeRef[] argTypes = this.getUnknownCallArgumentTypes(callTarget);
                assert (args.length == argTypes.length);
                functionType = this.builder.functionPointerType(returnType, argTypes);
            }
            callee = LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(computedAddress)) ? this.builder.buildBitcast(this.builder.buildAddrSpaceCast(computedAddress, this.builder.rawPointerType()), functionType) : this.builder.buildIntToPtr(computedAddress, functionType);
            this.gen.getCompilationResult().recordCall(NumUtil.safeToInt((long)patchpointId), 0, (InvokeTarget)targetMethod, debugInfo, false);
            this.gen.getDebugInfoPrinter().printIndirectCall(targetMethod, callee);
        } else {
            throw GraalError.shouldNotReachHere();
        }
        LLVMValueRef call = this.emitCall(i, callTarget, callee, patchpointId, args);
        if (!isVoid) {
            this.setResult((ValueNode)i.asNode(), call);
        }
    }

    public void emitForeignCall(ForeignCall i) {
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(i.getDescriptor());
        LIRFrameState state = this.state((DeoptimizingNode)i);
        Value[] args = i.operands((NodeLIRBuilderTool)this);
        Variable result = null;
        if (i instanceof ForeignCallNode) {
            result = this.gen.emitForeignCall(linkage, state, args);
        } else if (i instanceof ForeignCallWithExceptionNode) {
            ForeignCallWithExceptionNode foreignCallWithExceptionNode = (ForeignCallWithExceptionNode)i;
            LLVMBasicBlockRef successor = this.gen.getBlock(foreignCallWithExceptionNode.next());
            LLVMBasicBlockRef handler = this.gen.getBlock(foreignCallWithExceptionNode.exceptionEdge());
            result = this.gen.emitForeignCall(linkage, state, successor, handler, args);
        } else {
            throw GraalError.shouldNotReachHere();
        }
        if (result != null) {
            this.setResult((ValueNode)i.asNode(), (Value)result);
        }
    }

    private LLVMValueRef emitCall(Invoke invoke, LoweredCallTargetNode callTarget, LLVMValueRef callee, long patchpointId, LLVMValueRef ... args) {
        boolean nativeABI = ((SubstrateCallingConventionType)callTarget.callType()).nativeABI;
        if (!SubstrateBackend.hasJavaFrameAnchor((CallTargetNode)callTarget)) {
            assert (SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget) == -1);
            return this.emitCallInstruction(invoke, nativeABI, callee, patchpointId, args);
        }
        assert (VMThreads.StatusSupport.isValidStatus((int)SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget)));
        LLVMValueRef anchor = this.llvmOperand((Node)SubstrateBackend.getJavaFrameAnchor((CallTargetNode)callTarget));
        anchor = this.builder.buildIntToPtr(anchor, this.builder.rawPointerType());
        LLVMValueRef lastSPAddr = this.builder.buildGEP(anchor, this.builder.constantInt(this.runtimeConfiguration.getJavaFrameAnchorLastSPOffset()));
        Register stackPointer = this.gen.getRegisterConfig().getFrameRegister();
        this.builder.buildStore(this.builder.buildReadRegister(this.builder.register(stackPointer.name)), this.builder.buildBitcast(lastSPAddr, this.builder.pointerType(this.builder.wordType())));
        if (((Boolean)SubstrateOptions.MultiThreaded.getValue()).booleanValue()) {
            LLVMValueRef threadLocalArea = this.gen.getSpecialRegister(LLVMGenerator.SpecialRegister.ThreadPointer);
            LLVMValueRef statusIndex = this.builder.constantInt(this.runtimeConfiguration.getVMThreadStatusOffset());
            LLVMValueRef statusAddress = this.builder.buildGEP(this.builder.buildIntToPtr(threadLocalArea, this.builder.rawPointerType()), statusIndex);
            LLVMValueRef newThreadStatus = this.builder.constantInt(SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget));
            this.builder.buildVolatileStore(newThreadStatus, this.builder.buildBitcast(statusAddress, this.builder.pointerType(this.builder.intType())), 4);
        }
        LLVMValueRef wrapper = this.gen.createJNIWrapper(callee, nativeABI, args.length, this.runtimeConfiguration.getJavaFrameAnchorLastIPOffset());
        LLVMValueRef[] newArgs = new LLVMValueRef[args.length + 2];
        if (!nativeABI) {
            System.arraycopy(args, 0, newArgs, 0, LLVMGenerator.SpecialRegister.count());
            newArgs[LLVMGenerator.SpecialRegister.count() + 0] = anchor;
            newArgs[LLVMGenerator.SpecialRegister.count() + 1] = callee;
            System.arraycopy(args, LLVMGenerator.SpecialRegister.count(), newArgs, 2 + LLVMGenerator.SpecialRegister.count(), args.length - LLVMGenerator.SpecialRegister.count());
        } else {
            newArgs[0] = anchor;
            newArgs[1] = callee;
            System.arraycopy(args, 0, newArgs, 2, args.length);
        }
        return this.emitCallInstruction(invoke, nativeABI, wrapper, patchpointId, newArgs);
    }

    private LLVMValueRef emitCallInstruction(Invoke invoke, boolean nativeABI, LLVMValueRef callee, long patchpointId, LLVMValueRef ... args) {
        LLVMValueRef call;
        if (invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithExceptionNode = (InvokeWithExceptionNode)invoke;
            LLVMBasicBlockRef successor = this.gen.getBlock(invokeWithExceptionNode.next());
            LLVMBasicBlockRef handler = this.gen.getBlock(invokeWithExceptionNode.exceptionEdge());
            call = this.gen.buildStatepointInvoke(callee, nativeABI, successor, handler, patchpointId, args);
        } else {
            call = this.gen.buildStatepointCall(callee, nativeABI, patchpointId, args);
        }
        return call;
    }

    private LLVMValueRef[] getCallArguments(NodeInputList<ValueNode> arguments, CallingConvention.Type callType, ResolvedJavaMethod targetMethod) {
        LLVMValueRef[] args = (LLVMValueRef[])arguments.stream().map(this::llvmOperand).toArray(LLVMValueRef[]::new);
        return this.gen.getCallArguments(args, callType, targetMethod);
    }

    private LLVMTypeRef getUnknownCallReturnType(LoweredCallTargetNode callTarget) {
        LLVMTypeRef retType = this.gen.getLLVMType(callTarget.returnStamp().getTrustedStamp());
        if (!((SubstrateCallingConventionType)callTarget.callType()).nativeABI && ((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            boolean voidReturnType = LLVMIRBuilder.isVoidType(retType);
            LLVMTypeRef[] returnTypes = new LLVMTypeRef[LLVMGenerator.SpecialRegister.count() + (voidReturnType ? 0 : 1)];
            for (LLVMGenerator.SpecialRegister reg : LLVMGenerator.SpecialRegister.registers()) {
                returnTypes[reg.getIndex()] = this.builder.wordType();
            }
            if (!voidReturnType) {
                returnTypes[LLVMGenerator.SpecialRegister.count()] = retType;
            }
            retType = this.builder.structType(returnTypes);
        }
        return retType;
    }

    private LLVMTypeRef[] getUnknownCallArgumentTypes(LoweredCallTargetNode callTarget) {
        LLVMTypeRef[] types = (LLVMTypeRef[])Arrays.stream(callTarget.signature()).map(argType -> this.gen.getLLVMStackType(this.gen.getTypeKind(argType.resolve(null), false))).toArray(LLVMTypeRef[]::new);
        return this.gen.getUnknownCallArgumentTypes(types, callTarget.callType());
    }

    public void emitReadExceptionObject(ValueNode node) {
        if (!((Boolean)LLVMOptions.ReturnSpecialRegs.getValue()).booleanValue()) {
            this.builder.buildLandingPad();
        }
        LLVMValueRef retrieveExceptionFunction = this.gen.getFunction(LLVMExceptionUnwind.getRetrieveExceptionMethod(this.gen.getMetaAccess()));
        LLVMValueRef[] arguments = this.gen.getCallArguments(new LLVMValueRef[0], (CallingConvention.Type)SubstrateCallingConventionType.JavaCall, null);
        LLVMValueRef exception = this.gen.buildStatepointCall(retrieveExceptionFunction, false, LLVMGenerator.nextPatchpointId.getAndIncrement(), arguments);
        this.setResult(node, exception);
    }

    public void visitBreakpointNode(BreakpointNode i) {
        this.gen.getDebugInfoPrinter().printBreakpoint();
        this.builder.buildDebugtrap();
    }

    public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
        CGlobalDataInfo dataInfo = node.getDataInfo();
        String symbolName = dataInfo.getData().symbolName != null ? dataInfo.getData().symbolName : "global_" + this.gen.getFunctionName() + "#" + this.nextCGlobalId++;
        CGlobalDataReference reference = new CGlobalDataReference(dataInfo);
        if (this.cGlobals.containsKey(symbolName)) {
            assert (reference.getDataInfo().isSymbolReference() != this.cGlobals.get(symbolName).getDataInfo().isSymbolReference());
            if (!reference.getDataInfo().isSymbolReference()) {
                this.cGlobals.put(symbolName, reference);
            }
        } else {
            this.cGlobals.put(symbolName, reference);
        }
        this.setResult((ValueNode)node, this.builder.buildPtrToInt(this.builder.getExternalSymbol(symbolName)));
    }

    public Variable emitReadReturnAddress() {
        LLVMValueRef returnAddress = this.builder.buildReturnAddress(this.builder.constantInt(0));
        return new LLVMUtils.LLVMVariable(returnAddress);
    }

    public LIRFrameState state(DeoptimizingNode deopt) {
        FrameState state;
        if (!deopt.canDeoptimize()) {
            return null;
        }
        if (deopt instanceof DeoptimizingNode.DeoptBefore) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptDuring) && !(deopt instanceof DeoptimizingNode.DeoptAfter));
            state = ((DeoptimizingNode.DeoptBefore)deopt).stateBefore();
        } else if (deopt instanceof DeoptimizingNode.DeoptDuring) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptAfter));
            state = ((DeoptimizingNode.DeoptDuring)deopt).stateDuring();
        } else {
            assert (deopt instanceof DeoptimizingNode.DeoptAfter);
            state = ((DeoptimizingNode.DeoptAfter)deopt).stateAfter();
        }
        assert (state != null);
        return this.debugInfoBuilder.build((NodeWithState)deopt, state, null);
    }

    public void visitSafepointNode(SafepointNode i) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support deoptimization");
    }

    public void visitFullInfopointNode(FullInfopointNode i) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support debug info generation");
    }

    public void emitOverflowCheckBranch(AbstractBeginNode overflowSuccessor, AbstractBeginNode next, Stamp compareStamp, double probability) {
        throw GraalError.unimplemented((String)"the LLVM backend doesn't support deoptimization");
    }

    public Value operand(Node node) {
        return (Value)this.valueMap.get(node);
    }

    private LLVMValueRef llvmOperand(Node node) {
        assert (this.hasOperand(node));
        return this.valueMap.get(node).get();
    }

    public boolean hasOperand(Node node) {
        return this.valueMap.containsKey(node);
    }

    private void setResult(ValueNode node, LLVMValueRef operand) {
        this.setResult(node, (Value)new LLVMUtils.LLVMVariable(operand));
    }

    public Value setResult(ValueNode node, Value operand) {
        LLVMUtils.LLVMValueWrapper llvmOperand;
        boolean typeOverride = false;
        if (operand instanceof LLVMUtils.LLVMValueWrapper) {
            llvmOperand = (LLVMUtils.LLVMValueWrapper)operand;
        } else if (operand instanceof ConstantValue) {
            llvmOperand = new LLVMUtils.LLVMVariable(this.builder.constantNull(((LLVMUtils.LLVMKind)operand.getPlatformKind()).get()));
        } else if (operand instanceof LLVMAddressLowering.LLVMAddressValue) {
            LLVMAddressLowering.LLVMAddressValue addressValue = (LLVMAddressLowering.LLVMAddressValue)operand;
            Value wrappedBase = addressValue.getBase();
            Value index = addressValue.getIndex();
            if (wrappedBase instanceof LLVMUtils.LLVMPendingSpecialRegisterRead) {
                LLVMUtils.LLVMPendingSpecialRegisterRead pendingRead = (LLVMUtils.LLVMPendingSpecialRegisterRead)wrappedBase;
                if (index != null && index != Value.ILLEGAL) {
                    pendingRead = new LLVMUtils.LLVMPendingSpecialRegisterRead(pendingRead, LLVMUtils.getVal(addressValue.getIndex()));
                }
                llvmOperand = pendingRead;
            } else {
                LLVMValueRef base = LLVMUtils.getVal(wrappedBase);
                LLVMTypeRef baseType = LLVMIRBuilder.typeOf(base);
                if (LLVMIRBuilder.isWordType(baseType)) {
                    base = this.builder.buildIntToPtr(base, this.builder.rawPointerType());
                } else if (LLVMIRBuilder.isObjectType(baseType)) {
                    typeOverride = true;
                } else {
                    throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpValues("unsupported base for address", base));
                }
                LLVMValueRef intermediate = index == null || index == Value.ILLEGAL ? base : this.builder.buildGEP(base, LLVMUtils.getVal(index));
                llvmOperand = new LLVMUtils.LLVMVariable(intermediate);
            }
        } else if (operand instanceof RegisterValue) {
            RegisterValue registerValue = (RegisterValue)operand;
            llvmOperand = (LLVMUtils.LLVMValueWrapper)this.gen.emitReadRegister(registerValue.getRegister(), registerValue.getValueKind());
        } else {
            throw GraalError.shouldNotReachHere((String)("unknown operand: " + operand.toString()));
        }
        assert (typeOverride || LLVMIRBuilder.compatibleTypes(this.getLLVMType(node), LLVMIRBuilder.typeOf(llvmOperand.get()))) : LLVMUtils.dumpValues("value type doesn't match node stamp (" + node.stamp(NodeView.DEFAULT).toString() + ")", llvmOperand.get());
        this.gen.getDebugInfoPrinter().setValueName(llvmOperand, node);
        this.valueMap.put((Node)node, llvmOperand);
        return operand;
    }

    public ValueNode valueForOperand(Value value) {
        throw GraalError.unimplemented();
    }
}

